/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.storage.IWriter;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractChainedDataProcessor
extends AbstractDataProcessor {
    private static final long serialVersionUID = 4799747830133168646L;
    private List<AbstractDataProcessor> dataProcessors;

    public AbstractChainedDataProcessor() {
        this.dataProcessors = new ArrayList<AbstractDataProcessor>();
    }

    public AbstractChainedDataProcessor(List<AbstractDataProcessor> dataProcessors) {
        this.dataProcessors = dataProcessors;
    }

    @Override
    protected Collection<Future<Void>> processData(DefaultData defaultData) {
        if (this.shouldBePassedToChainedProcessors(defaultData)) {
            return this.passToChainedProcessors(defaultData);
        }
        return Collections.emptyList();
    }

    protected Collection<Future<Void>> passToChainedProcessors(DefaultData defaultData) {
        if (null != this.dataProcessors) {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (AbstractDataProcessor dataProcessor : this.dataProcessors) {
                futures.addAll(dataProcessor.process(defaultData));
            }
            return futures;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Future<Void>> flush() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (AbstractDataProcessor abstractDataProcessor : this.dataProcessors) {
            futures.addAll(abstractDataProcessor.flush());
        }
        return futures;
    }

    protected abstract boolean shouldBePassedToChainedProcessors(DefaultData var1);

    @Override
    public void setStorageWriter(IWriter storageWriter) {
        super.setStorageWriter(storageWriter);
        for (AbstractDataProcessor processor : this.dataProcessors) {
            processor.setStorageWriter(storageWriter);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("chainedProcessors", this.dataProcessors);
        return toStringBuilder.toString();
    }
}

