/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.stream;

import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import info.novatec.inspectit.storage.nio.read.ReadingChannelManager;
import info.novatec.inspectit.storage.nio.stream.AbstractExtendedByteBufferInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Lazy
public class ExtendedByteBufferInputStream
extends AbstractExtendedByteBufferInputStream {
    @Log
    Logger log;
    @Autowired
    private ReadingChannelManager readingChannelManager;
    @Autowired
    private StorageManager storageManager;
    @Autowired
    @Resource(name="storageExecutorService")
    private ExecutorService executorService;
    private IStorageData storageData;
    private List<IStorageDescriptor> descriptors;
    private AtomicInteger nextDescriptorIndex = new AtomicInteger(0);
    private Set<Path> openedChannelPaths = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 1));

    public ExtendedByteBufferInputStream() {
    }

    public ExtendedByteBufferInputStream(IStorageData storageData, List<IStorageDescriptor> descriptors) {
        this(storageData, descriptors, 3);
    }

    public ExtendedByteBufferInputStream(IStorageData storageData, List<IStorageDescriptor> descriptors, int numberOfBuffers) {
        super(numberOfBuffers);
        this.storageData = storageData;
        this.descriptors = descriptors;
    }

    public void prepare() throws IOException {
        super.prepare();
        long totalSize = 0L;
        for (IStorageDescriptor descriptor : this.descriptors) {
            totalSize += descriptor.getSize();
        }
        this.setTotalSize(totalSize);
        this.executorService.execute(new ReadTask());
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        for (Path path : this.openedChannelPaths) {
            this.readingChannelManager.finalizeChannel(path);
        }
    }

    public void setStorageData(IStorageData storageData) {
        this.storageData = storageData;
    }

    public List<IStorageDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<IStorageDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public void setReadingChannelManager(ReadingChannelManager readingChannelManager) {
        this.readingChannelManager = readingChannelManager;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private class ReadTask
    implements Runnable {
        private Lock continueReadLock = new ReentrantLock();
        private Condition canContinueRead = this.continueReadLock.newCondition();
        private AtomicBoolean wait = new AtomicBoolean();

        private ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ExtendedByteBufferInputStream.this.nextDescriptorIndex.get() < ExtendedByteBufferInputStream.this.descriptors.size()) {
                IStorageDescriptor storageDescriptor = (IStorageDescriptor)ExtendedByteBufferInputStream.this.descriptors.get(ExtendedByteBufferInputStream.this.nextDescriptorIndex.get());
                Path channelPath = ExtendedByteBufferInputStream.this.storageManager.getChannelPath(ExtendedByteBufferInputStream.this.storageData, storageDescriptor);
                ExtendedByteBufferInputStream.this.openedChannelPaths.add(channelPath);
                long readPosition = storageDescriptor.getPosition();
                long readSize = 0L;
                while (readSize < storageDescriptor.getSize()) {
                    ByteBuffer buffer = null;
                    try {
                        buffer = (ByteBuffer)ExtendedByteBufferInputStream.this.getEmptyBuffers().take();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    buffer.clear();
                    final ByteBuffer finalByteBuffer = buffer;
                    long singleReadSize = Math.min(storageDescriptor.getSize() - readSize, (long)buffer.capacity());
                    WriteReadCompletionRunnable completionRunnable = new WriteReadCompletionRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (this.isCompleted()) {
                                ExtendedByteBufferInputStream.this.getFullBuffers().add(finalByteBuffer);
                            } else {
                                finalByteBuffer.clear();
                                ExtendedByteBufferInputStream.this.getEmptyBuffers().add(finalByteBuffer);
                                ExtendedByteBufferInputStream.this.setTotalSize(ExtendedByteBufferInputStream.this.getTotalSize() - this.getAttemptedWriteReadSize());
                            }
                            ReadTask.this.continueReadLock.lock();
                            try {
                                ReadTask.this.wait.set(false);
                                ReadTask.this.canContinueRead.signal();
                            }
                            finally {
                                ReadTask.this.continueReadLock.unlock();
                            }
                        }
                    };
                    try {
                        this.wait.set(true);
                        ExtendedByteBufferInputStream.this.readingChannelManager.read(finalByteBuffer, readPosition, singleReadSize, channelPath, completionRunnable);
                        readPosition += singleReadSize;
                        if ((readSize += singleReadSize) >= storageDescriptor.getSize()) continue;
                        while (this.wait.get()) {
                            this.continueReadLock.lock();
                            try {
                                this.canContinueRead.awaitNanos(5000L);
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                            }
                            finally {
                                this.continueReadLock.unlock();
                            }
                        }
                    }
                    catch (IOException e) {
                        ExtendedByteBufferInputStream.this.log.warn("Exception occurred trying to read in the ReadTask.", (Throwable)e);
                    }
                }
                ExtendedByteBufferInputStream.this.nextDescriptorIndex.incrementAndGet();
            }
        }
    }
}

