/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.restriction.impl;

import info.novatec.inspectit.indexing.restriction.IIndexQueryRestriction;
import info.novatec.inspectit.indexing.restriction.IIndexQueryRestrictionProcessor;
import info.novatec.inspectit.spring.logger.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CachingIndexQueryRestrictionProcessor
implements IIndexQueryRestrictionProcessor {
    @Log
    Logger log;
    private final ConcurrentHashMap<Integer, Method> cacheMap = new ConcurrentHashMap();
    private Method markerMethod;

    public CachingIndexQueryRestrictionProcessor() {
        try {
            this.markerMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Method toString() can not be found", e);
        }
    }

    @Override
    public boolean areAllRestrictionsFulfilled(Object object, List<IIndexQueryRestriction> restrictions) {
        for (IIndexQueryRestriction indexingRestriction : restrictions) {
            if (this.isRestrictionFulfilled(object, indexingRestriction)) continue;
            return false;
        }
        return true;
    }

    private boolean isRestrictionFulfilled(Object object, IIndexQueryRestriction indexingRestriction) {
        List methodNames = indexingRestriction.getQualifiedMethodNames();
        try {
            Object executeOn = object;
            for (String methodName : methodNames) {
                Method method = this.getMethod(executeOn, methodName);
                if (null == method) {
                    return false;
                }
                executeOn = method.invoke(executeOn, new Object[0]);
            }
            return indexingRestriction.isFulfilled(executeOn);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.log.error("Error in find object to execute indexing restricton check.", (Throwable)e);
            return false;
        }
    }

    private Method getMethod(Object object, String methodName) {
        int cacheKey = this.getMethodCacheKey(object.getClass(), methodName);
        Method method = this.cacheMap.get(cacheKey);
        if (method == null) {
            try {
                Method methodFromClass = object.getClass().getMethod(methodName, new Class[0]);
                Method existing = this.cacheMap.putIfAbsent(cacheKey, methodFromClass);
                if (null != existing) {
                    methodFromClass = existing;
                }
                return methodFromClass;
            }
            catch (NoSuchMethodException e) {
                this.cacheMap.putIfAbsent(cacheKey, this.markerMethod);
                return null;
            }
            catch (IllegalArgumentException | SecurityException e) {
                this.log.error("Error retrieve the method " + methodName + " for the object of class " + object.getClass(), (Throwable)e);
                return null;
            }
        }
        if (this.markerMethod.equals(method)) {
            return null;
        }
        return method;
    }

    private int getMethodCacheKey(Class<?> clazz, String methodName) {
        int prime = 31;
        int result = 0;
        result = 31 * result + (clazz == null ? 0 : clazz.hashCode());
        result = 31 * result + (methodName == null ? 0 : methodName.hashCode());
        return result;
    }
}

