/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service.cache;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.exception.BusinessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CachedDataService
implements InitializingBean,
ICachedDataService {
    private static final Logger LOG = LoggerFactory.getLogger(CachedDataService.class);
    @Autowired
    private IGlobalDataAccessService globalDataAccessService;
    private Map<Long, PlatformIdent> platformMap = new ConcurrentHashMap<Long, PlatformIdent>();
    private Map<Long, SensorTypeIdent> sensorTypeMap = new ConcurrentHashMap<Long, SensorTypeIdent>();
    private Map<Long, MethodIdent> methodMap = new ConcurrentHashMap<Long, MethodIdent>();
    private Map<Long, JmxDefinitionDataIdent> jmxDefinitionDataMap = new ConcurrentHashMap<Long, JmxDefinitionDataIdent>();

    public CachedDataService() {
    }

    public CachedDataService(IGlobalDataAccessService globalDataAccessService) {
        this.globalDataAccessService = globalDataAccessService;
    }

    protected void postRefreshIdents() {
    }

    public void triggerRefreshIdents() {
        this.refreshIdents();
        this.postRefreshIdents();
    }

    public void refreshData(PlatformIdent platformIdent) {
        this.platformMap.remove(platformIdent.getId());
        this.platformMap.put(platformIdent.getId(), platformIdent);
        for (MethodIdent methodIdent : platformIdent.getMethodIdents()) {
            this.methodMap.remove(methodIdent.getId());
            this.methodMap.put(methodIdent.getId(), methodIdent);
        }
        for (SensorTypeIdent sensorTypeIdent : platformIdent.getSensorTypeIdents()) {
            this.sensorTypeMap.remove(sensorTypeIdent.getId());
            this.sensorTypeMap.put(sensorTypeIdent.getId(), sensorTypeIdent);
        }
        for (JmxDefinitionDataIdent jmxDefinitionDataIdent : platformIdent.getJmxDefinitionDataIdents()) {
            this.jmxDefinitionDataMap.remove(jmxDefinitionDataIdent.getId());
            this.jmxDefinitionDataMap.put(jmxDefinitionDataIdent.getId(), jmxDefinitionDataIdent);
        }
    }

    public PlatformIdent getPlatformIdentForId(long platformId) {
        Long id = platformId;
        if (0L != id && !this.platformMap.containsKey(id)) {
            this.refreshIdents();
        }
        return this.platformMap.get(id);
    }

    public SensorTypeIdent getSensorTypeIdentForId(long sensorTypeId) {
        Long id = sensorTypeId;
        if (0L != id && !this.sensorTypeMap.containsKey(id)) {
            this.refreshIdents();
        }
        return this.sensorTypeMap.get(id);
    }

    public MethodIdent getMethodIdentForId(long methodId) {
        Long id = methodId;
        if (0L != id && !this.methodMap.containsKey(id)) {
            this.refreshIdents();
        }
        return this.methodMap.get(id);
    }

    public JmxDefinitionDataIdent getJmxDefinitionDataIdentForId(long jmxDefinitionDataId) {
        Long id = jmxDefinitionDataId;
        if (0L != id && !this.jmxDefinitionDataMap.containsKey(id)) {
            this.refreshIdents();
        }
        return this.jmxDefinitionDataMap.get(id);
    }

    protected void refreshIdents() {
        Map<PlatformIdent, AgentStatusData> agentMap = this.globalDataAccessService.getAgentsOverview();
        this.platformMap.clear();
        this.methodMap.clear();
        this.sensorTypeMap.clear();
        this.jmxDefinitionDataMap.clear();
        for (PlatformIdent overview : agentMap.keySet()) {
            PlatformIdent platformIdent;
            try {
                platformIdent = this.globalDataAccessService.getCompleteAgent(overview.getId());
            }
            catch (BusinessException e) {
                LOG.warn("Exception occurred trying to refresh sensor information for the agent " + overview.getAgentName() + ".", (Throwable)e);
                continue;
            }
            this.platformMap.put(platformIdent.getId(), platformIdent);
            for (MethodIdent methodIdent : platformIdent.getMethodIdents()) {
                this.methodMap.put(methodIdent.getId(), methodIdent);
            }
            for (SensorTypeIdent sensorTypeIdent : platformIdent.getSensorTypeIdents()) {
                this.sensorTypeMap.put(sensorTypeIdent.getId(), sensorTypeIdent);
            }
            for (JmxDefinitionDataIdent jmxDefinitionDataIdent : platformIdent.getJmxDefinitionDataIdents()) {
                this.jmxDefinitionDataMap.put(jmxDefinitionDataIdent.getId(), jmxDefinitionDataIdent);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshIdents();
    }
}

