/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.stream;

import info.novatec.inspectit.storage.nio.stream.AbstractExtendedByteBufferInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Lazy
public class SocketExtendedByteBufferInputStream
extends AbstractExtendedByteBufferInputStream {
    private SocketChannel socketChannel;
    @Autowired
    @Qualifier(value="socketReadExecutorService")
    private ExecutorService executorService;

    public void prepare() throws IOException {
        super.prepare();
        if (this.getTotalSize() > 0L) {
            this.executorService.execute(new SocketReadRunnable(this.getTotalSize()));
        }
    }

    public synchronized void reset(int length) {
        while (!this.getFullBuffers().isEmpty()) {
            ByteBuffer byteBuffer = this.getFullBuffers().poll();
            if (null == byteBuffer) continue;
            byteBuffer.clear();
            this.getEmptyBuffers().add(byteBuffer);
        }
        this.setTotalSize(length);
        this.setPosition(0L);
        this.executorService.execute(new SocketReadRunnable(length));
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private class SocketReadRunnable
    implements Runnable {
        private int totalRead;
        private final long length;

        SocketReadRunnable(long length) {
            this.length = length;
        }

        public void run() {
            long bytesLeft;
            while ((bytesLeft = this.length - (long)this.totalRead) != 0L) {
                ByteBuffer byteBuffer = null;
                try {
                    byteBuffer = SocketExtendedByteBufferInputStream.this.getEmptyBuffers().take();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (null == byteBuffer) continue;
                byteBuffer.clear();
                if ((long)byteBuffer.remaining() > bytesLeft) {
                    byteBuffer.limit((int)bytesLeft);
                }
                try {
                    int read = SocketExtendedByteBufferInputStream.this.socketChannel.read(byteBuffer);
                    if (read > 0) {
                        byteBuffer.flip();
                        SocketExtendedByteBufferInputStream.this.getFullBuffers().add(byteBuffer);
                        this.totalRead += read;
                        continue;
                    }
                    byteBuffer.clear();
                    SocketExtendedByteBufferInputStream.this.getEmptyBuffers().add(byteBuffer);
                }
                catch (IOException e) {
                    byteBuffer.clear();
                    SocketExtendedByteBufferInputStream.this.getEmptyBuffers().add(byteBuffer);
                }
            }
        }
    }
}

