/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.jpa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.AttributeConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStringConverter
implements AttributeConverter<List<?>, String> {
    private static final char DELIMITER = '\u00a6';

    public String convertToDatabaseColumn(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Object object : list) {
                stringBuilder.append(object);
                stringBuilder.append('\u00a6');
            }
        }
        return stringBuilder.toString();
    }

    public List<?> convertToEntityAttribute(String dbValue) {
        if (StringUtils.isNotEmpty((String)dbValue)) {
            Object[] split = StringUtils.splitPreserveAllTokens((String)dbValue, (char)'\u00a6');
            return Arrays.asList(ArrayUtils.subarray((Object[])split, (int)0, (int)(split.length - 1)));
        }
        return Collections.emptyList();
    }
}

