/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table
public class DatabaseAggregatedTimerData
extends TimerData {
    private static final long serialVersionUID = 3139731190115609664L;

    public DatabaseAggregatedTimerData() {
    }

    public DatabaseAggregatedTimerData(Timestamp timestamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timestamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public void aggregateTimerData(TimerData timerData) {
        this.setCount(this.getCount() + timerData.getCount());
        this.setDuration(this.getDuration() + timerData.getDuration());
        this.calculateMax(timerData.getMax());
        this.calculateMin(timerData.getMin());
        if (timerData.isCpuMetricDataAvailable()) {
            this.setCpuDuration(this.getCpuDuration() + timerData.getCpuDuration());
            this.calculateCpuMin(timerData.getCpuMin());
            this.calculateCpuMax(timerData.getCpuMax());
        }
        if (timerData.isExclusiveTimeDataAvailable()) {
            this.addExclusiveDuration(timerData.getExclusiveDuration());
            this.setExclusiveCount(this.getExclusiveCount() + timerData.getExclusiveCount());
            this.calculateExclusiveMin(timerData.getExclusiveMin());
            this.calculateExclusiveMax(timerData.getExclusiveMax());
        }
    }
}

