/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.indexing.IIndexQuery;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public abstract class MethodSensorData
extends DefaultData {
    private static final long serialVersionUID = 7655082885002510364L;
    private long methodIdent;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<ParameterContentData> parameterContentData;

    public MethodSensorData() {
    }

    public MethodSensorData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
        this.methodIdent = methodIdent;
    }

    public MethodSensorData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData) {
        this(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
        if (null != parameterContentData) {
            this.parameterContentData = new HashSet<ParameterContentData>(parameterContentData);
        }
    }

    public long getMethodIdent() {
        return this.methodIdent;
    }

    public void setMethodIdent(long methodIdent) {
        this.methodIdent = methodIdent;
    }

    public void addParameterContentData(ParameterContentData parameterContent) {
        if (null == this.parameterContentData) {
            this.parameterContentData = new HashSet<ParameterContentData>();
        }
        this.parameterContentData.add(parameterContent);
    }

    public Set<ParameterContentData> getParameterContentData() {
        return this.parameterContentData;
    }

    public void setParameterContentData(Set<ParameterContentData> parameterContentData) {
        this.parameterContentData = parameterContentData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.methodIdent ^ this.methodIdent >>> 32);
        result = 31 * result + (this.parameterContentData == null ? 0 : this.parameterContentData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSensorData other = (MethodSensorData)obj;
        if (this.methodIdent != other.methodIdent) {
            return false;
        }
        return !(this.parameterContentData == null ? other.parameterContentData != null : !this.parameterContentData.equals(other.parameterContentData));
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 1, 0);
        if (this.parameterContentData instanceof HashSet) {
            size += objectSizes.getSizeOfHashSet(this.parameterContentData.size(), 0);
            for (ParameterContentData paramContentData : this.parameterContentData) {
                size += objectSizes.getSizeOf(paramContentData);
            }
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public boolean isQueryComplied(IIndexQuery query) {
        if (query.getMethodIdent() != 0L && query.getMethodIdent() != this.methodIdent) {
            return false;
        }
        return super.isQueryComplied(query);
    }
}

