/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.model;

import info.novatec.inspectit.cmr.model.MethodIdentToSensorType;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.jpa.ListStringConverter;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="MethodIdent.findAll", query="SELECT m FROM MethodIdent m"), @NamedQuery(name="MethodIdent.findByPlatformAndExample", query="SELECT m from MethodIdent m JOIN m.platformIdent p WHERE p.id=:platformIdent AND NULLIF(m.packageName,'null')=:packageName AND m.className=:className AND m.methodName=:methodName AND m.returnType=:returnType ")})
public class MethodIdent
implements Serializable {
    private static final long serialVersionUID = 5670026321320934522L;
    public static final String FIND_ALL = "MethodIdent.findAll";
    public static final String FIND_BY_PLATFORM_AND_EXAMPLE = "MethodIdent.findByPlatformAndExample";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="METHOD_IDENT_SEQUENCE")
    @SequenceGenerator(name="METHOD_IDENT_SEQUENCE", sequenceName="METHOD_IDENT_SEQUENCE")
    private Long id;
    @NotNull
    private Timestamp timeStamp;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="methodIdent", orphanRemoval=true)
    private Set<MethodIdentToSensorType> methodIdentToSensorTypes = new HashSet<MethodIdentToSensorType>(0);
    @ManyToOne
    private PlatformIdent platformIdent;
    private String packageName;
    @NotNull
    private String className;
    @NotNull
    private String methodName;
    @Convert(converter=ListStringConverter.class)
    @Column(length=2000)
    private List<String> parameters = new ArrayList<String>(0);
    private String returnType;
    private int modifiers;

    public boolean hasActiveSensorTypes() {
        for (MethodIdentToSensorType methodIdentToSensorType : this.methodIdentToSensorTypes) {
            if (!methodIdentToSensorType.isActive()) continue;
            return true;
        }
        return false;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Timestamp getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Set<MethodIdentToSensorType> getMethodIdentToSensorTypes() {
        return this.methodIdentToSensorTypes;
    }

    public void setMethodIdentToSensorTypes(Set<MethodIdentToSensorType> methodIdentToSensorTypes) {
        this.methodIdentToSensorTypes = methodIdentToSensorTypes;
    }

    public PlatformIdent getPlatformIdent() {
        return this.platformIdent;
    }

    public void setPlatformIdent(PlatformIdent platformIdent) {
        this.platformIdent = platformIdent;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getFQN() {
        return this.packageName + '.' + this.className;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + this.modifiers;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodIdent other = (MethodIdent)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.modifiers != other.modifiers) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        return !(this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp));
    }

    public String toString() {
        return this.packageName + "." + this.className + "#" + this.methodName + this.parameters + " : " + this.returnType;
    }
}

