/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.composite.StorageInfoComposite;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class UploadStorageWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Select CMR (Central Management Repository) to upload storage to";
    private LocalStorageData localStorageData;
    private List<CmrRepositoryDefinition> cmrRepositories;
    private Combo cmrRepositoryCombo;
    private boolean alreadyAvailable;
    private boolean enoughSpace;
    private List<StorageData> storagesOnRepository;
    private long spaceLeftOnCmr;

    public UploadStorageWizardPage(LocalStorageData localStorageData) {
        super("Upload Storage");
        Assert.isNotNull((Object)localStorageData);
        this.localStorageData = localStorageData;
        this.cmrRepositories = new ArrayList<CmrRepositoryDefinition>();
        this.cmrRepositories.addAll(InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions());
        this.setTitle("Upload Storage");
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 16384);
        label.setText("Upload CMR:");
        this.cmrRepositoryCombo = new Combo(composite2, 8);
        this.cmrRepositoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        for (CmrRepositoryDefinition object2 : this.cmrRepositories) {
            this.cmrRepositoryCombo.add(String.valueOf(object2.getName()) + " (" + object2.getIp() + ":" + object2.getPort() + ")");
        }
        StorageInfoComposite storageInfoComposite = new StorageInfoComposite(composite2, 0, false, (IStorageData)this.localStorageData);
        storageInfoComposite.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                boolean bl = UploadStorageWizardPage.this.isPageComplete();
                UploadStorageWizardPage.this.setPageComplete(bl);
                if (event.widget.equals(UploadStorageWizardPage.this.cmrRepositoryCombo) && UploadStorageWizardPage.this.cmrRepositoryCombo.getSelectionIndex() == -1) {
                    UploadStorageWizardPage.this.setMessage("Repository must be selected", 3);
                    return;
                }
                if (event.widget.equals(UploadStorageWizardPage.this.cmrRepositoryCombo) && UploadStorageWizardPage.this.getCmrRepositoryDefinition().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    UploadStorageWizardPage.this.setMessage("The selected repository is currently unavailable", 3);
                } else if (UploadStorageWizardPage.this.alreadyAvailable) {
                    UploadStorageWizardPage.this.setMessage("The selected storage to upload is already available on the selected repository", 3);
                } else if (!UploadStorageWizardPage.this.enoughSpace) {
                    UploadStorageWizardPage.this.setMessage("Insufficient storage space left on the selected repository", 3);
                } else {
                    String string = UploadStorageWizardPage.this.getCmrRepositoryDefinition().getVersion();
                    if (UploadStorageWizardPage.this.localStorageData.getCmrVersion() == null) {
                        UploadStorageWizardPage.this.setMessage("Selected storage does not define CMR version. The storage might be unstable on the CMR version " + string + ".", 2);
                    } else if (!ObjectUtils.equals((Object)UploadStorageWizardPage.this.localStorageData.getCmrVersion(), (Object)string)) {
                        UploadStorageWizardPage.this.setMessage("Selected storage has different CMR version than the current CMR version " + string + ". The storage might be unstable.", 2);
                    } else {
                        UploadStorageWizardPage.this.setMessage(UploadStorageWizardPage.DEFAULT_MESSAGE);
                    }
                }
            }
        };
        Listener listener2 = new Listener(){

            public void handleEvent(final Event event) {
                final CmrRepositoryDefinition cmrRepositoryDefinition = UploadStorageWizardPage.this.getCmrRepositoryDefinition();
                Job job = new Job("Loading CMR Storage Data"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        CmrRepositoryDefinition.OnlineStatus onlineStatus = cmrRepositoryDefinition.getOnlineStatus();
                        if (onlineStatus != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                            UploadStorageWizardPage.this.storagesOnRepository = cmrRepositoryDefinition.getStorageService().getExistingStorages();
                            UploadStorageWizardPage.this.spaceLeftOnCmr = cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData().getStorageDataSpaceLeft();
                        } else {
                            UploadStorageWizardPage.this.storagesOnRepository = Collections.emptyList();
                            UploadStorageWizardPage.this.spaceLeftOnCmr = 0L;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                listener.handleEvent(event);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        this.cmrRepositoryCombo.addListener(13, listener2);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.cmrRepositoryCombo.getSelectionIndex() == -1) {
            return false;
        }
        if (this.getCmrRepositoryDefinition().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return false;
        }
        for (StorageData storageData : this.storagesOnRepository) {
            if (!Objects.equals(storageData.getId(), this.localStorageData.getId())) continue;
            this.alreadyAvailable = true;
            return false;
        }
        this.alreadyAvailable = false;
        boolean bl = this.enoughSpace = this.spaceLeftOnCmr > this.localStorageData.getDiskSize();
        return this.enoughSpace;
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        if (this.cmrRepositoryCombo.getSelectionIndex() != -1) {
            return this.cmrRepositories.get(this.cmrRepositoryCombo.getSelectionIndex());
        }
        return null;
    }
}

