/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.composite.StorageInfoComposite;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImportStorageInfoPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Preview storage data before import";
    private boolean importLocally;
    private String fileName;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private boolean canImport = false;
    private Label file;
    private Label importTo;
    private Composite main;
    private StorageInfoComposite storageInfoComposite;

    public ImportStorageInfoPage() {
        super("Import Storage");
        this.setTitle("Import Storage");
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createControl(Composite composite) {
        this.main = new Composite(composite, 0);
        this.main.setLayout((Layout)new GridLayout(2, false));
        new Label(this.main, 0).setText("Selected file:");
        this.file = new Label(this.main, 64);
        new Label(this.main, 0).setText("Import to:");
        this.importTo = new Label(this.main, 64);
        this.storageInfoComposite = new StorageInfoComposite(this.main, 0, false);
        this.storageInfoComposite.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.setControl((Control)this.main);
    }

    public void update() {
        this.reset();
        Job job = new Job("Update Import Storage Info Page"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                boolean bl = !ImportStorageInfoPage.this.importLocally && ImportStorageInfoPage.this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE;
                final List list = bl ? ImportStorageInfoPage.this.cmrRepositoryDefinition.getStorageService().getExistingStorages() : Collections.emptyList();
                final long l = bl ? ImportStorageInfoPage.this.cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData().getStorageDataSpaceLeft() : 0L;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ImportStorageInfoPage.this.fileName == null) {
                            ImportStorageInfoPage.this.canImport = false;
                        } else {
                            ImportStorageInfoPage.this.file.setText(ImportStorageInfoPage.this.fileName);
                            if (ImportStorageInfoPage.this.importLocally) {
                                ImportStorageInfoPage.this.importTo.setText("Import locally");
                            } else {
                                ImportStorageInfoPage.this.importTo.setText(ImportStorageInfoPage.this.cmrRepositoryDefinition.getName());
                            }
                            InspectITStorageManager inspectITStorageManager = InspectIT.getDefault().getInspectITStorageManager();
                            IStorageData iStorageData = inspectITStorageManager.getStorageDataFromZip(ImportStorageInfoPage.this.fileName);
                            if (iStorageData != null) {
                                ImportStorageInfoPage.this.storageInfoComposite.displayStorageData(iStorageData);
                                if (ImportStorageInfoPage.this.importLocally) {
                                    boolean bl = true;
                                    for (LocalStorageData localStorageData : inspectITStorageManager.getDownloadedStorages()) {
                                        if (!ObjectUtils.equals((Object)localStorageData.getId(), (Object)iStorageData.getId())) continue;
                                        bl = false;
                                        break;
                                    }
                                    if (bl) {
                                        ImportStorageInfoPage.this.canImport = true;
                                        ImportStorageInfoPage.this.setMessage(ImportStorageInfoPage.DEFAULT_MESSAGE);
                                    } else {
                                        ImportStorageInfoPage.this.canImport = false;
                                        ImportStorageInfoPage.this.setMessage("Selected storage to import is already available locally", 3);
                                    }
                                } else if (ImportStorageInfoPage.this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                                    boolean bl;
                                    boolean bl2 = true;
                                    for (StorageData storageData : list) {
                                        if (!ObjectUtils.equals((Object)storageData.getId(), (Object)iStorageData.getId())) continue;
                                        bl2 = false;
                                        break;
                                    }
                                    boolean bl3 = bl = l > iStorageData.getDiskSize();
                                    if (bl2 && bl) {
                                        ImportStorageInfoPage.this.canImport = true;
                                        String string = ImportStorageInfoPage.this.cmrRepositoryDefinition.getVersion();
                                        if (iStorageData.getCmrVersion() == null) {
                                            ImportStorageInfoPage.this.setMessage("Selected storage does not define CMR version. The storage might be unstable on the CMR version " + (String)string + ".", 2);
                                        } else if (!ObjectUtils.equals((Object)iStorageData.getCmrVersion(), (Object)string)) {
                                            ImportStorageInfoPage.this.setMessage("Selected storage has different CMR version than the current CMR version " + (String)string + ". The storage might be unstable.", 2);
                                        } else {
                                            ImportStorageInfoPage.this.setMessage(ImportStorageInfoPage.DEFAULT_MESSAGE);
                                        }
                                    } else if (!bl2) {
                                        ImportStorageInfoPage.this.canImport = false;
                                        ImportStorageInfoPage.this.setMessage("Selected storage to import is already available on selected CMR", 3);
                                    } else if (!bl) {
                                        ImportStorageInfoPage.this.canImport = false;
                                        ImportStorageInfoPage.this.setMessage("Insufficient storage space of the selected repository (" + NumberFormatter.humanReadableByteCount(l) + " left)", 3);
                                    }
                                } else {
                                    ImportStorageInfoPage.this.canImport = false;
                                    ImportStorageInfoPage.this.setMessage("Can not import storage to selected CMR because the CMR is offline", 3);
                                }
                            } else {
                                ImportStorageInfoPage.this.storageInfoComposite.showDataUnavailable();
                                ImportStorageInfoPage.this.canImport = false;
                                ImportStorageInfoPage.this.setMessage("Provided file is not valid inspectIT compressed storage file", 3);
                            }
                            ImportStorageInfoPage.this.main.layout();
                            ImportStorageInfoPage.this.main.update();
                        }
                        ImportStorageInfoPage.this.setPageComplete(ImportStorageInfoPage.this.isPageComplete());
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void reset() {
        this.canImport = false;
        this.setPageComplete(false);
    }

    public boolean isPageComplete() {
        return this.canImport;
    }

    public void setImportLocally(boolean bl) {
        this.importLocally = bl;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setCmrRepositoryDefinition(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }
}

