/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.impl.TimeFrameDataProcessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DefineTimelineWizardPage
extends WizardPage {
    public static final int FUTURE = 1;
    public static final int PAST = 2;
    public static final int BOTH_DATES = 4;
    private static final Map<Character, Integer> PERIOD_MULTIPLIERS_MAP = new HashMap<Character, Integer>(4);
    private int timeStyle;
    private Button useTimeframe;
    private Button definePeriod;
    private Button defineDate;
    private CDateTime cdtPrimary;
    private CDateTime cdtSecondary;
    private Text periodAmount;
    private Group group;
    private Composite main;
    private Composite periodComposite;
    private Composite cdtComposite;
    private Listener pageCompleteListener = new Listener(){

        public void handleEvent(Event event) {
            DefineTimelineWizardPage.this.setPageComplete(DefineTimelineWizardPage.this.isPageComplete());
        }
    };
    private String defaultMessage;

    static {
        PERIOD_MULTIPLIERS_MAP.put(Character.valueOf('m'), 1);
        PERIOD_MULTIPLIERS_MAP.put(Character.valueOf('h'), 60);
        PERIOD_MULTIPLIERS_MAP.put(Character.valueOf('d'), 1440);
        PERIOD_MULTIPLIERS_MAP.put(Character.valueOf('w'), 10080);
    }

    public DefineTimelineWizardPage(String string, String string2, int n) {
        super(string);
        this.setTitle(string);
        this.setMessage(string2);
        this.timeStyle = n;
        this.defaultMessage = string2;
    }

    public void createControl(Composite composite) {
        this.main = new Composite(composite, 0);
        this.main.setLayout((Layout)new GridLayout(1, false));
        this.useTimeframe = new Button(this.main, 32);
        this.useTimeframe.setText("Use timeframe limiting");
        this.useTimeframe.setSelection(false);
        this.group = new Group(this.main, 0);
        this.group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.definePeriod = new Button((Composite)this.group, 16);
        this.definePeriod.setText("Enter wanted time period");
        this.definePeriod.setSelection(true);
        this.defineDate = new Button((Composite)this.group, 16);
        this.defineDate.setText("Selected exact date");
        if ((this.timeStyle & 4) != 0) {
            this.defineDate.setText(String.valueOf(this.defineDate.getText()) + "s");
        }
        this.defineDate.setSelection(false);
        this.useTimeframe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DefineTimelineWizardPage.this.useTimeframe.getSelection()) {
                    DefineTimelineWizardPage.this.enableControlAndChildren((Composite)DefineTimelineWizardPage.this.group, true);
                } else {
                    DefineTimelineWizardPage.this.enableControlAndChildren((Composite)DefineTimelineWizardPage.this.group, false);
                }
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefineTimelineWizardPage.this.updatePage();
            }
        };
        this.defineDate.addSelectionListener((SelectionListener)selectionAdapter);
        this.definePeriod.addSelectionListener((SelectionListener)selectionAdapter);
        this.useTimeframe.addListener(13, this.pageCompleteListener);
        this.defineDate.addListener(13, this.pageCompleteListener);
        this.definePeriod.addListener(13, this.pageCompleteListener);
        this.updatePage();
        this.enableControlAndChildren((Composite)this.group, false);
        this.setControl((Control)this.main);
    }

    public boolean isPageComplete() {
        if (this.useTimeframe.getSelection()) {
            if (this.definePeriod.getSelection()) {
                Date date = this.getDateFromPeriodComposite();
                if (date == null) {
                    this.setMessage("Time period has to be entered correctly", 3);
                    return false;
                }
            } else {
                if (this.getFromDate() == null) {
                    this.setMessage("Please enter starting date & time", 3);
                    return false;
                }
                if (this.getToDate() == null) {
                    this.setMessage("Please enter ending date & time", 3);
                    return false;
                }
                if (this.getFromDate().after(this.getToDate())) {
                    if ((this.timeStyle & 4) != 0) {
                        this.setMessage("Start date must be before end date", 3);
                    } else {
                        this.setMessage("Entered date must be a future date", 3);
                    }
                    return false;
                }
            }
        }
        this.setMessage(this.defaultMessage);
        return true;
    }

    public boolean isTimerframeUsed() {
        return this.useTimeframe.getSelection();
    }

    public TimeFrameDataProcessor getTimeFrameDataProcessor(Collection<AbstractDataProcessor> collection) {
        ArrayList<AbstractDataProcessor> arrayList = new ArrayList<AbstractDataProcessor>(collection);
        Date date = this.getFromDate();
        Date date2 = this.getToDate();
        TimeFrameDataProcessor timeFrameDataProcessor = new TimeFrameDataProcessor(date, date2, arrayList);
        return timeFrameDataProcessor;
    }

    public Date getFromDate() {
        if ((this.timeStyle & 1) != 0) {
            if ((this.timeStyle & 4) != 0) {
                return this.cdtPrimary != null ? this.cdtPrimary.getSelection() : null;
            }
            return new Date();
        }
        if (this.definePeriod.getSelection()) {
            return this.getDateFromPeriodComposite();
        }
        return this.cdtPrimary != null ? this.cdtPrimary.getSelection() : null;
    }

    public Date getToDate() {
        if ((this.timeStyle & 1) != 0) {
            if (this.definePeriod.getSelection()) {
                return this.getDateFromPeriodComposite();
            }
            if ((this.timeStyle & 4) != 0) {
                return this.cdtSecondary != null ? this.cdtSecondary.getSelection() : null;
            }
            return this.cdtPrimary != null ? this.cdtPrimary.getSelection() : null;
        }
        if ((this.timeStyle & 4) != 0) {
            return this.cdtSecondary != null ? this.cdtSecondary.getSelection() : null;
        }
        return new Date();
    }

    private void enableControlAndChildren(Composite composite, boolean bl) {
        composite.setEnabled(bl);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(bl);
            if (control instanceof Composite) {
                this.enableControlAndChildren((Composite)control, bl);
            }
            ++n2;
        }
    }

    private void updatePage() {
        if (this.cdtComposite != null && !this.cdtComposite.isDisposed()) {
            this.cdtComposite.dispose();
        }
        if (this.periodComposite != null && !this.periodComposite.isDisposed()) {
            this.periodComposite.dispose();
        }
        if (this.definePeriod.getSelection()) {
            this.periodComposite = new Composite((Composite)this.group, 0);
            this.periodComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.periodComposite.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(this.periodComposite, 0);
            this.periodAmount = new Text(this.periodComposite, 2052);
            this.periodAmount.setLayoutData((Object)new GridData(4, 4, true, false));
            this.periodAmount.addListener(24, this.pageCompleteListener);
            this.periodAmount.setFocus();
            new Label(this.periodComposite, 0).setText("(ex. 2w 4d 12h 30m)");
            if ((this.timeStyle & 1) != 0) {
                label.setText("Next:");
            } else {
                label.setText("Previous:");
            }
        } else {
            this.cdtComposite = new Composite((Composite)this.group, 0);
            this.cdtComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.cdtComposite.setLayout((Layout)new GridLayout(1, true));
            this.cdtPrimary = new CDateTime(this.cdtComposite, 0x2000003);
            this.cdtPrimary.setLayoutData((Object)new GridData(4, 4, true, false));
            this.cdtPrimary.addListener(24, this.pageCompleteListener);
            Calendar calendar = Calendar.getInstance();
            calendar.set(13, 0);
            calendar.set(14, 0);
            if ((this.timeStyle & 1) != 0 && (this.timeStyle & 4) == 0) {
                this.cdtPrimary.setPattern("'Till\t\t' EEEE, MMMM d YYYY '@' h:mm a");
                calendar.add(10, 1);
            } else {
                this.cdtPrimary.setPattern("'From\t' EEEE, MMMM d YYYY '@' h:mm a");
            }
            this.cdtPrimary.setSelection(calendar.getTime());
            if ((this.timeStyle & 4) != 0) {
                this.cdtSecondary = new CDateTime(this.cdtComposite, 0x2000003);
                this.cdtSecondary.setLayoutData((Object)new GridData(4, 4, true, false));
                calendar.add(10, 1);
                this.cdtSecondary.setSelection(calendar.getTime());
                this.cdtSecondary.addListener(24, this.pageCompleteListener);
                this.cdtSecondary.setPattern("'Till\t\t' EEEE, MMMM d YYYY '@' h:mm a");
            }
        }
        this.group.layout();
        this.main.layout();
    }

    private Date getDateFromPeriodComposite() {
        try {
            Calendar calendar = Calendar.getInstance();
            String string = this.periodAmount.getText().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Character c = Character.valueOf(string2.charAt(string2.length() - 1));
                Integer n2 = PERIOD_MULTIPLIERS_MAP.get(c);
                if (n2 == null) continue;
                try {
                    int n3 = Integer.parseInt(string2.substring(0, string2.length() - 1));
                    if (n3 <= 0) continue;
                    n += n3 * n2;
                }
                catch (Exception exception) {}
            }
            if (n > 0) {
                if ((this.timeStyle & 1) != 0) {
                    calendar.add(12, n);
                } else {
                    calendar.add(12, -n);
                }
                return calendar.getTime();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

