/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.page.ManageLabelWizardPage;
import info.novatec.inspectit.storage.label.management.AbstractLabelManagementAction;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ManageLabelWizard
extends Wizard
implements INewWizard {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private ManageLabelWizardPage manageLabelsPage;

    public ManageLabelWizard(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.setWindowTitle("Manage Labels");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/label_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.manageLabelsPage = new ManageLabelWizardPage(this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.manageLabelsPage);
    }

    public boolean performFinish() {
        List<AbstractLabelManagementAction> list = this.manageLabelsPage.getManagementActions();
        if (!list.isEmpty()) {
            if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                try {
                    this.cmrRepositoryDefinition.getStorageService().executeLabelManagementActions(list);
                }
                catch (BusinessException businessException) {
                    InspectIT.getDefault().createErrorDialog("There was an exception trying to execute label management operation.", businessException, -1);
                }
            } else {
                InspectIT.getDefault().createInfoDialog("Can not execute label management operation, selected CMR repository is offline.", -1);
            }
        }
        return true;
    }

    public boolean isShouldRefreshStorages() {
        return this.manageLabelsPage.isShouldRefreshStorages();
    }
}

