/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.ImportStorageInfoPage;
import info.novatec.inspectit.rcp.wizard.page.ImportStorageSelectPage;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.util.ObjectUtils;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class ImportStorageWizard
extends Wizard
implements INewWizard {
    private ImportStorageSelectPage importStorageSelectPage;
    private ImportStorageInfoPage importStorageInfoPage;

    public ImportStorageWizard() {
        this.setWindowTitle("Import Storage");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/import_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.importStorageSelectPage = new ImportStorageSelectPage();
        this.addPage((IWizardPage)this.importStorageSelectPage);
        this.importStorageInfoPage = new ImportStorageInfoPage();
        this.addPage((IWizardPage)this.importStorageInfoPage);
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.importStorageSelectPage))) {
            this.importStorageInfoPage.setFileName(this.importStorageSelectPage.getFileName());
            this.importStorageInfoPage.setImportLocally(this.importStorageSelectPage.isImportLocally());
            this.importStorageInfoPage.setCmrRepositoryDefinition(this.importStorageSelectPage.getCmrRepositoryDefinition());
            this.importStorageInfoPage.update();
        }
        return super.getNextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.importStorageInfoPage))) {
            this.importStorageInfoPage.reset();
        }
        return super.getPreviousPage(iWizardPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.importStorageSelectPage)) {
            return false;
        }
        if (!this.importStorageSelectPage.isPageComplete()) {
            return false;
        }
        return this.importStorageInfoPage.isPageComplete();
    }

    public boolean performFinish() {
        final String string = this.importStorageSelectPage.getFileName();
        final CmrRepositoryDefinition cmrRepositoryDefinition = this.importStorageSelectPage.getCmrRepositoryDefinition();
        boolean bl = this.importStorageSelectPage.isImportLocally();
        if (bl) {
            Job job = new Job("Import Storage"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask("Importing data..", -1);
                    try {
                        InspectIT.getDefault().getInspectITStorageManager().unzipStorageData(string);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                                if (iViewPart instanceof StorageManagerView) {
                                    ((StorageManagerView)iViewPart).refreshWithoutCmrCall();
                                }
                                InspectIT.getDefault().createInfoDialog("Storage successfully imported.", -1);
                            }
                        });
                    }
                    catch (BusinessException | SerializationException | IOException throwable) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred trying to import the storage via file.", throwable);
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/import.gif"));
            job.schedule();
        } else {
            Job job = new Job("Import Storage"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
                    subMonitor.setWorkRemaining(10);
                    InspectITStorageManager inspectITStorageManager = InspectIT.getDefault().getInspectITStorageManager();
                    try {
                        inspectITStorageManager.uploadZippedStorage(string, cmrRepositoryDefinition, subMonitor.newChild(9));
                    }
                    catch (Exception exception) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Storage data was not successfully uploaded to the CMR. Import failed.", (Throwable)exception);
                    }
                    SubMonitor subMonitor2 = subMonitor.newChild(1);
                    subMonitor2.setTaskName("Unpacking data..");
                    try {
                        IStorageData iStorageData = inspectITStorageManager.getStorageDataFromZip(string);
                        cmrRepositoryDefinition.getStorageService().unpackUploadedStorage(iStorageData);
                    }
                    catch (BusinessException businessException) {
                        return new Status(4, "info.novatec.inspectit.rcp", "Storage data was not successfully unpacked on the CMR. Import failed.", (Throwable)businessException);
                    }
                    subMonitor2.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                            if (iViewPart instanceof StorageManagerView) {
                                ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
                            }
                            InspectIT.getDefault().createInfoDialog("Storage data was successfully imported to the CMR.", -1);
                        }
                    });
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/import.gif"));
            job.schedule();
        }
        return true;
    }
}

