/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.statushandlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.dialog.BusinessExceptionDialog;
import info.novatec.inspectit.rcp.dialog.ThrowableDialog;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;

public class CustomStatusHandler
extends WorkbenchErrorHandler {
    public void handle(final StatusAdapter statusAdapter, int n) {
        if (1 == n && statusAdapter.getStatus().getSeverity() == 4) {
            n |= 2;
        }
        if (statusAdapter.getStatus().getException() != null && (statusAdapter.getStatus().getSeverity() == 2 || statusAdapter.getStatus().getSeverity() == 4)) {
            if ((n & 2) == 2 || (n & 4) == 4) {
                if (Display.getCurrent() != null) {
                    this.showErrorDialog(statusAdapter);
                } else {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CustomStatusHandler.this.showErrorDialog(statusAdapter);
                        }
                    });
                }
            }
            if ((n & 1) == 1) {
                StatusManager.getManager().addLoggedStatus(statusAdapter.getStatus());
                WorkbenchPlugin.getDefault().getLog().log(statusAdapter.getStatus());
            }
        } else {
            super.handle(statusAdapter, n);
        }
    }

    protected void showErrorDialog(StatusAdapter statusAdapter) {
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log((IStatus)statusAdapter.getStatus());
            return;
        }
        TitleAreaDialog titleAreaDialog = null;
        if (statusAdapter.getStatus().getException() instanceof BusinessException) {
            titleAreaDialog = new BusinessExceptionDialog(null, (BusinessException)statusAdapter.getStatus().getException());
        } else {
            String string = statusAdapter.getStatus().getMessage();
            if (StringUtils.isEmpty((String)string)) {
                string = statusAdapter.getStatus().getException().getMessage();
            }
            titleAreaDialog = new ThrowableDialog(null, string, statusAdapter.getStatus().getException());
        }
        titleAreaDialog.open();
    }
}

