/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.cmr.service.ISqlDataAccessService;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.indexing.aggregation.Aggregators;
import info.novatec.inspectit.indexing.query.factory.impl.SqlStatementDataQueryFactory;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.repository.service.storage.AbstractStorageService;
import java.util.Date;
import java.util.List;

public class StorageSqlDataAccessService
extends AbstractStorageService<SqlStatementData>
implements ISqlDataAccessService {
    private IStorageTreeComponent<SqlStatementData> indexingTree;
    private SqlStatementDataQueryFactory<StorageIndexQuery> sqlDataQueryFactory;

    public List<SqlStatementData> getAggregatedSqlStatements(SqlStatementData sqlStatementData) {
        return this.getAggregatedSqlStatements(sqlStatementData, null, null);
    }

    public List<SqlStatementData> getAggregatedSqlStatements(SqlStatementData sqlStatementData, Date date, Date date2) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.sqlDataQueryFactory.getAggregatedSqlStatementsQuery(sqlStatementData, date, date2);
        return super.executeQuery(storageIndexQuery, Aggregators.SQL_STATEMENT_DATA_AGGREGATOR);
    }

    public List<SqlStatementData> getParameterAggregatedSqlStatements(SqlStatementData sqlStatementData) {
        return this.getParameterAggregatedSqlStatements(sqlStatementData, null, null);
    }

    public List<SqlStatementData> getParameterAggregatedSqlStatements(SqlStatementData sqlStatementData, Date date, Date date2) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.sqlDataQueryFactory.getAggregatedSqlStatementsQuery(sqlStatementData, date, date2);
        storageIndexQuery.setSql(sqlStatementData.getSql());
        return super.executeQuery(storageIndexQuery, Aggregators.SQL_STATEMENT_DATA_PARAMETER_AGGREGATOR);
    }

    @Override
    protected IStorageTreeComponent<SqlStatementData> getIndexingTree() {
        return this.indexingTree;
    }

    public void setIndexingTree(IStorageTreeComponent<SqlStatementData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setSqlDataQueryFactory(SqlStatementDataQueryFactory<StorageIndexQuery> sqlStatementDataQueryFactory) {
        this.sqlDataQueryFactory = sqlStatementDataQueryFactory;
    }
}

