/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.indexing.aggregation.Aggregators;
import info.novatec.inspectit.indexing.query.factory.impl.ExceptionSensorDataQueryFactory;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.repository.service.storage.AbstractStorageService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class StorageExceptionDataAccessService
extends AbstractStorageService<ExceptionSensorData>
implements IExceptionDataAccessService {
    private IStorageTreeComponent<ExceptionSensorData> indexingTree;
    private ExceptionSensorDataQueryFactory<StorageIndexQuery> exceptionSensorDataQueryFactory;

    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData exceptionSensorData, int n, ResultComparator<ExceptionSensorData> resultComparator) {
        return this.getUngroupedExceptionOverview(exceptionSensorData, n, null, null, resultComparator);
    }

    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData exceptionSensorData, int n, Date date, Date date2, ResultComparator<ExceptionSensorData> resultComparator) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.exceptionSensorDataQueryFactory.getUngroupedExceptionOverviewQuery(exceptionSensorData, n, date, date2);
        if (resultComparator != null) {
            resultComparator.setCachedDataService((ICachedDataService)this.getStorageRepositoryDefinition().getCachedDataService());
            return super.executeQuery(storageIndexQuery, resultComparator, n);
        }
        return super.executeQuery(storageIndexQuery, DefaultDataComparatorEnum.TIMESTAMP, n);
    }

    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData exceptionSensorData, ResultComparator<ExceptionSensorData> resultComparator) {
        return this.getUngroupedExceptionOverview(exceptionSensorData, -1, null, null, resultComparator);
    }

    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData exceptionSensorData, Date date, Date date2, ResultComparator<ExceptionSensorData> resultComparator) {
        return this.getUngroupedExceptionOverview(exceptionSensorData, -1, date, date2, resultComparator);
    }

    public List<ExceptionSensorData> getExceptionTree(ExceptionSensorData exceptionSensorData) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.exceptionSensorDataQueryFactory.getExceptionTreeQuery(exceptionSensorData);
        List<ExceptionSensorData> list = super.executeQuery(storageIndexQuery);
        Collections.reverse(list);
        return list;
    }

    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData exceptionSensorData) {
        return this.getDataForGroupedExceptionOverview(exceptionSensorData, null, null);
    }

    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData exceptionSensorData, Date date, Date date2) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.exceptionSensorDataQueryFactory.getDataForGroupedExceptionOverviewQuery(exceptionSensorData, date, date2);
        List list = super.executeQuery(storageIndexQuery, Aggregators.GROUP_EXCEPTION_OVERVIEW_AGGREGATOR);
        ArrayList<AggregatedExceptionSensorData> arrayList = new ArrayList<AggregatedExceptionSensorData>(list.size());
        for (ExceptionSensorData exceptionSensorData2 : list) {
            if (!(exceptionSensorData2 instanceof AggregatedExceptionSensorData)) continue;
            arrayList.add((AggregatedExceptionSensorData)exceptionSensorData2);
        }
        return arrayList;
    }

    public List<ExceptionSensorData> getStackTraceMessagesForThrowableType(ExceptionSensorData exceptionSensorData) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.exceptionSensorDataQueryFactory.getStackTraceMessagesForThrowableTypeQuery(exceptionSensorData);
        return super.executeQuery(storageIndexQuery, Aggregators.DISTINCT_STACK_TRACES_AGGREGATOR);
    }

    @Override
    protected IStorageTreeComponent<ExceptionSensorData> getIndexingTree() {
        return this.indexingTree;
    }

    public void setIndexingTree(IStorageTreeComponent<ExceptionSensorData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setExceptionSensorDataQueryFactory(ExceptionSensorDataQueryFactory<StorageIndexQuery> exceptionSensorDataQueryFactory) {
        this.exceptionSensorDataQueryFactory = exceptionSensorDataQueryFactory;
    }
}

