/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.cmr.proxy;

import com.google.common.base.Defaults;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.service.cmr.ICmrService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public final class InterceptorUtils {
    private InterceptorUtils() {
    }

    public static boolean isServiceMethod(MethodInvocation methodInvocation) {
        return !methodInvocation.getMethod().getDeclaringClass().equals(ICmrService.class);
    }

    public static boolean isReturnDefaultReturnValue(MethodInvocation methodInvocation) {
        ICmrService iCmrService = InterceptorUtils.getCmrService(methodInvocation);
        return iCmrService != null && iCmrService.isDefaultValueOnError();
    }

    public static CmrRepositoryDefinition getRepositoryDefinition(MethodInvocation methodInvocation) {
        ICmrService iCmrService = InterceptorUtils.getCmrService(methodInvocation);
        if (iCmrService != null) {
            CmrRepositoryDefinition cmrRepositoryDefinition = iCmrService.getCmrRepositoryDefinition();
            return cmrRepositoryDefinition;
        }
        return null;
    }

    private static ICmrService getCmrService(MethodInvocation methodInvocation) {
        ReflectiveMethodInvocation reflectiveMethodInvocation;
        Object object;
        if (methodInvocation instanceof ReflectiveMethodInvocation && (object = (reflectiveMethodInvocation = (ReflectiveMethodInvocation)methodInvocation).getThis()) instanceof ICmrService) {
            return (ICmrService)object;
        }
        return null;
    }

    public static Object getDefaultReturnValue(MethodInvocation methodInvocation) {
        Class<Object> clazz = methodInvocation.getMethod().getReturnType();
        if (clazz.isAssignableFrom(List.class)) {
            return Collections.emptyList();
        }
        if (clazz.isAssignableFrom(Map.class)) {
            return Collections.emptyMap();
        }
        if (clazz.isAssignableFrom(Set.class)) {
            return Collections.emptySet();
        }
        if (clazz.isPrimitive()) {
            try {
                return Defaults.defaultValue(clazz);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

