/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.MapUtils;

public class MapPreferenceValueProvider
extends PreferenceValueProviderFactory.PreferenceValueProvider<Map<?, ?>> {
    private static final String EMPTY_MAP = "EMPTY_MAP";

    @Override
    public boolean isObjectValid(Object object) {
        return object instanceof Map;
    }

    @Override
    public String getValueForObject(Map<?, ?> map) throws PreferenceException {
        if (MapUtils.isEmpty(map)) {
            return EMPTY_MAP;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            stringBuilder.append(String.valueOf(entry.getKey()));
            stringBuilder.append("#");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<?, ?> getObjectFromValue(String string) throws PreferenceException {
        if (EMPTY_MAP.equals(string)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = string2.split("#");
            if (stringArray.length == 2) {
                hashMap.put(stringArray[0], stringArray[1]);
                continue;
            }
            throw new PreferenceException("Error loading map entry for the map saved in the preference store are not correct.  Entry key and value received values via the string '" + string2 + "' are " + Arrays.asList(stringArray) + ". Definition will be skipped.");
        }
        return hashMap;
    }
}

