/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.page;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.dialog.AddCmrRepositoryDefinitionDialog;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.wizard.ManageLabelWizard;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CmrRepositoryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
CmrRepositoryChangeListener {
    private CmrRepositoryManager cmrRepositoryManager;
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button refreshButton;
    private Button manageLabelsButton;
    private Map<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> inputList;

    public CmrRepositoryPreferencePage() {
    }

    public CmrRepositoryPreferencePage(String string) {
        super(string);
    }

    public CmrRepositoryPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public void init(IWorkbench iWorkbench) {
        this.cmrRepositoryManager = InspectIT.getDefault().getCmrRepositoryManager();
        this.cmrRepositoryManager.addCmrRepositoryChangeListener(this);
        this.inputList = new ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus>();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryManager.getCmrRepositoryDefinitions()) {
            this.inputList.put(cmrRepositoryDefinition, cmrRepositoryDefinition.getOnlineStatus());
        }
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 1);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Add, remove and manage repositories");
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite2, 268503810);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.inputList.keySet());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                CmrRepositoryPreferencePage.this.updateButtonsState();
            }
        });
        Composite composite3 = new Composite(composite2, 1);
        GridLayout gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.addButton = new Button(composite3, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddCmrRepositoryDefinitionDialog addCmrRepositoryDefinitionDialog = new AddCmrRepositoryDefinitionDialog(CmrRepositoryPreferencePage.this.getShell());
                addCmrRepositoryDefinitionDialog.open();
                if (addCmrRepositoryDefinitionDialog.getReturnCode() == 0 && addCmrRepositoryDefinitionDialog.getCmrRepositoryDefinition() != null) {
                    CmrRepositoryPreferencePage.this.inputList.put(addCmrRepositoryDefinitionDialog.getCmrRepositoryDefinition(), CmrRepositoryDefinition.OnlineStatus.OFFLINE);
                    CmrRepositoryPreferencePage.this.cmrRepositoryManager.forceCmrRepositoryOnlineStatusUpdate(addCmrRepositoryDefinitionDialog.getCmrRepositoryDefinition());
                    CmrRepositoryPreferencePage.this.tableViewer.refresh();
                }
            }
        });
        this.removeButton = new Button(composite3, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)CmrRepositoryPreferencePage.this.tableViewer.getSelection();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof CmrRepositoryDefinition) {
                        CmrRepositoryPreferencePage.this.inputList.remove((CmrRepositoryDefinition)object);
                    }
                    ++n2;
                }
                CmrRepositoryPreferencePage.this.tableViewer.refresh();
            }
        });
        this.refreshButton = new Button(composite3, 8);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (CmrRepositoryDefinition cmrRepositoryDefinition : CmrRepositoryPreferencePage.this.inputList.keySet()) {
                    CmrRepositoryPreferencePage.this.cmrRepositoryManager.forceCmrRepositoryOnlineStatusUpdate(cmrRepositoryDefinition);
                }
            }
        });
        this.manageLabelsButton = new Button(composite3, 8);
        this.manageLabelsButton.setText("Manage Labels");
        this.manageLabelsButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.manageLabelsButton.setEnabled(false);
        this.manageLabelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)CmrRepositoryPreferencePage.this.tableViewer.getSelection();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof CmrRepositoryDefinition) {
                        ManageLabelWizard manageLabelWizard = new ManageLabelWizard((CmrRepositoryDefinition)object);
                        WizardDialog wizardDialog = new WizardDialog(CmrRepositoryPreferencePage.this.getShell(), (IWizard)manageLabelWizard);
                        wizardDialog.open();
                    }
                    ++n2;
                }
            }
        });
        return composite2;
    }

    public boolean performOk() {
        this.saveChanges();
        return super.performOk();
    }

    public void dispose() {
        super.dispose();
        this.cmrRepositoryManager.removeCmrRepositoryChangeListener(this);
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryOnlineStatusUpdated(final CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        CmrRepositoryDefinition.OnlineStatus onlineStatus3;
        if (onlineStatus2 != CmrRepositoryDefinition.OnlineStatus.CHECKING && this.inputList.containsKey(cmrRepositoryDefinition) && !(onlineStatus3 = this.inputList.get(cmrRepositoryDefinition)).equals((Object)onlineStatus2)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CmrRepositoryPreferencePage.this.tableViewer.refresh((Object)cmrRepositoryDefinition);
                    CmrRepositoryPreferencePage.this.updateButtonsState();
                }
            });
            this.inputList.put(cmrRepositoryDefinition, onlineStatus2);
        }
    }

    @Override
    public void repositoryDataUpdated(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CmrRepositoryPreferencePage.this.tableViewer.refresh((Object)cmrRepositoryDefinition);
            }
        });
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
    }

    private void updateButtonsState() {
        StructuredSelection structuredSelection = (StructuredSelection)this.tableViewer.getSelection();
        if (structuredSelection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.manageLabelsButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            if (structuredSelection.size() == 1 && ((CmrRepositoryDefinition)structuredSelection.getFirstElement()).getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                this.manageLabelsButton.setEnabled(true);
            } else {
                this.manageLabelsButton.setEnabled(false);
            }
        }
    }

    private void saveChanges() {
        if (!this.isDirty()) {
            return;
        }
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.inputList.keySet()) {
            if (this.cmrRepositoryManager.getCmrRepositoryDefinitions().contains(cmrRepositoryDefinition)) continue;
            this.cmrRepositoryManager.addCmrRepositoryDefinition(cmrRepositoryDefinition);
        }
        ArrayList<CmrRepositoryDefinition> arrayList = new ArrayList<CmrRepositoryDefinition>();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryManager.getCmrRepositoryDefinitions()) {
            if (this.inputList.keySet().contains(cmrRepositoryDefinition)) continue;
            arrayList.add(cmrRepositoryDefinition);
        }
        if (!arrayList.isEmpty()) {
            for (CmrRepositoryDefinition cmrRepositoryDefinition : arrayList) {
                this.cmrRepositoryManager.removeCmrRepositoryDefinition(cmrRepositoryDefinition);
            }
        }
        this.savePreferences();
    }

    private boolean isDirty() {
        return !Objects.equals(this.inputList.keySet(), this.cmrRepositoryManager.getCmrRepositoryDefinitions());
    }

    private void savePreferences() {
        PreferencesUtils.saveCmrRepositoryDefinitions(this.cmrRepositoryManager.getCmrRepositoryDefinitions(), false);
    }

    private void createColumns() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.getColumn().setWidth(24);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object object) {
                if (object instanceof CmrRepositoryDefinition) {
                    if (((CmrRepositoryDefinition)object).getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                        return InspectIT.getDefault().getImage("/icons/selfmade/server_online_16x16.png");
                    }
                    if (((CmrRepositoryDefinition)object).getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                        return InspectIT.getDefault().getImage("/icons/selfmade/server_offline_16x16.png");
                    }
                    return InspectIT.getDefault().getImage("/icons/selfmade/server_refresh_16x16.png");
                }
                return null;
            }

            public String getText(Object object) {
                return null;
            }
        });
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(150);
        tableViewerColumn2.getColumn().setText("Name");
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                if (object instanceof CmrRepositoryDefinition) {
                    return ((CmrRepositoryDefinition)object).getName();
                }
                return null;
            }
        });
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.getColumn().setWidth(120);
        tableViewerColumn3.getColumn().setText("IP Address");
        tableViewerColumn3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                if (object instanceof CmrRepositoryDefinition) {
                    return ((CmrRepositoryDefinition)object).getIp();
                }
                return null;
            }
        });
        TableViewerColumn tableViewerColumn4 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn4.getColumn().setResizable(true);
        tableViewerColumn4.getColumn().setWidth(50);
        tableViewerColumn4.getColumn().setText("Port");
        tableViewerColumn4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                if (object instanceof CmrRepositoryDefinition) {
                    return String.valueOf(((CmrRepositoryDefinition)object).getPort());
                }
                return null;
            }
        });
    }
}

