/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.StringToPrimitiveTransformUtil;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class PreferencesUtils {
    private static ScopedPreferenceStore preferenceStore = InspectIT.getDefault().getPreferenceStore();

    private PreferencesUtils() {
    }

    public static void saveBooleanValue(String string, boolean bl, boolean bl2) {
        if (bl2) {
            preferenceStore.setDefault(string, bl);
        } else {
            preferenceStore.setValue(string, bl);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            InspectIT.getDefault().createErrorDialog("Error occurred trying to save setting with name '" + string + "' to preference store.", iOException, -1);
        }
    }

    public static boolean getBooleanValue(String string) {
        return PreferencesUtils.getBooleanValue(string, false);
    }

    public static boolean getBooleanValue(String string, boolean bl) {
        boolean bl2 = bl ? preferenceStore.getDefaultBoolean(string) : preferenceStore.getBoolean(string);
        return bl2;
    }

    public static void saveDoubleValue(String string, double d, boolean bl) {
        if (bl) {
            preferenceStore.setDefault(string, d);
        } else {
            preferenceStore.setValue(string, d);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            InspectIT.getDefault().createErrorDialog("Error occurred trying to save setting with name '" + string + "' to preference store.", iOException, -1);
        }
    }

    public static double getDoubleValue(String string) {
        return PreferencesUtils.getDoubleValue(string, false);
    }

    public static double getDoubleValue(String string, boolean bl) {
        double d = bl ? preferenceStore.getDefaultDouble(string) : preferenceStore.getDouble(string);
        return d;
    }

    public static void saveLongValue(String string, long l, boolean bl) {
        if (bl) {
            preferenceStore.setDefault(string, l);
        } else {
            preferenceStore.setValue(string, l);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            InspectIT.getDefault().createErrorDialog("Error occurred trying to save setting with name '" + string + "' to preference store.", iOException, -1);
        }
    }

    public static long getLongValue(String string) {
        return PreferencesUtils.getLongValue(string, false);
    }

    public static long getLongValue(String string, boolean bl) {
        long l = bl ? preferenceStore.getDefaultLong(string) : preferenceStore.getLong(string);
        return l;
    }

    public static void saveIntValue(String string, int n, boolean bl) {
        if (bl) {
            preferenceStore.setDefault(string, n);
        } else {
            preferenceStore.setValue(string, n);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            InspectIT.getDefault().createErrorDialog("Error occurred trying to save setting with name '" + string + "' to preference store.", iOException, -1);
        }
    }

    public static int getIntValue(String string) {
        return PreferencesUtils.getIntValue(string, false);
    }

    public static int getIntValue(String string, boolean bl) {
        int n = bl ? preferenceStore.getDefaultInt(string) : preferenceStore.getInt(string);
        return n;
    }

    public static void saveStringValue(String string, String string2, boolean bl) {
        if (bl) {
            preferenceStore.setDefault(string, string2);
        } else {
            preferenceStore.setValue(string, string2);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            InspectIT.getDefault().createErrorDialog("Error occurred trying to save setting with name '" + string + "' to preference store.", iOException, -1);
        }
    }

    public static String getStringValue(String string) {
        return PreferencesUtils.getStringValue(string, false);
    }

    public static String getStringValue(String string, boolean bl) {
        String string2 = bl ? preferenceStore.getDefaultString(string) : preferenceStore.getString(string);
        return string2;
    }

    public static void saveObject(String string, Object object, boolean bl) {
        try {
            if (object == null) {
                PreferencesUtils.saveStringValue(string, "", bl);
                return;
            }
            String string2 = PreferenceValueProviderFactory.getValueForObject(string, object);
            if (string2 != null && !"".equals(string2)) {
                PreferencesUtils.saveStringValue(string, string2, bl);
            }
        }
        catch (PreferenceException preferenceException) {
            InspectIT.getDefault().createErrorDialog("Error trying to save object to the preference store with preference key: " + string, preferenceException, -1);
        }
    }

    public static <E> E getObject(String string) {
        String string2;
        block3: {
            try {
                string2 = preferenceStore.getString(string);
                if (string2 != null && !"".equals(string2)) break block3;
            }
            catch (PreferenceException preferenceException) {
                InspectIT.getDefault().createErrorDialog("Error trying to load object from the preference store with preference key: " + string, preferenceException, -1);
                return null;
            }
            return null;
        }
        return PreferenceValueProviderFactory.getObjectFromValue(string, string2);
    }

    public static <E> void loadPrimitiveCollection(String string, Collection<E> collection, Class<E> clazz) {
        String string2 = preferenceStore.getString(string);
        if (string2 == null || "".equals(string2)) {
            return;
        }
        try {
            Collection collection2 = (Collection)PreferenceValueProviderFactory.getObjectFromValue(string, string2);
            StringToPrimitiveTransformUtil.transformStringCollection(collection2, collection, clazz);
        }
        catch (PreferenceException preferenceException) {
            InspectIT.getDefault().createErrorDialog("Error trying to load primitive collection from the preference store with preference key: " + string, preferenceException, -1);
        }
    }

    public static <K, V> void loadPrimitiveMap(String string, Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        String string2 = preferenceStore.getString(string);
        if (string2 == null || "".equals(string2)) {
            return;
        }
        try {
            Map map2 = (Map)PreferenceValueProviderFactory.getObjectFromValue(string, string2);
            StringToPrimitiveTransformUtil.transformStringMap(map2, map, clazz, clazz2);
        }
        catch (PreferenceException preferenceException) {
            InspectIT.getDefault().createErrorDialog("Error trying to load primitive map from the preference store with preference key: " + string, preferenceException, -1);
        }
    }

    public static void saveCmrRepositoryDefinitions(List<CmrRepositoryDefinition> list, boolean bl) {
        PreferencesUtils.saveObject("CMR_REPOSITORY_DEFINITIONS", list, bl);
    }

    public static List<CmrRepositoryDefinition> getCmrRepositoryDefinitions() {
        return (List)PreferencesUtils.getObject("CMR_REPOSITORY_DEFINITIONS");
    }
}

