/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public final class ExceptionImageFactory {
    private static final ImageDescriptor OVERLAY_ERROR = InspectIT.getDefault().getImageDescriptor("/icons/eclipse/overlay_error.gif");
    private static final ImageDescriptor OVERLAY_PRIORITY = InspectIT.getDefault().getImageDescriptor("/icons/eclipse/overlay_priority.gif");
    private static final ImageDescriptor OVERLAY_UP = InspectIT.getDefault().getImageDescriptor("/icons/eclipse/over_co.gif");

    private ExceptionImageFactory() {
    }

    public static ImageDescriptor getImageDescriptor(ExceptionSensorData exceptionSensorData) {
        if (exceptionSensorData != null) {
            ExceptionEvent exceptionEvent = exceptionSensorData.getExceptionEvent();
            if (ExceptionEvent.CREATED.equals((Object)exceptionEvent)) {
                return OVERLAY_ERROR;
            }
            if (ExceptionEvent.HANDLED.equals((Object)exceptionEvent)) {
                return OVERLAY_PRIORITY;
            }
            if (ExceptionEvent.PASSED.equals((Object)exceptionEvent)) {
                return OVERLAY_UP;
            }
            if (ExceptionEvent.RETHROWN.equals((Object)exceptionEvent)) {
                return OVERLAY_ERROR;
            }
            if (ExceptionEvent.UNREGISTERED_PASSED.equals((Object)exceptionEvent)) {
                return OVERLAY_UP;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static Image decorateImageWithException(Image image, ExceptionSensorData exceptionSensorData, ResourceManager resourceManager) {
        ImageDescriptor imageDescriptor = ExceptionImageFactory.getImageDescriptor(exceptionSensorData);
        DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(image, imageDescriptor, 3);
        Image image2 = resourceManager.createImage((ImageDescriptor)decorationOverlayIcon);
        return image2;
    }
}

