/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.DeferredJmxObjectComposite;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredJmxPackageComposite
extends DeferredComposite {
    private List<JmxDefinitionDataIdent> childJmxData = new CopyOnWriteArrayList<JmxDefinitionDataIdent>();
    private RepositoryDefinition repositoryDefinition;
    private SensorTypeIdent sensorTypeIdent;

    public void setSensorTypeIdent(SensorTypeIdent sensorTypeIdent) {
        this.sensorTypeIdent = sensorTypeIdent;
    }

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            iProgressMonitor.beginTask("Loading monitored JMX-Objects...", -1);
            HashMap<String, DeferredJmxObjectComposite> hashMap = new HashMap<String, DeferredJmxObjectComposite>(this.childJmxData.size());
            for (JmxDefinitionDataIdent jmxDefinitionDataIdent : this.childJmxData) {
                DeferredJmxObjectComposite deferredJmxObjectComposite;
                String string = jmxDefinitionDataIdent.getDerivedTypeName();
                if (!hashMap.containsKey(string)) {
                    deferredJmxObjectComposite = this.getNewChild();
                    deferredJmxObjectComposite.setRepositoryDefinition(this.repositoryDefinition);
                    deferredJmxObjectComposite.setName(string);
                    iElementCollector.add((Object)deferredJmxObjectComposite, iProgressMonitor);
                    composite.addChild(deferredJmxObjectComposite);
                    hashMap.put(string, deferredJmxObjectComposite);
                }
                deferredJmxObjectComposite = (DeferredJmxObjectComposite)hashMap.get(string);
                deferredJmxObjectComposite.setSensorTypeIdent(this.sensorTypeIdent);
                deferredJmxObjectComposite.addJmxDataToDisplay(jmxDefinitionDataIdent);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    protected DeferredJmxObjectComposite getNewChild() {
        return new DeferredJmxObjectComposite();
    }

    public void addJmxDataToDisplay(JmxDefinitionDataIdent jmxDefinitionDataIdent) {
        this.childJmxData.add(jmxDefinitionDataIdent);
    }

    @Override
    public Image getImage() {
        return InspectIT.getDefault().getImage("/icons/eclipse/package_obj.gif");
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }
}

