/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredJmxObjectComposite
extends DeferredComposite {
    private List<JmxDefinitionDataIdent> childJmxData = new CopyOnWriteArrayList<JmxDefinitionDataIdent>();
    private RepositoryDefinition repositoryDefinition;
    private SensorTypeIdent sensorTypeIdent;

    public void setSensorTypeIdent(SensorTypeIdent sensorTypeIdent) {
        this.sensorTypeIdent = sensorTypeIdent;
    }

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            iProgressMonitor.beginTask("Loading monitored JMX-Attributes...", -1);
            for (JmxDefinitionDataIdent jmxDefinitionDataIdent : this.childJmxData) {
                Leaf leaf = new Leaf();
                leaf.setName(jmxDefinitionDataIdent.getmBeanAttributeName());
                leaf.setTooltip(jmxDefinitionDataIdent.getmBeanAttributeDescription());
                leaf.setImage(InspectIT.getDefault().getImage("/icons/fugue/blue-document-table.png"));
                InputDefinition inputDefinition = new InputDefinition();
                inputDefinition.setRepositoryDefinition(this.repositoryDefinition);
                inputDefinition.setId(SensorTypeEnum.JMX_SENSOR_DATA);
                EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
                editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/bean.png"));
                editorPropertiesData.setSensorName("JMX Data");
                editorPropertiesData.setViewName(TextFormatter.getJmxDefinitionString(jmxDefinitionDataIdent));
                editorPropertiesData.setPartNameFlag(EditorPropertiesData.PartType.VIEW);
                inputDefinition.setEditorPropertiesData(editorPropertiesData);
                InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
                idDefinition.setPlatformId(jmxDefinitionDataIdent.getPlatformIdent().getId());
                idDefinition.setSensorTypeId(this.sensorTypeIdent.getId());
                idDefinition.setJmxDefinitionId(jmxDefinitionDataIdent.getId());
                inputDefinition.setIdDefinition(idDefinition);
                leaf.setInputDefinition(inputDefinition);
                iElementCollector.add((Object)leaf, iProgressMonitor);
                composite.addChild(leaf);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        return InspectIT.getDefault().getImage("/icons/fugue/book.png");
    }

    public void addJmxDataToDisplay(JmxDefinitionDataIdent jmxDefinitionDataIdent) {
        this.childJmxData.add(jmxDefinitionDataIdent);
    }
}

