/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.DeferredMethodComposite;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredClassComposite
extends DeferredComposite {
    private List<MethodIdent> methods = new CopyOnWriteArrayList<MethodIdent>();
    protected static final String METHOD_FORMAT = "%s(%s)";
    private RepositoryDefinition repositoryDefinition;
    private boolean hideInactiveInstrumentations;

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            iProgressMonitor.beginTask("Loading of Method Elements...", this.methods.size());
            for (MethodIdent methodIdent : this.methods) {
                if (this.select(methodIdent)) {
                    DeferredMethodComposite deferredMethodComposite = new DeferredMethodComposite();
                    deferredMethodComposite.setRepositoryDefinition(this.repositoryDefinition);
                    if (methodIdent.getParameters() != null) {
                        String string = methodIdent.getParameters().toString();
                        string = string.substring(1, string.length() - 1);
                        deferredMethodComposite.setName(String.format(METHOD_FORMAT, methodIdent.getMethodName(), string));
                    } else {
                        deferredMethodComposite.setName(String.format(METHOD_FORMAT, methodIdent.getMethodName(), ""));
                    }
                    deferredMethodComposite.setMethod(methodIdent);
                    deferredMethodComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
                    iElementCollector.add((Object)deferredMethodComposite, iProgressMonitor);
                    composite.addChild(deferredMethodComposite);
                }
                iProgressMonitor.worked(1);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    @Override
    public boolean isEnabled() {
        if (CollectionUtils.isNotEmpty(this.methods)) {
            for (MethodIdent methodIdent : this.methods) {
                if (!methodIdent.hasActiveSensorTypes()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean select(MethodIdent methodIdent) {
        return !this.hideInactiveInstrumentations || methodIdent.hasActiveSensorTypes();
    }

    public void addMethodToDisplay(MethodIdent methodIdent) {
        this.methods.add(methodIdent);
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        return InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif");
    }

    protected List<MethodIdent> getMethods() {
        return this.methods;
    }

    public boolean isHideInactiveInstrumentations() {
        return this.hideInactiveInstrumentations;
    }

    public void setHideInactiveInstrumentations(boolean bl) {
        this.hideInactiveInstrumentations = bl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.methods, this.repositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeferredClassComposite deferredClassComposite = (DeferredClassComposite)object;
        return Objects.equal(this.methods, deferredClassComposite.methods) && Objects.equal((Object)this.repositoryDefinition, (Object)deferredClassComposite.repositoryDefinition);
    }
}

