/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.DeferredPackageComposite;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredBrowserComposite
extends DeferredComposite {
    private PlatformIdent platformIdent;
    private RepositoryDefinition repositoryDefinition;
    private boolean hideInactiveInstrumentations;

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            Set set = this.platformIdent.getMethodIdents();
            iProgressMonitor.beginTask("Loading of Package Elements...", -1);
            HashMap<String, DeferredPackageComposite> hashMap = new HashMap<String, DeferredPackageComposite>(set.size());
            for (MethodIdent methodIdent : set) {
                if (this.select(methodIdent)) {
                    DeferredPackageComposite deferredPackageComposite;
                    String string = methodIdent.getPackageName();
                    string = string == null ? "" : string.trim();
                    if (!hashMap.containsKey(string)) {
                        deferredPackageComposite = this.getNewChild();
                        deferredPackageComposite.setRepositoryDefinition(this.repositoryDefinition);
                        if ("".equals(string)) {
                            deferredPackageComposite.setName("(default)");
                        } else {
                            deferredPackageComposite.setName(string);
                        }
                        iElementCollector.add((Object)deferredPackageComposite, iProgressMonitor);
                        composite.addChild(deferredPackageComposite);
                        hashMap.put(string, deferredPackageComposite);
                    }
                    deferredPackageComposite = (DeferredPackageComposite)hashMap.get(string);
                    deferredPackageComposite.addClassToDisplay(methodIdent);
                    deferredPackageComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
                }
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    protected DeferredPackageComposite getNewChild() {
        return new DeferredPackageComposite();
    }

    protected boolean select(MethodIdent methodIdent) {
        return !this.hideInactiveInstrumentations || methodIdent.hasActiveSensorTypes();
    }

    public void setPlatformIdent(PlatformIdent platformIdent) {
        this.platformIdent = platformIdent;
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        if (this.hideInactiveInstrumentations) {
            return InspectIT.getDefault().getImage("/icons/fugue/blue-document-tree.png");
        }
        return InspectIT.getDefault().getImage("/icons/fugue/document-tree.png");
    }

    public boolean isHideInactiveInstrumentations() {
        return this.hideInactiveInstrumentations;
    }

    public void setHideInactiveInstrumentations(boolean bl) {
        this.hideInactiveInstrumentations = bl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.platformIdent, this.repositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeferredBrowserComposite deferredBrowserComposite = (DeferredBrowserComposite)object;
        return Objects.equal((Object)this.platformIdent, (Object)deferredBrowserComposite.platformIdent) && Objects.equal((Object)this.repositoryDefinition, (Object)deferredBrowserComposite.repositoryDefinition);
    }
}

