/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.documentation.DocumentationService;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public abstract class OpenUrlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        String string = this.getUrlString(executionEvent);
        if (string == null) {
            return null;
        }
        try {
            IWebBrowser iWebBrowser = iWorkbenchBrowserSupport.createBrowser(null);
            URL uRL = new URL(string);
            iWebBrowser.openURL(uRL);
        }
        catch (MalformedURLException | PartInitException throwable) {
            throw new ExecutionException("Error opening the URL ('" + string + "') in the system browser.", throwable);
        }
        return null;
    }

    protected abstract String getUrlString(ExecutionEvent var1);

    public static class ExceptionSupportHandler
    extends OpenUrlHandler {
        public static final String COMMAND = "info.novatec.inspectit.rcp.sendErrorReport";
        public static final String INPUT = "info.novatec.inspectit.rcp.sendErrorReport.throwable";

        @Override
        protected String getUrlString(ExecutionEvent executionEvent) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
            Throwable throwable = (Throwable)iEvaluationContext.getVariable(INPUT);
            if (throwable == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder("I would like to report the following exception that occurred in inspectIT:\n\n");
            stringBuilder.append("inspectIT Version: ");
            stringBuilder.append(InspectIT.getDefault().getBundle().getVersion());
            stringBuilder.append("\nOperating system: ");
            stringBuilder.append(String.valueOf(SystemUtils.OS_NAME) + " " + SystemUtils.OS_VERSION + " (" + SystemUtils.OS_ARCH + ")");
            stringBuilder.append("\nJava version: ");
            stringBuilder.append(String.valueOf(SystemUtils.JAVA_VENDOR) + " " + SystemUtils.JAVA_VERSION);
            stringBuilder.append("\nException type: ");
            stringBuilder.append(throwable.getClass().getName());
            stringBuilder.append("\nException message: ");
            stringBuilder.append(throwable.getMessage());
            stringBuilder.append("\nStack trace (limited): ");
            String string = ExceptionUtils.getStackTrace((Throwable)throwable);
            int n = string.length() > 1000 ? 1000 : string.length();
            stringBuilder.append(string.subSequence(0, n));
            stringBuilder.append("\n\nBest regards,\nYour Name");
            String string2 = "mailto:support.inspectit@novatec-gmbh.de&subject=Support%20needed&body=";
            try {
                string2 = String.valueOf(string2) + URLEncoder.encode(stringBuilder.toString(), "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string2;
            }
            return string2;
        }
    }

    public static class GiveFeedbackHandler
    extends OpenUrlHandler {
        @Override
        protected String getUrlString(ExecutionEvent executionEvent) {
            return "mailto:info.inspectit@novatec-gmbh.de&subject=Feedback";
        }
    }

    public static class OpenDocumentationHandler
    extends OpenUrlHandler {
        protected DocumentationService documentationService = InspectIT.getService(DocumentationService.class);

        @Override
        protected String getUrlString(ExecutionEvent executionEvent) {
            return this.documentationService.getDocumentationUrl();
        }
    }

    public static class RequestSupportHandler
    extends OpenUrlHandler {
        @Override
        protected String getUrlString(ExecutionEvent executionEvent) {
            return "mailto:support.inspectit@novatec-gmbh.de&subject=Support%20needed";
        }
    }

    public static class SearchDocumentationHandler
    extends OpenDocumentationHandler {
        public static final String SEARCH_DOCUMENTATION_PARAMETER = "info.novatec.inspectit.rcp.commands.searchDocumentation.searchString";

        @Override
        protected String getUrlString(ExecutionEvent executionEvent) {
            String string = executionEvent.getParameter(SEARCH_DOCUMENTATION_PARAMETER);
            return this.documentationService.getSearchUrlFor(string);
        }
    }
}

