/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.ExploredByLabelType;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class DeleteStorageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection) {
            Object object;
            Iterator iterator = ((StructuredSelection)iSelection).iterator();
            final ArrayList<IStorageDataProvider> arrayList = new ArrayList<IStorageDataProvider>();
            HashSet hashSet = new HashSet();
            boolean bl = false;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof IStorageDataProvider)) continue;
                arrayList.add((IStorageDataProvider)object);
                hashSet.addAll(((IStorageDataProvider)object).getStorageData().getLabels((AbstractStorageLabelType)new ExploredByLabelType()));
            }
            if (!arrayList.isEmpty()) {
                MessageBox messageBox2;
                boolean bl2;
                object = new StringBuffer(90);
                boolean bl3 = bl2 = arrayList.size() > 1;
                if (!bl2) {
                    ((StringBuffer)object).append("Are you sure you want to delete the selected storage? ");
                    if (!hashSet.isEmpty()) {
                        ((StringBuffer)object).append("Note that the storage was (and still could be) explored by following users: ");
                    }
                } else {
                    ((StringBuffer)object).append("Are you sure you want to  delete the " + arrayList.size() + " selected storages? ");
                    if (!hashSet.isEmpty()) {
                        ((StringBuffer)object).append("Note that the storages were (and still could be) explored by following users: ");
                    }
                }
                if (!hashSet.isEmpty()) {
                    for (MessageBox messageBox2 : hashSet) {
                        ((StringBuffer)object).append("\n * ");
                        ((StringBuffer)object).append((String)messageBox2.getValue());
                    }
                }
                messageBox2 = new MessageBox(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), 292);
                messageBox2.setText("Confirm Delete");
                messageBox2.setMessage(((StringBuffer)object).toString());
                boolean bl4 = bl = 32 == messageBox2.open();
                if (bl) {
                    Iterator iterator2 = new Job("Delete Storage Job"){

                        protected IStatus run(IProgressMonitor iProgressMonitor) {
                            ArrayList<Status> arrayList2 = new ArrayList<Status>();
                            HashSet<CmrRepositoryDefinition> hashSet = new HashSet<CmrRepositoryDefinition>();
                            for (IStorageDataProvider iStorageDataProvider : arrayList) {
                                if (iStorageDataProvider.getCmrRepositoryDefinition().getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                                    String string;
                                    hashSet.add(iStorageDataProvider.getCmrRepositoryDefinition());
                                    try {
                                        iStorageDataProvider.getCmrRepositoryDefinition().getStorageService().deleteStorage(iStorageDataProvider.getStorageData());
                                        InspectIT.getDefault().getInspectITStorageManager().storageRemotelyDeleted(iStorageDataProvider.getStorageData());
                                    }
                                    catch (BusinessException businessException) {
                                        string = iStorageDataProvider.getStorageData().getName();
                                        arrayList2.add(new Status(4, "info.novatec.inspectit.rcp", "Storage '" + string + "' could not be successfully deleted from CMR.", (Throwable)businessException));
                                    }
                                    catch (SerializationException | IOException throwable) {
                                        string = iStorageDataProvider.getStorageData().getName();
                                        arrayList2.add(new Status(4, "info.novatec.inspectit.rcp", "Local data for storage '" + string + "' was not cleared successfully.", throwable));
                                    }
                                    continue;
                                }
                                String string = iStorageDataProvider.getStorageData().getName();
                                arrayList2.add(new Status(2, "info.novatec.inspectit.rcp", "Storage '" + string + "' can not be deleted, because CMR where it is located is offline."));
                            }
                            if (CollectionUtils.isNotEmpty(arrayList2)) {
                                if (1 == arrayList2.size()) {
                                    return (IStatus)arrayList2.iterator().next();
                                }
                                return new MultiStatus("info.novatec.inspectit.rcp", 0, (IStatus[])arrayList2.toArray(new Status[arrayList2.size()]), "Delete of several storages failed.", null);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    iterator2.setUser(true);
                    iterator2.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/eclipse/delete_obj.gif"));
                    iterator2.schedule();
                }
            }
        }
        return null;
    }
}

