/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.formatter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class NumberFormatter {
    private static DecimalFormat decFormat = new DecimalFormat("###0.##");
    private static DecimalFormat millisFormat = new DecimalFormat("0.00");
    private static DecimalFormat nanosFormat = new DecimalFormat("0.00");
    private static DecimalFormat cpuFormat = new DecimalFormat("#.##");
    private static DecimalFormat intFormat = new DecimalFormat("###");
    private static DecimalFormat doubleFormat = new DecimalFormat("0.000");
    private static DecimalFormat doubleUnspecificFormat = new DecimalFormat();
    private static DateFormat dateMillisFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private static DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    static {
        doubleUnspecificFormat.setGroupingSize(0);
    }

    private NumberFormatter() {
    }

    public static String millisecondsToString(long l) {
        int n = (int)(l / 1000L % 60L);
        int n2 = (int)(l / 60000L % 60L);
        int n3 = (int)(l / 3600000L % 24L);
        int n4 = (int)(l / 3600000L / 24L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n4);
        stringBuilder.append("d ");
        stringBuilder.append(n3);
        stringBuilder.append("h ");
        stringBuilder.append(n2);
        stringBuilder.append("m ");
        stringBuilder.append(n);
        stringBuilder.append('s');
        return stringBuilder.toString();
    }

    public static String formatTimeWithMillis(long l) {
        return NumberFormatter.formatTimeWithMillis(new Date(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimeWithMillis(Date date) {
        DateFormat dateFormat = dateMillisFormat;
        synchronized (dateFormat) {
            return dateMillisFormat.format(date);
        }
    }

    public static String formatTime(long l) {
        return NumberFormatter.formatTime(new Date(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(Date date) {
        DateFormat dateFormat = NumberFormatter.dateFormat;
        synchronized (dateFormat) {
            return NumberFormatter.dateFormat.format(date);
        }
    }

    public static String formatNanosToSeconds(long l) {
        double d = (double)l / 1.0E9;
        return String.valueOf(nanosFormat.format(d)) + " s";
    }

    public static String formatMillisToSeconds(long l) {
        double d = (double)l / 1000.0;
        return String.valueOf(millisFormat.format(d)) + " s";
    }

    public static String formatBytesToKBytes(long l) {
        return String.valueOf(decFormat.format((double)l / 1024.0)) + " Kb";
    }

    public static String formatBytesToMBytes(long l) {
        return String.valueOf(decFormat.format((double)l / 1048576.0)) + " Mb";
    }

    public static String formatCpuPercent(float f) {
        return String.valueOf(cpuFormat.format(f)) + " %";
    }

    public static String formatInteger(int n) {
        return intFormat.format(n);
    }

    public static String formatLong(long l) {
        return intFormat.format(l);
    }

    public static String formatDouble(double d) {
        return doubleFormat.format(d);
    }

    public static String formatDouble(double d, int n) {
        doubleUnspecificFormat.setMaximumFractionDigits(n);
        doubleUnspecificFormat.setMinimumFractionDigits(n);
        return doubleUnspecificFormat.format(d);
    }

    public static String humanReadableByteCount(long l) {
        int n = 1024;
        if (l < (long)n) {
            return String.valueOf(l) + " B";
        }
        int n2 = (int)(Math.log(l) / Math.log(n));
        String string = String.valueOf("KMGTPE".charAt(n2 - 1)) + "i";
        return String.format("%.1f %sB", (double)l / Math.pow(n, n2), string);
    }

    public static String humanReadableMillisCount(long l, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        long l2 = TimeUnit.MILLISECONDS.toDays(l);
        if (l2 > 0L) {
            if (bl) {
                return String.valueOf(l2) + " day" + (l2 > 1L ? "s" : "");
            }
            stringBuilder.append(String.format("%dd", l2));
            bl2 = true;
        }
        long l3 = TimeUnit.MILLISECONDS.toHours(l) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(l));
        if (bl2) {
            stringBuilder.append(String.format(" %dh", l3));
        } else if (l3 > 0L) {
            if (bl) {
                return String.valueOf(l3) + " hour" + (l3 > 1L ? "s" : "");
            }
            stringBuilder.append(String.format("%dh", l3));
            bl2 = true;
        }
        long l4 = TimeUnit.MILLISECONDS.toMinutes(l) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(l));
        if (bl2) {
            stringBuilder.append(String.format(" %dm", l4));
        } else if (l4 > 0L) {
            if (bl) {
                return String.valueOf(l4) + " minute" + (l4 > 1L ? "s" : "");
            }
            stringBuilder.append(String.format("%dm", l4));
            bl2 = true;
        }
        long l5 = TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l));
        if (bl2) {
            stringBuilder.append(String.format(" %ds", l5));
        } else if (l5 > 0L) {
            if (bl) {
                return String.valueOf(l5) + " second" + (l5 > 1L ? "s" : "");
            }
            stringBuilder.append(String.format("%ds", l5));
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    public static String formatDoubleToPercent(double d) {
        return String.valueOf(doubleFormat.format(d * 100.0)) + " %";
    }
}

