/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.form;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.provider.ILocalStorageDataProvider;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.label.edit.LabelValueEditingSupport;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.handlers.IHandlerService;

public class StorageDataPropertyForm
implements ISelectionChangedListener {
    private static final int MAX_DESCRIPTION_LENGTH = 150;
    private IStorageData storageData;
    private IStorageDataProvider storageDataProvider;
    private FormToolkit toolkit;
    private ManagedForm managedForm;
    private ScrolledForm form;
    private Label uniqueId;
    private Label repository;
    private FormText description;
    private Label sizeOnDisk;
    private Label state;
    private TableViewer labelsTableViewer;
    private Button addNewLabel;
    private Button removeLabels;
    private Composite mainComposite;
    private TableViewerColumn valueViewerColumn;

    public StorageDataPropertyForm(Composite composite) {
        this(composite, null);
    }

    public StorageDataPropertyForm(Composite composite, IStorageDataProvider iStorageDataProvider) {
        this.managedForm = new ManagedForm(composite);
        this.toolkit = this.managedForm.getToolkit();
        this.form = this.managedForm.getForm();
        this.storageDataProvider = iStorageDataProvider;
        if (iStorageDataProvider != null) {
            this.storageData = iStorageDataProvider.getStorageData();
        }
        this.initWidget();
    }

    public StorageDataPropertyForm(Composite composite, IStorageDataProvider iStorageDataProvider, IStorageData iStorageData) {
        this.managedForm = new ManagedForm(composite);
        this.toolkit = this.managedForm.getToolkit();
        this.form = this.managedForm.getForm();
        this.storageDataProvider = iStorageDataProvider;
        this.storageData = iStorageData;
        this.initWidget();
    }

    private void initWidget() {
        Composite composite = this.form.getBody();
        composite.setLayout((Layout)new TableWrapLayout());
        this.managedForm.getToolkit().decorateFormHeading(this.form.getForm());
        this.mainComposite = this.toolkit.createComposite(composite, 0);
        this.mainComposite.setLayout((Layout)new TableWrapLayout());
        this.mainComposite.setLayoutData((Object)new TableWrapData(256));
        Section section = this.toolkit.createSection(this.mainComposite, 256);
        section.setText("General information");
        Composite composite2 = this.toolkit.createComposite((Composite)section, 0);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite2.setLayout((Layout)tableWrapLayout);
        composite2.setLayoutData((Object)new TableWrapData(128));
        this.toolkit.createLabel(composite2, "Repository:");
        this.repository = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "Description:");
        this.description = this.toolkit.createFormText(composite2, true);
        this.description.setLayoutData((Object)new TableWrapData(128));
        this.description.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                StorageDataPropertyForm.this.showStorageDescriptionBox();
            }
        });
        this.toolkit.createLabel(composite2, "Size on disk:");
        this.sizeOnDisk = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "State:");
        this.state = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "Unique ID:");
        this.uniqueId = this.toolkit.createLabel(composite2, null, 64);
        this.uniqueId.setLayoutData((Object)new TableWrapData(256));
        section.setClient((Control)composite2);
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        Section section2 = this.toolkit.createSection(this.mainComposite, 256);
        section2.setText("Labels");
        Composite composite3 = this.toolkit.createComposite((Composite)section2, 0);
        tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite3.setLayout((Layout)tableWrapLayout);
        composite3.setLayoutData((Object)new TableWrapData(256));
        Table table = this.toolkit.createTable(composite3, 268438274);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.colspan = 2;
        tableWrapData.heightHint = 150;
        table.setLayoutData((Object)tableWrapData);
        this.labelsTableViewer = new TableViewer(table);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.labelsTableViewer, 0);
        tableViewerColumn.getColumn().setText("Type");
        tableViewerColumn.getColumn().setMoveable(false);
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setWidth(140);
        this.valueViewerColumn = new TableViewerColumn(this.labelsTableViewer, 0);
        this.valueViewerColumn.getColumn().setText("Value");
        this.valueViewerColumn.getColumn().setMoveable(false);
        this.valueViewerColumn.getColumn().setResizable(true);
        this.valueViewerColumn.getColumn().setWidth(140);
        this.labelsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelsTableViewer.setLabelProvider((IBaseLabelProvider)new StyledCellIndexLabelProvider(){

            @Override
            protected StyledString getStyledText(Object object, int n) {
                if (object instanceof AbstractStorageLabel) {
                    AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
                    switch (n) {
                        case 0: {
                            return new StyledString(TextFormatter.getLabelName(abstractStorageLabel));
                        }
                        case 1: {
                            return new StyledString(TextFormatter.getLabelValue(abstractStorageLabel, false));
                        }
                    }
                }
                return null;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                if (n == 0 && object instanceof AbstractStorageLabel) {
                    return ImageFormatter.getImageForLabel(((AbstractStorageLabel)object).getStorageLabelType());
                }
                return null;
            }
        });
        this.labelsTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof AbstractStorageLabel && object2 instanceof AbstractStorageLabel) {
                    return ((AbstractStorageLabel)object).compareTo((AbstractStorageLabel)object2);
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.labelsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (StorageDataPropertyForm.this.labelsTableViewer.getSelection().isEmpty() || !StorageDataPropertyForm.this.isRemoteStorageDisplayed()) {
                    StorageDataPropertyForm.this.removeLabels.setEnabled(false);
                } else {
                    StorageDataPropertyForm.this.removeLabels.setEnabled(true);
                }
            }
        });
        this.addNewLabel = this.toolkit.createButton(composite3, "Add", 8);
        this.addNewLabel.setToolTipText("Add new label(s)");
        this.addNewLabel.setEnabled(false);
        this.addNewLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.addStorageLabel");
                ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, new Event());
                try {
                    command.executeWithChecks(executionEvent);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        this.removeLabels = this.toolkit.createButton(composite3, "Remove", 8);
        this.removeLabels.setToolTipText("Remove selected label(s)");
        this.removeLabels.setEnabled(false);
        this.removeLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!StorageDataPropertyForm.this.labelsTableViewer.getSelection().isEmpty()) {
                    Object object;
                    ArrayList<AbstractStorageLabel> arrayList = new ArrayList<AbstractStorageLabel>();
                    ExecutionEvent executionEvent = ((StructuredSelection)StorageDataPropertyForm.this.labelsTableViewer.getSelection()).toArray();
                    int n = ((Object[])executionEvent).length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = executionEvent[n2];
                        if (object instanceof AbstractStorageLabel) {
                            arrayList.add((AbstractStorageLabel)object);
                        }
                        ++n2;
                    }
                    object = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.removeStorageLabel");
                    executionEvent = object.createExecutionEvent(command, new Event());
                    IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
                    iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.removeStorageLabel.input", arrayList);
                    try {
                        command.executeWithChecks(executionEvent);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        });
        section2.setClient((Control)composite3);
        section2.setLayout((Layout)new TableWrapLayout());
        section2.setLayoutData((Object)new TableWrapData(256));
        this.refreshData();
    }

    public void setLayoutData(Object object) {
        this.form.setLayoutData(object);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)iSelection;
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IStorageDataProvider) {
                if (!ObjectUtils.equals((Object)this.storageDataProvider, (Object)object)) {
                    this.storageDataProvider = (IStorageDataProvider)object;
                    this.storageData = this.storageDataProvider.getStorageData();
                    final CmrRepositoryDefinition cmrRepositoryDefinition = this.storageDataProvider.getCmrRepositoryDefinition();
                    LabelValueEditingSupport labelValueEditingSupport = new LabelValueEditingSupport(this.labelsTableViewer, this.storageDataProvider.getStorageData(), cmrRepositoryDefinition);
                    labelValueEditingSupport.addLabelEditListener(new LabelValueEditingSupport.LabelEditListener(){

                        @Override
                        public void preLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
                            if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                                try {
                                    cmrRepositoryDefinition.getStorageService().removeLabelFromStorage(StorageDataPropertyForm.this.storageDataProvider.getStorageData(), abstractStorageLabel);
                                }
                                catch (BusinessException businessException) {
                                    InspectIT.getDefault().createErrorDialog("Label value can not be updated.", businessException, -1);
                                }
                            }
                        }

                        @Override
                        public void postLabelValueChange(AbstractStorageLabel<?> abstractStorageLabel) {
                            if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                                try {
                                    abstractStorageLabel.setId(0);
                                    cmrRepositoryDefinition.getStorageService().addLabelToStorage(StorageDataPropertyForm.this.storageDataProvider.getStorageData(), abstractStorageLabel, true);
                                    StorageDataPropertyForm.this.refreshStorageManagerView(cmrRepositoryDefinition);
                                }
                                catch (BusinessException businessException) {
                                    InspectIT.getDefault().createErrorDialog("Label value can not be updated.", businessException, -1);
                                }
                            }
                        }
                    });
                    this.valueViewerColumn.setEditingSupport((EditingSupport)labelValueEditingSupport);
                    this.refreshData();
                }
                return;
            }
            if (object instanceof ILocalStorageDataProvider) {
                LocalStorageData localStorageData = ((ILocalStorageDataProvider)object).getLocalStorageData();
                if (!ObjectUtils.equals((Object)this.storageData, (Object)localStorageData)) {
                    this.storageDataProvider = null;
                    this.storageData = localStorageData;
                    this.valueViewerColumn.setEditingSupport(null);
                    this.refreshData();
                }
                return;
            }
        }
        if (this.storageDataProvider != null || this.storageData != null) {
            this.storageDataProvider = null;
            this.storageData = null;
            this.valueViewerColumn.setEditingSupport(null);
            this.refreshData();
        }
    }

    private void refreshData() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StorageDataPropertyForm.this.form.setBusy(true);
                if (StorageDataPropertyForm.this.isDataExistsForDisplay()) {
                    StorageDataPropertyForm.this.form.setText(StorageDataPropertyForm.this.storageData.getName());
                    StorageDataPropertyForm.this.form.setMessage(null, 0);
                    StorageDataPropertyForm.this.mainComposite.setVisible(true);
                    StorageDataPropertyForm.this.uniqueId.setText(StorageDataPropertyForm.this.storageData.getId());
                    String string = StorageDataPropertyForm.this.storageData.getDescription();
                    if (string != null) {
                        if (string.length() > 150) {
                            StorageDataPropertyForm.this.description.setText("<form><p>" + string.substring(0, 150) + ".. <a href=\"More\">[More]</a></p></form>", true, false);
                        } else {
                            StorageDataPropertyForm.this.description.setText(string, false, false);
                        }
                    } else {
                        StorageDataPropertyForm.this.description.setText("", false, false);
                    }
                    StorageDataPropertyForm.this.sizeOnDisk.setText(NumberFormatter.humanReadableByteCount(StorageDataPropertyForm.this.storageData.getDiskSize()));
                    StorageDataPropertyForm.this.labelsTableViewer.setInput((Object)StorageDataPropertyForm.this.storageData.getLabelList());
                    StorageDataPropertyForm.this.labelsTableViewer.refresh();
                    StorageDataPropertyForm.this.addNewLabel.setEnabled(StorageDataPropertyForm.this.isRemoteStorageDisplayed());
                    if (StorageDataPropertyForm.this.isRemoteStorageDisplayed()) {
                        CmrRepositoryDefinition cmrRepositoryDefinition = StorageDataPropertyForm.this.storageDataProvider.getCmrRepositoryDefinition();
                        StorageDataPropertyForm.this.repository.setText(String.valueOf(cmrRepositoryDefinition.getName()) + " (" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort() + ")");
                        StorageDataPropertyForm.this.state.setText(TextFormatter.getStorageStateTextualRepresentation(StorageDataPropertyForm.this.storageDataProvider.getStorageData().getState()));
                        Image image = ImageFormatter.getImageForStorageLeaf((StorageData)StorageDataPropertyForm.this.storageData);
                        StorageDataPropertyForm.this.form.setImage(image);
                    } else {
                        StorageDataPropertyForm.this.repository.setText("Available locally");
                        StorageDataPropertyForm.this.state.setText("Downloaded");
                        StorageDataPropertyForm.this.form.setImage(InspectIT.getDefault().getImage("/icons/eclipse/storage_download.gif"));
                    }
                } else {
                    StorageDataPropertyForm.this.form.setText(null);
                    StorageDataPropertyForm.this.form.setMessage("Please select a storage to see its properties.", 1);
                    StorageDataPropertyForm.this.mainComposite.setVisible(false);
                }
                StorageDataPropertyForm.this.form.getBody().layout(true, true);
                StorageDataPropertyForm.this.form.setBusy(false);
            }
        });
    }

    private void showStorageDescriptionBox() {
        int n = 67696;
        PopupDialog popupDialog = new PopupDialog(this.form.getShell(), n, true, false, false, false, false, "Storage description", "Storage description"){
            private static final int CURSOR_SIZE = 15;

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                Text text = StorageDataPropertyForm.this.toolkit.createText(composite, null, 842);
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 3;
                gridData.verticalIndent = 3;
                text.setLayoutData((Object)gridData);
                text.setText(StorageDataPropertyForm.this.storageData.getDescription());
                return composite2;
            }

            protected Point getInitialLocation(Point point) {
                Display display = this.getShell().getDisplay();
                Point point2 = display.getCursorLocation();
                point2.x += 15;
                point2.y += 15;
                return point2;
            }

            protected Point getInitialSize() {
                return new Point(400, 200);
            }
        };
        popupDialog.open();
    }

    private void refreshStorageManagerView(CmrRepositoryDefinition cmrRepositoryDefinition) {
        IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
        if (iViewPart instanceof StorageManagerView) {
            ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
        }
    }

    private boolean isDataExistsForDisplay() {
        return this.storageData != null;
    }

    private boolean isRemoteStorageDisplayed() {
        return this.storageDataProvider != null;
    }

    public boolean isDisposed() {
        return this.form.isDisposed();
    }

    public void dispose() {
        this.form.dispose();
    }
}

