/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.form;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.CmrStatusData;
import info.novatec.inspectit.communication.data.cmr.RecordingData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.recording.RecordingState;
import info.novatec.inspectit.util.ObjectUtils;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.UIJob;

public class CmrRepositoryPropertyForm
implements ISelectionChangedListener {
    private static final int MAX_DESCRIPTION_LENGTH = 150;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private RecordingData recordingData;
    private RecordCountdownJob recordCountdownJob = new RecordCountdownJob();
    private UpdateCmrPropertiesJob updateCmrPropertiesJob = new UpdateCmrPropertiesJob();
    private Composite mainComposite;
    private FormToolkit toolkit;
    private ManagedForm managedForm;
    private ScrolledForm form;
    private Label address;
    private FormText description;
    private Label recordingIcon;
    private Label recordingStorage;
    private Label status;
    private Label bufferDate;
    private ProgressBar bufferBar;
    private ProgressBar recTimeBar;
    private Label recordingStatusIcon;
    private Label recordingLabel;
    private Label version;
    private Label bufferSize;
    private Label recTime;
    private Label spaceLeftLabel;
    private ProgressBar spaceLeftBar;
    private Label uptimeLabel;
    private Label databaseSizeLabel;

    public CmrRepositoryPropertyForm(Composite composite) {
        this(composite, null);
    }

    public CmrRepositoryPropertyForm(Composite composite, CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.managedForm = new ManagedForm(composite);
        this.toolkit = this.managedForm.getToolkit();
        this.form = this.managedForm.getForm();
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.initWidget();
    }

    private void initWidget() {
        Composite composite = this.form.getBody();
        composite.setLayout((Layout)new TableWrapLayout());
        this.managedForm.getToolkit().decorateFormHeading(this.form.getForm());
        this.mainComposite = this.toolkit.createComposite(composite, 0);
        this.mainComposite.setLayout((Layout)new TableWrapLayout());
        this.mainComposite.setLayoutData((Object)new TableWrapData(256));
        Section section = this.toolkit.createSection(this.mainComposite, 256);
        section.setText("General information");
        Composite composite2 = this.toolkit.createComposite((Composite)section, 0);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite2.setLayout((Layout)tableWrapLayout);
        composite2.setLayoutData((Object)new TableWrapData(128));
        this.toolkit.createLabel(composite2, "Address:");
        this.address = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "Version:");
        this.version = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "Description:");
        this.description = this.toolkit.createFormText(composite2, true);
        this.description.setLayoutData((Object)new TableWrapData(128));
        this.description.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                CmrRepositoryPropertyForm.this.showCmrDescriptionBox();
            }
        });
        this.toolkit.createLabel(composite2, "Status:");
        this.status = this.toolkit.createLabel(composite2, null, 64);
        this.toolkit.createLabel(composite2, "Uptime:");
        this.uptimeLabel = this.toolkit.createLabel(composite2, null, 64);
        this.uptimeLabel.setToolTipText("Date started represents date/time on machine where CMR has been launched");
        this.toolkit.createLabel(composite2, "Database size:");
        this.databaseSizeLabel = this.toolkit.createLabel(composite2, null, 64);
        this.databaseSizeLabel.setToolTipText("Current size of the database on the CMR");
        section.setClient((Control)composite2);
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        Section section2 = this.toolkit.createSection(this.mainComposite, 256);
        section2.setText("Buffer status");
        Composite composite3 = this.toolkit.createComposite((Composite)section2, 0);
        tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite3.setLayout((Layout)tableWrapLayout);
        composite3.setLayoutData((Object)new TableWrapData(128));
        this.toolkit.createLabel(composite3, "Data in buffer since:");
        this.bufferDate = this.toolkit.createLabel(composite3, null, 64);
        this.toolkit.createLabel(composite3, "Buffer occupancy:");
        this.bufferBar = new ProgressBar(composite3, 65536);
        this.bufferBar.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(composite3, null);
        this.bufferSize = this.toolkit.createLabel(composite3, null, 0x1000000);
        this.bufferSize.setLayoutData((Object)new TableWrapData(256));
        section2.setClient((Control)composite3);
        section2.setLayout((Layout)new TableWrapLayout());
        section2.setLayoutData((Object)new TableWrapData(256));
        Section section3 = this.toolkit.createSection(this.mainComposite, 256);
        section3.setText("Storage status");
        Composite composite4 = this.toolkit.createComposite((Composite)section3, 0);
        tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite4.setLayout((Layout)tableWrapLayout);
        composite4.setLayoutData((Object)new TableWrapData(128));
        this.toolkit.createLabel(composite4, "Storage space left:");
        this.spaceLeftBar = new ProgressBar(composite4, 65536);
        this.spaceLeftBar.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(composite4, null);
        this.spaceLeftLabel = this.toolkit.createLabel(composite4, null, 0x1000000);
        this.spaceLeftLabel.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(composite4, "Recording:");
        Composite composite5 = this.toolkit.createComposite(composite4);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite5.setLayout((Layout)gridLayout);
        this.recordingIcon = this.toolkit.createLabel(composite5, null, 64);
        this.recordingLabel = this.toolkit.createLabel(composite5, null, 64);
        this.toolkit.createLabel(composite4, "Recording status:");
        this.recordingStatusIcon = this.toolkit.createLabel(composite4, null, 0);
        this.toolkit.createLabel(composite4, "Recording storage:");
        this.recordingStorage = this.toolkit.createLabel(composite4, null, 64);
        this.toolkit.createLabel(composite4, "Recording time left:");
        this.recTimeBar = new ProgressBar(composite4, 65536);
        this.recTimeBar.setVisible(false);
        this.recTimeBar.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(composite4, null);
        this.recTime = this.toolkit.createLabel(composite4, null, 0x1000000);
        this.recTime.setVisible(false);
        this.recTime.setLayoutData((Object)new TableWrapData(256));
        section3.setClient((Control)composite4);
        tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        section3.setLayout((Layout)tableWrapLayout);
        section3.setLayoutData((Object)new TableWrapData(256));
        this.refreshData();
    }

    public void setLayoutData(Object object) {
        this.form.setLayoutData(object);
    }

    public void refresh() {
        this.refreshData();
    }

    /*
     * Unable to fully structure code
     */
    public void selectionChanged(SelectionChangedEvent var1_1) {
        block4: {
            var2_2 = var1_1.getSelection();
            if (var2_2.isEmpty() || !(var2_2 instanceof StructuredSelection)) break block4;
            var3_3 = (StructuredSelection)var2_2;
            var4_4 = var3_3.getFirstElement();
            if (var4_4 instanceof Component) ** GOTO lbl13
            return;
lbl-1000:
            // 1 sources

            {
                if (var4_4 instanceof ICmrRepositoryProvider) {
                    if (!ObjectUtils.equals((Object)this.cmrRepositoryDefinition, (Object)((ICmrRepositoryProvider)var4_4).getCmrRepositoryDefinition())) {
                        this.cmrRepositoryDefinition = ((ICmrRepositoryProvider)var4_4).getCmrRepositoryDefinition();
                        this.refreshData();
                    }
                    return;
                }
                var4_4 = ((Component)var4_4).getParent();
lbl13:
                // 2 sources

                ** while (var4_4 != null)
            }
        }
        if (this.cmrRepositoryDefinition != null) {
            this.cmrRepositoryDefinition = null;
            this.refreshData();
        }
    }

    private void showCmrDescriptionBox() {
        int n = 67696;
        PopupDialog popupDialog = new PopupDialog(this.form.getShell(), n, true, false, false, false, false, "CMR description", "CMR description"){
            private static final int CURSOR_SIZE = 15;

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                Text text = CmrRepositoryPropertyForm.this.toolkit.createText(composite, null, 842);
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 3;
                gridData.verticalIndent = 3;
                text.setLayoutData((Object)gridData);
                text.setText(CmrRepositoryPropertyForm.this.cmrRepositoryDefinition.getDescription());
                return composite2;
            }

            protected Point getInitialLocation(Point point) {
                Display display = this.getShell().getDisplay();
                Point point2 = display.getCursorLocation();
                point2.x += 15;
                point2.y += 15;
                return point2;
            }

            protected Point getInitialSize() {
                return new Point(400, 200);
            }
        };
        popupDialog.open();
    }

    private void refreshData() {
        if (this.updateCmrPropertiesJob.cancel()) {
            this.updateCmrPropertiesJob.schedule();
        }
    }

    private void updateCmrManagementData(CmrStatusData cmrStatusData) {
        boolean bl = false;
        if (cmrStatusData != null) {
            bl = true;
            double d = (double)cmrStatusData.getMaxBufferSize() / 1048576.0;
            double d2 = (double)cmrStatusData.getCurrentBufferSize() / 1048576.0;
            this.bufferBar.setMaximum((int)Math.round(d));
            this.bufferBar.setSelection((int)Math.round(d2));
            int n = (int)(100L * Math.round(d2) / Math.round(d));
            String string = NumberFormatter.humanReadableByteCount(cmrStatusData.getCurrentBufferSize());
            String string2 = NumberFormatter.humanReadableByteCount(cmrStatusData.getMaxBufferSize());
            String string3 = String.valueOf(n) + "% (" + string + " / " + string2 + ")";
            this.bufferSize.setText(string3);
            DefaultData defaultData = cmrStatusData.getBufferOldestElement();
            if (defaultData != null) {
                this.bufferDate.setText(NumberFormatter.formatTime(defaultData.getTimeStamp().getTime()));
            } else {
                this.bufferDate.setText("-");
            }
            int n2 = (int)(100.0 * (double)cmrStatusData.getStorageDataSpaceLeft() / (double)cmrStatusData.getStorageMaxDataSpace());
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(n2));
            stringBuilder.append("% (");
            stringBuilder.append(NumberFormatter.humanReadableByteCount(cmrStatusData.getStorageDataSpaceLeft()));
            stringBuilder.append(" / ");
            stringBuilder.append(NumberFormatter.humanReadableByteCount(cmrStatusData.getStorageMaxDataSpace()));
            stringBuilder.append(')');
            this.spaceLeftLabel.setText(stringBuilder.toString());
            this.spaceLeftBar.setMaximum((int)(cmrStatusData.getStorageMaxDataSpace() / 1024L / 1024L));
            this.spaceLeftBar.setSelection((int)(cmrStatusData.getStorageDataSpaceLeft() / 1024L / 1024L));
            if (!cmrStatusData.isCanWriteMore()) {
                this.spaceLeftBar.setForeground(Display.getDefault().getSystemColor(3));
                this.spaceLeftBar.setToolTipText("Space left is critically low and no write is possible anymore");
            } else if (cmrStatusData.isWarnSpaceLeftActive()) {
                this.spaceLeftBar.setForeground(Display.getDefault().getSystemColor(8));
                this.spaceLeftBar.setToolTipText("Space left is reaching critical level");
            } else {
                this.spaceLeftBar.setForeground(Display.getDefault().getSystemColor(5));
                this.spaceLeftBar.setToolTipText("Enough space left");
            }
            long l = cmrStatusData.getUpTime();
            Date date = cmrStatusData.getDateStarted();
            StringBuilder stringBuilder2 = new StringBuilder(NumberFormatter.humanReadableMillisCount(l, true));
            stringBuilder2.append(" (started ");
            stringBuilder2.append(DateFormat.getDateTimeInstance(3, 3).format(date));
            stringBuilder2.append(')');
            this.uptimeLabel.setText(stringBuilder2.toString());
            Long l2 = cmrStatusData.getDatabaseSize();
            if (l2 != null) {
                this.databaseSizeLabel.setText(NumberFormatter.humanReadableByteCount(l2));
            } else {
                this.databaseSizeLabel.setText("n/a");
            }
        }
        if (!bl) {
            this.bufferDate.setText("");
            this.bufferBar.setMaximum(Integer.MAX_VALUE);
            this.bufferBar.setSelection(0);
            this.bufferSize.setText("");
            this.spaceLeftBar.setMaximum(Integer.MAX_VALUE);
            this.spaceLeftBar.setSelection(0);
            this.spaceLeftBar.setToolTipText("");
            this.spaceLeftLabel.setText("");
            this.uptimeLabel.setText("");
            this.databaseSizeLabel.setText("");
        }
    }

    private void updateRecordingData(RecordingData recordingData) {
        boolean bl = false;
        boolean bl2 = false;
        this.recordingIcon.setImage(null);
        if (recordingData != null) {
            RecordingState recordingState = this.cmrRepositoryDefinition.getStorageService().getRecordingState();
            if (recordingState == RecordingState.ON) {
                this.recordingIcon.setImage(InspectIT.getDefault().getImage("/icons/eclipse/record.gif"));
                this.recordingLabel.setText("Active");
            } else if (recordingState == RecordingState.SCHEDULED) {
                this.recordingIcon.setImage(InspectIT.getDefault().getImage("/icons/eclipse/record_schedule.gif"));
                this.recordingLabel.setText("Scheduled @ " + DateFormat.getDateTimeInstance(3, 3).format(recordingData.getRecordStartDate()));
            }
            StorageData storageData = recordingData.getRecordingStorage();
            if (storageData != null) {
                this.recordingStorage.setText(storageData.getName());
            } else {
                this.recordingStorage.setText("");
            }
            if (recordingData.getRecordEndDate() != null) {
                bl = true;
            } else {
                this.recTimeBar.setVisible(false);
                this.recTime.setVisible(false);
            }
            this.recordingStatusIcon.setImage(ImageFormatter.getWritingStatusImage(recordingData.getRecordingWritingStatus()));
            this.recordingStatusIcon.setToolTipText(TextFormatter.getWritingStatusText(recordingData.getRecordingWritingStatus()));
            bl2 = true;
        } else {
            this.recordingIcon.setImage(InspectIT.getDefault().getImage("/icons/eclipse/record_gray.gif"));
        }
        if (!bl2) {
            this.recordingStorage.setText("");
            this.recTimeBar.setVisible(false);
            this.recTime.setVisible(false);
            this.recordingStatusIcon.setImage(null);
            this.recordingStatusIcon.setToolTipText("");
            this.recordingLabel.setText("Not Active");
        }
        if (bl) {
            this.recordCountdownJob.schedule();
        } else {
            this.recordCountdownJob.cancel();
        }
    }

    public boolean isDisposed() {
        return this.form.isDisposed();
    }

    public void dispose() {
        this.form.dispose();
        this.recordCountdownJob.cancel();
    }

    private class RecordCountdownJob
    extends UIJob {
        public RecordCountdownJob() {
            super("Update Recording Countdown");
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (CmrRepositoryPropertyForm.this.recordingData != null && !CmrRepositoryPropertyForm.this.form.isDisposed()) {
                Date date = CmrRepositoryPropertyForm.this.recordingData.getRecordEndDate();
                Date date2 = CmrRepositoryPropertyForm.this.recordingData.getRecordStartDate();
                if (date != null && date2 != null && date2.before(new Date())) {
                    Date date3 = new Date();
                    long l = date.getTime() - date3.getTime();
                    if (l > 0L) {
                        if (!CmrRepositoryPropertyForm.this.recTimeBar.isVisible()) {
                            CmrRepositoryPropertyForm.this.recTimeBar.setVisible(true);
                        }
                        CmrRepositoryPropertyForm.this.recTimeBar.setMaximum((int)(date.getTime() - date2.getTime()));
                        CmrRepositoryPropertyForm.this.recTimeBar.setSelection((int)((long)CmrRepositoryPropertyForm.this.recTimeBar.getMaximum() - (date3.getTime() - date2.getTime())));
                        if (!CmrRepositoryPropertyForm.this.recTime.isVisible()) {
                            CmrRepositoryPropertyForm.this.recTime.setVisible(true);
                        }
                        String string = l > 0L ? NumberFormatter.humanReadableMillisCount(l, false) : "";
                        CmrRepositoryPropertyForm.this.recTime.setText(string);
                    } else {
                        if (CmrRepositoryPropertyForm.this.recTimeBar.isVisible()) {
                            CmrRepositoryPropertyForm.this.recTimeBar.setVisible(false);
                        }
                        if (CmrRepositoryPropertyForm.this.recTime.isVisible()) {
                            CmrRepositoryPropertyForm.this.recTime.setVisible(false);
                        }
                        this.cancel();
                        CmrRepositoryPropertyForm.this.refreshData();
                    }
                }
            }
            this.schedule(1000L);
            return Status.OK_STATUS;
        }
    }

    private class UpdateCmrPropertiesJob
    extends Job {
        public UpdateCmrPropertiesJob() {
            super("Updating CMR Properties..");
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            final CmrRepositoryDefinition cmrRepositoryDefinition = CmrRepositoryPropertyForm.this.cmrRepositoryDefinition;
            if (cmrRepositoryDefinition != null) {
                final CmrRepositoryDefinition.OnlineStatus onlineStatus = cmrRepositoryDefinition.getOnlineStatus();
                final CmrStatusData cmrStatusData = onlineStatus == CmrRepositoryDefinition.OnlineStatus.ONLINE ? cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData() : null;
                CmrRepositoryPropertyForm.this.recordingData = onlineStatus == CmrRepositoryDefinition.OnlineStatus.ONLINE ? cmrRepositoryDefinition.getStorageService().getRecordingData() : null;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CmrRepositoryPropertyForm.this.form.setBusy(true);
                        CmrRepositoryPropertyForm.this.form.setText(cmrRepositoryDefinition.getName());
                        CmrRepositoryPropertyForm.this.form.setMessage(null, 0);
                        CmrRepositoryPropertyForm.this.address.setText(String.valueOf(cmrRepositoryDefinition.getIp()) + ":" + cmrRepositoryDefinition.getPort());
                        CmrRepositoryPropertyForm.this.version.setText(cmrRepositoryDefinition.getVersion());
                        String string = cmrRepositoryDefinition.getDescription();
                        if (string != null) {
                            if (string.length() > 150) {
                                CmrRepositoryPropertyForm.this.description.setText("<form><p>" + string.substring(0, 150) + ".. <a href=\"More\">[More]</a></p></form>", true, false);
                            } else {
                                CmrRepositoryPropertyForm.this.description.setText(string, false, false);
                            }
                        } else {
                            CmrRepositoryPropertyForm.this.description.setText("", false, false);
                        }
                        CmrRepositoryPropertyForm.this.status.setText(onlineStatus.toString());
                        if (onlineStatus == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                            CmrRepositoryPropertyForm.this.form.setImage(InspectIT.getDefault().getImage("/icons/selfmade/server_online_16x16.png"));
                        } else if (onlineStatus == CmrRepositoryDefinition.OnlineStatus.CHECKING) {
                            CmrRepositoryPropertyForm.this.form.setImage(InspectIT.getDefault().getImage("/icons/selfmade/server_refresh_16x16.png"));
                        } else {
                            CmrRepositoryPropertyForm.this.form.setImage(InspectIT.getDefault().getImage("/icons/selfmade/server_offline_16x16.png"));
                        }
                        CmrRepositoryPropertyForm.this.updateRecordingData(CmrRepositoryPropertyForm.this.recordingData);
                        CmrRepositoryPropertyForm.this.updateCmrManagementData(cmrStatusData);
                        CmrRepositoryPropertyForm.this.mainComposite.setVisible(true);
                        CmrRepositoryPropertyForm.this.form.getBody().layout(true, true);
                        CmrRepositoryPropertyForm.this.form.setBusy(false);
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CmrRepositoryPropertyForm.this.form.setBusy(true);
                        CmrRepositoryPropertyForm.this.form.setText(null);
                        CmrRepositoryPropertyForm.this.form.setMessage("Please select a CMR to see its properties.", 1);
                        CmrRepositoryPropertyForm.this.mainComposite.setVisible(false);
                        CmrRepositoryPropertyForm.this.updateRecordingData(null);
                        CmrRepositoryPropertyForm.this.updateCmrManagementData(null);
                        CmrRepositoryPropertyForm.this.mainComposite.setVisible(true);
                        CmrRepositoryPropertyForm.this.form.getBody().layout(true, true);
                        CmrRepositoryPropertyForm.this.form.setBusy(false);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

