/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.AbstractSubView;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchCriteria;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchResult;
import info.novatec.inspectit.rcp.editor.search.helper.DeferredTreeViewerSearchHelper;
import info.novatec.inspectit.rcp.editor.tooltip.ColumnAwareToolTipSupport;
import info.novatec.inspectit.rcp.editor.tooltip.IColumnToolTipProvider;
import info.novatec.inspectit.rcp.editor.tree.DeferredTreeViewer;
import info.novatec.inspectit.rcp.editor.tree.input.TreeInputController;
import info.novatec.inspectit.rcp.handlers.ShowHideColumnsHandler;
import info.novatec.inspectit.rcp.menu.ShowHideMenuManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TreeSubView
extends AbstractSubView
implements ISearchExecutor {
    private final TreeInputController treeInputController;
    private TreeViewer treeViewer;
    private volatile boolean jobInSchedule = false;
    private DeferredTreeViewerSearchHelper searchHelper;

    public TreeSubView(TreeInputController treeInputController) {
        Assert.isNotNull((Object)treeInputController);
        this.treeInputController = treeInputController;
    }

    @Override
    public void init() {
        this.treeInputController.setInputDefinition(this.getRootEditor().getInputDefinition());
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        Object object;
        TreeColumn treeColumn;
        Object object2;
        Object object3;
        final Tree tree = formToolkit.createTree(composite, 268503810);
        tree.setHeaderVisible(true);
        this.treeViewer = new DeferredTreeViewer(tree);
        this.treeInputController.createColumns(this.treeViewer);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider(this.treeInputController.getContentProvider());
        IBaseLabelProvider iBaseLabelProvider = this.treeInputController.getLabelProvider();
        this.treeViewer.setLabelProvider(iBaseLabelProvider);
        if (iBaseLabelProvider instanceof IColumnToolTipProvider) {
            ColumnAwareToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        }
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                TreeSubView.this.treeInputController.doubleClick(doubleClickEvent);
                TreeSelection treeSelection = (TreeSelection)doubleClickEvent.getSelection();
                TreePath treePath = treeSelection.getPaths()[0];
                if (treePath != null) {
                    boolean bl = TreeSubView.this.treeViewer.getExpandedState((Object)treePath);
                    if (bl) {
                        TreeSubView.this.treeViewer.collapseToLevel((Object)treePath, 1);
                    } else {
                        TreeSubView.this.treeViewer.expandToLevel((Object)treePath, 1);
                    }
                }
            }
        });
        this.treeViewer.setComparator(this.treeInputController.getComparator());
        if (this.treeViewer.getComparator() != null) {
            object2 = object3 = this.treeViewer.getTree().getColumns();
            int n = ((TreeColumn[])object3).length;
            int n2 = 0;
            while (n2 < n) {
                treeColumn = object2[n2];
                treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TreeSubView.this.treeViewer.refresh();
                    }
                });
                ++n2;
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])this.treeInputController.getFilters())) {
            this.treeViewer.setFilters(this.treeInputController.getFilters());
        }
        object3 = new ShowHideMenuManager((ColumnViewer)this.treeViewer, this.treeInputController.getClass());
        object3.setRemoveAllWhenShown(false);
        treeColumn = new MenuManager();
        treeColumn.setRemoveAllWhenShown(true);
        this.getRootEditor().getSite().registerContextMenu("inspectit.editor.formrooteditor.treesubview", (MenuManager)treeColumn, (ISelectionProvider)this.treeViewer);
        final Menu menu = treeColumn.createContextMenu((Control)tree);
        final Menu menu2 = object3.createContextMenu((Control)tree);
        tree.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean bl;
                Point point = Display.getDefault().map(null, (Control)tree, new Point(event.x, event.y));
                Rectangle rectangle = tree.getClientArea();
                boolean bl2 = bl = rectangle.y <= point.y && point.y < rectangle.y + tree.getHeaderHeight();
                if (bl) {
                    tree.setMenu(menu2);
                } else {
                    tree.setMenu(menu);
                }
            }
        });
        tree.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!menu2.isDisposed()) {
                    menu2.dispose();
                }
                if (!menu.isDisposed()) {
                    menu.dispose();
                }
            }
        });
        object2 = this.treeInputController.getTreeInput();
        this.treeViewer.setInput(object2);
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TreeColumn treeColumn;
                if (controlEvent.widget instanceof TreeColumn && (treeColumn = (TreeColumn)controlEvent.widget).getWidth() > 0) {
                    ShowHideColumnsHandler.registerNewColumnWidth(TreeSubView.this.treeInputController.getClass(), treeColumn.getText(), treeColumn.getWidth());
                }
            }

            public void controlMoved(ControlEvent controlEvent) {
                ShowHideColumnsHandler.setColumnOrder(TreeSubView.this.treeInputController.getClass(), TreeSubView.this.treeViewer.getTree().getColumnOrder());
            }
        };
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n3 = 0;
        while (n3 < n) {
            object = treeColumnArray[n3];
            if (this.treeInputController.canAlterColumnWidth((TreeColumn)object)) {
                Integer n4 = ShowHideColumnsHandler.getRememberedColumnWidth(this.treeInputController.getClass(), object.getText());
                boolean bl = ShowHideColumnsHandler.isColumnHidden(this.treeInputController.getClass(), object.getText());
                if (n4 != null && !bl) {
                    object.setWidth(n4.intValue());
                    object.setResizable(true);
                } else if (bl) {
                    object.setWidth(0);
                    object.setResizable(false);
                }
            }
            object.addControlListener((ControlListener)controlAdapter);
            ++n3;
        }
        object = ShowHideColumnsHandler.getColumnOrder(this.treeInputController.getClass());
        if (object != null && ((TreeColumn)object).length == tree.getColumns().length) {
            tree.setColumnOrder((int[])object);
        } else if (object != null) {
            ShowHideColumnsHandler.setColumnOrder(this.treeInputController.getClass(), tree.getColumnOrder());
        }
        this.searchHelper = new DeferredTreeViewerSearchHelper((DeferredTreeViewer)this.treeViewer, this.treeInputController, this.getRootEditor().getInputDefinition().getRepositoryDefinition());
    }

    @Override
    public void doRefresh() {
        if (!this.jobInSchedule) {
            this.jobInSchedule = true;
            Job job = new Job(this.getDataLoadingJobName()){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            TreeSubView.this.treeInputController.doRefresh(iProgressMonitor, TreeSubView.this.getRootEditor());
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (TreeSubView.this.checkDisposed()) {
                                        return;
                                    }
                                    if (TreeSubView.this.treeInputController.getSubViewClassification() == SubViewClassificationController.SubViewClassification.MASTER) {
                                        Object object = TreeSubView.this.treeInputController.getTreeInput();
                                        TreeSubView.this.treeViewer.setInput(object);
                                        if (TreeSubView.this.treeViewer.getTree().isVisible()) {
                                            TreeSubView.this.treeViewer.refresh();
                                            TreeSubView.this.treeViewer.expandToLevel(TreeSubView.this.treeInputController.getExpandLevel());
                                        }
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException("Unknown exception occurred trying to refresh the view.", throwable);
                        }
                    }
                    finally {
                        TreeSubView.this.jobInSchedule = false;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.treeInputController.canOpenInput(list)) {
            this.treeViewer.setInput(list);
            this.treeViewer.expandToLevel(this.treeInputController.getExpandLevel());
            this.treeViewer.refresh();
        }
    }

    @Override
    public Control getControl() {
        return this.treeViewer.getControl();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.treeViewer;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        return this.treeInputController.getPreferenceIds();
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        if (this.checkDisposed()) {
            return;
        }
        this.treeInputController.preferenceEventFired(preferenceEvent);
        switch (preferenceEvent.getPreferenceId()) {
            case FILTERDATATYPE: 
            case INVOCFILTEREXCLUSIVETIME: 
            case INVOCFILTERTOTALTIME: {
                if (!ArrayUtils.isNotEmpty((Object[])this.treeInputController.getFilters())) break;
                this.treeViewer.setFilters(this.treeInputController.getFilters());
                break;
            }
            case CLEAR_BUFFER: {
                if (!this.treeInputController.getPreferenceIds().contains((Object)PreferenceId.CLEAR_BUFFER)) break;
                this.treeViewer.refresh();
                this.treeViewer.expandToLevel(this.treeInputController.getExpandLevel());
                break;
            }
            case TIME_RESOLUTION: {
                if (!this.treeInputController.getPreferenceIds().contains((Object)PreferenceId.TIME_RESOLUTION)) break;
                this.treeViewer.refresh();
                this.treeViewer.expandToLevel(this.treeInputController.getExpandLevel());
                break;
            }
            case INVOCATION_SUBVIEW_MODE: {
                if (!this.treeInputController.getPreferenceIds().contains((Object)PreferenceId.INVOCATION_SUBVIEW_MODE)) break;
                this.treeViewer.refresh();
                this.treeViewer.expandToLevel(this.treeInputController.getExpandLevel());
                break;
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public TreeInputController getTreeInputController() {
        return this.treeInputController;
    }

    public List<String> getColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            arrayList.add(treeColumn.getText());
            ++n2;
        }
        return arrayList;
    }

    public List<Integer> getColumnOrder() {
        int[] nArray = this.treeViewer.getTree().getColumnOrder();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (this.treeViewer.getTree().getColumns()[n3].getWidth() > 0) {
                arrayList.add(n3);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public ISubView getSubViewWithInputController(Class<?> clazz) {
        if (Objects.equals(clazz, this.treeInputController.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public SearchResult executeSearch(SearchCriteria searchCriteria) {
        return this.searchHelper.executeSearch(searchCriteria);
    }

    @Override
    public SearchResult next() {
        return this.searchHelper.next();
    }

    @Override
    public SearchResult previous() {
        return this.searchHelper.previous();
    }

    @Override
    public void clearSearch() {
        this.searchHelper.clearSearch();
    }

    private boolean checkDisposed() {
        return this.treeViewer.getTree().isDisposed();
    }

    @Override
    public void dispose() {
        this.treeInputController.dispose();
    }
}

