/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tooltip;

import info.novatec.inspectit.rcp.editor.tooltip.IColumnToolTipProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;

public class ColumnAwareToolTipSupport
extends ColumnViewerToolTipSupport {
    private static final String VIEWER_CELL_KEY = "org.eclipse.jface_VIEWER_CELL_KEY";
    private static final int DEFAULT_SHIFT_X = 10;
    private static final int DEFAULT_SHIFT_Y = 0;
    private ColumnViewer viewer;

    public ColumnAwareToolTipSupport(ColumnViewer columnViewer, int n, boolean bl) {
        super(columnViewer, n, bl);
        this.viewer = columnViewer;
    }

    public static void enableFor(ColumnViewer columnViewer) {
        new ColumnAwareToolTipSupport(columnViewer, 2, false);
    }

    public static void enableFor(ColumnViewer columnViewer, int n) {
        new ColumnAwareToolTipSupport(columnViewer, n, false);
    }

    protected boolean shouldCreateToolTip(Event event) {
        Point point = new Point(event.x, event.y);
        ViewerCell viewerCell = this.viewer.getCell(point);
        if (viewerCell == null) {
            return false;
        }
        CellLabelProvider cellLabelProvider = this.viewer.getLabelProvider(viewerCell.getColumnIndex());
        if (cellLabelProvider instanceof IColumnToolTipProvider) {
            IColumnToolTipProvider iColumnToolTipProvider = (IColumnToolTipProvider)cellLabelProvider;
            Object object = viewerCell.getViewerRow().getItem().getData();
            String string = iColumnToolTipProvider.getToolTipText(object, viewerCell.getColumnIndex());
            Image image = iColumnToolTipProvider.getToolTipImage(object, viewerCell.getColumnIndex());
            if (string == null && image == null) {
                return false;
            }
            this.viewer.getControl().setToolTipText("");
            this.setPopupDelay(cellLabelProvider.getToolTipDisplayDelayTime(object));
            this.setHideDelay(cellLabelProvider.getToolTipTimeDisplayed(object));
            Point point2 = cellLabelProvider.getToolTipShift(object);
            if (point2 == null) {
                this.setShift(new Point(10, 0));
            } else {
                this.setShift(new Point(point2.x, point2.y));
            }
            this.setData(VIEWER_CELL_KEY, viewerCell);
            this.setText(string);
            this.setImage(image);
            this.setStyle(cellLabelProvider.getToolTipStyle(object));
            this.setForegroundColor(cellLabelProvider.getToolTipForegroundColor(object));
            this.setBackgroundColor(cellLabelProvider.getToolTipBackgroundColor(object));
            this.setFont(cellLabelProvider.getToolTipFont(object));
            return true;
        }
        return super.shouldCreateToolTip(event);
    }
}

