/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.AbstractPlotDataSolver;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.PlotDataSolver;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.impl.PlotDataSolverFactory;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JmxInfoTextInputController
extends AbstractTextInputController {
    private static final String SECTION_AGGREGATED_DETAILS = "Aggregated Details";
    private static final String SECTION_VALUE_DETAILS = "Latest Value Details";
    private static final String SECTION_BEAN_DETAILS = "MBean Details";
    private static final String NOT_AVAILABLE = "N/A";
    private JmxSensorValueData template;
    private ICachedDataService cachedDataService;
    private Label dataTypeLabel;
    private Label packageLabel;
    private Label timestampLabel;
    private Label valueLabel;
    private Label typeLabel;
    private Label attributeLabel;
    private Label maxValueLabel;
    private Label minValueLabel;
    private Label averageValueLabel;
    private Label countLabel;
    private Label descriptionLabel;
    private JmxDefinitionDataIdent jmxIdent;
    private List<JmxSensorValueData> currentData;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new JmxSensorValueData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setJmxSensorDefinitionDataIdentId(inputDefinition.getIdDefinition().getJmxDefinitionId());
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.addSection(composite, formToolkit, SECTION_BEAN_DETAILS);
        if (this.sections.containsKey(SECTION_BEAN_DETAILS)) {
            this.addItemToSection(formToolkit, SECTION_BEAN_DETAILS, "Domain: ", InspectIT.getDefault().getImage("/icons/eclipse/package_obj.gif"));
            this.packageLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_BEAN_DETAILS), NOT_AVAILABLE, 16384);
            this.packageLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_BEAN_DETAILS, "Type: ", InspectIT.getDefault().getImage("/icons/fugue/book.png"));
            this.typeLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_BEAN_DETAILS), NOT_AVAILABLE, 16384);
            this.typeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_BEAN_DETAILS, "Attribute: ", InspectIT.getDefault().getImage("/icons/fugue/blue-document-table.png"));
            this.attributeLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_BEAN_DETAILS), NOT_AVAILABLE, 16384);
            this.attributeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_BEAN_DETAILS, "Data type: ");
            this.dataTypeLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_BEAN_DETAILS), NOT_AVAILABLE, 16384);
            this.dataTypeLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_BEAN_DETAILS, "Description: ", InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
            this.descriptionLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_BEAN_DETAILS), NOT_AVAILABLE, 16384);
            this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.addSection(composite, formToolkit, SECTION_VALUE_DETAILS);
        if (this.sections.containsKey(SECTION_VALUE_DETAILS)) {
            this.addItemToSection(formToolkit, SECTION_VALUE_DETAILS, "Timestamp: ", InspectIT.getDefault().getImage("/icons/eclipse/dates.gif"));
            this.timestampLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_VALUE_DETAILS), NOT_AVAILABLE, 16384);
            this.timestampLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_VALUE_DETAILS, "Value: ");
            this.valueLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_VALUE_DETAILS), NOT_AVAILABLE, 16384);
            this.valueLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.addSection(composite, formToolkit, SECTION_AGGREGATED_DETAILS);
        if (this.sections.containsKey(SECTION_AGGREGATED_DETAILS)) {
            this.addItemToSection(formToolkit, SECTION_AGGREGATED_DETAILS, "Count: ", InspectIT.getDefault().getImage("/icons/fugue/counter.png"));
            this.countLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_AGGREGATED_DETAILS), NOT_AVAILABLE, 16384);
            this.countLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_AGGREGATED_DETAILS, "Average: ");
            this.averageValueLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_AGGREGATED_DETAILS), NOT_AVAILABLE, 16384);
            this.averageValueLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_AGGREGATED_DETAILS, "Min: ");
            this.minValueLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_AGGREGATED_DETAILS), NOT_AVAILABLE, 16384);
            this.minValueLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_AGGREGATED_DETAILS, "Max: ");
            this.maxValueLabel = formToolkit.createLabel((Composite)this.sections.get(SECTION_AGGREGATED_DETAILS), NOT_AVAILABLE, 16384);
            this.maxValueLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        if (this.currentData != null && !this.currentData.isEmpty()) {
            Map map;
            final JmxSensorValueData jmxSensorValueData = this.currentData.get(this.currentData.size() - 1);
            if (this.jmxIdent == null) {
                this.jmxIdent = this.cachedDataService.getJmxDefinitionDataIdentForId(jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            }
            final AbstractPlotDataSolver abstractPlotDataSolver = (map = (Map)PreferencesUtils.getObject("JMX_PLOT_DATA_SOLVER")).containsKey(this.jmxIdent.getDerivedFullName()) ? PlotDataSolverFactory.getDataSolver(PlotDataSolver.valueOf((String)map.get(this.jmxIdent.getDerivedFullName()))) : PlotDataSolverFactory.getDefaultDataSolver();
            final String[] stringArray = this.getAggregatedData(abstractPlotDataSolver);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JmxInfoTextInputController.this.packageLabel.setText(JmxInfoTextInputController.this.jmxIdent.getDerivedDomainName());
                    JmxInfoTextInputController.this.typeLabel.setText(JmxInfoTextInputController.this.jmxIdent.getDerivedTypeName());
                    JmxInfoTextInputController.this.attributeLabel.setText(JmxInfoTextInputController.this.jmxIdent.getmBeanAttributeName());
                    JmxInfoTextInputController.this.dataTypeLabel.setText(JmxInfoTextInputController.this.jmxIdent.getmBeanAttributeType());
                    JmxInfoTextInputController.this.descriptionLabel.setText(JmxInfoTextInputController.this.jmxIdent.getmBeanAttributeDescription());
                    JmxInfoTextInputController.this.timestampLabel.setText(NumberFormatter.formatTime(jmxSensorValueData.getTimeStamp()));
                    JmxInfoTextInputController.this.valueLabel.setText(abstractPlotDataSolver.valueToHumanReadable(jmxSensorValueData.getValueAsDouble()));
                    JmxInfoTextInputController.this.averageValueLabel.setText(stringArray[0]);
                    JmxInfoTextInputController.this.minValueLabel.setText(stringArray[1]);
                    JmxInfoTextInputController.this.maxValueLabel.setText(stringArray[2]);
                    JmxInfoTextInputController.this.countLabel.setText(stringArray[3]);
                }
            });
        }
    }

    private String[] getAggregatedData(AbstractPlotDataSolver abstractPlotDataSolver) {
        String[] stringArray = new String[]{NOT_AVAILABLE, NOT_AVAILABLE, NOT_AVAILABLE, NOT_AVAILABLE};
        if (this.currentData.isEmpty() || !abstractPlotDataSolver.isAggregatable()) {
            return stringArray;
        }
        double[] dArray = new double[]{0.0, Double.MAX_VALUE, Double.MIN_VALUE};
        int n = 0;
        for (JmxSensorValueData jmxSensorValueData : this.currentData) {
            double d = abstractPlotDataSolver.valueConvert(jmxSensorValueData.getAverageValue());
            double d2 = abstractPlotDataSolver.valueConvert(jmxSensorValueData.getMinValue());
            double d3 = abstractPlotDataSolver.valueConvert(jmxSensorValueData.getMaxValue());
            dArray[0] = dArray[0] + d;
            if (dArray[1] > d2) {
                dArray[1] = d2;
            }
            if (dArray[2] < d3) {
                dArray[2] = d3;
            }
            n += jmxSensorValueData.getAggregationCount();
        }
        dArray[0] = dArray[0] / (double)this.currentData.size();
        int n2 = 0;
        while (n2 < 3) {
            stringArray[n2] = abstractPlotDataSolver.valueToHumanReadable(dArray[n2]);
            ++n2;
        }
        stringArray[3] = String.valueOf(n);
        return stringArray;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        this.currentData = new ArrayList<JmxSensorValueData>();
        for (DefaultData defaultData : list) {
            if (!(defaultData instanceof JmxSensorValueData)) continue;
            this.currentData.add((JmxSensorValueData)defaultData);
        }
        this.doRefresh();
    }
}

