/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.CpuInformationData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CpuInputController
extends AbstractTextInputController {
    public static final String ID = "inspectit.subview.text.cpu";
    private static final String SECTION_CPU = "CPU";
    private static final String NOT_AVAILABLE = "N/A";
    private CpuInformationData cpuObj;
    private Label cpuUsage;
    private Label processCpuTime;
    private IGlobalDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cpuObj = new CpuInformationData();
        this.cpuObj.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.addSection(composite, formToolkit, SECTION_CPU);
        if (this.sections.containsKey(SECTION_CPU)) {
            this.addItemToSection(formToolkit, SECTION_CPU, "Cpu Usage: ");
            this.cpuUsage = formToolkit.createLabel((Composite)this.sections.get(SECTION_CPU), "n/a", 16384);
            this.cpuUsage.setLayoutData((Object)new GridData(4, 4, true, false));
            this.addItemToSection(formToolkit, SECTION_CPU, "Process Cpu Time: ");
            this.processCpuTime = formToolkit.createLabel((Composite)this.sections.get(SECTION_CPU), "n/a", 16384);
            this.processCpuTime.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        final CpuInformationData cpuInformationData = (CpuInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.cpuObj);
        if (cpuInformationData != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int n = cpuInformationData.getCount();
                    if (cpuInformationData.getTotalCpuUsage() > 0.0f) {
                        CpuInputController.this.cpuUsage.setText(NumberFormatter.formatCpuPercent(cpuInformationData.getTotalCpuUsage() / (float)n));
                    } else {
                        CpuInputController.this.cpuUsage.setText(CpuInputController.NOT_AVAILABLE);
                    }
                    if (cpuInformationData.getProcessCpuTime() > 0L) {
                        CpuInputController.this.processCpuTime.setText(NumberFormatter.formatNanosToSeconds(cpuInformationData.getProcessCpuTime()));
                    } else {
                        CpuInputController.this.processCpuTime.setText(CpuInputController.NOT_AVAILABLE);
                    }
                }
            });
        }
    }

    @Override
    public void dispose() {
    }
}

