/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.InvocOverviewInputController;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MultiInvocDataInputController
extends InvocOverviewInputController {
    public static final Object ADDITIONAL_OPTION_KEY = "MULTI_INVOCATION_LIST";
    private List<InvocationSequenceData> invocationList;
    private List<InvocationSequenceData> loadedInvocations;
    private List<InvocationSequenceData> selectedList;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.COMBINED_INVOCATIONS_EXTRAS_MARKER)) {
            this.invocationList = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.COMBINED_INVOCATIONS_EXTRAS_MARKER).getTemplates();
        }
        super.setInputDefinition(inputDefinition);
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
        }
        return enumSet;
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return false;
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        InvocOverviewInputController.Column[] columnArray = InvocOverviewInputController.Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            InvocOverviewInputController.Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, this.getCachedDataService());
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Updating Invocation Overview", this.invocationList.size());
        iProgressMonitor.subTask("Retrieving the Invocation Overview from the CMR");
        this.loadedInvocations = new ArrayList<InvocationSequenceData>();
        for (InvocationSequenceData invocationSequenceData : this.invocationList) {
            this.loadedInvocations.add(this.getDataAccessService().getInvocationSequenceDetail(invocationSequenceData));
            iProgressMonitor.worked(1);
        }
        this.getInvocationSequenceData().clear();
        if (!this.loadedInvocations.isEmpty()) {
            iProgressMonitor.subTask("Displaying the Invocation Overview");
            this.getInvocationSequenceData().addAll(this.loadedInvocations);
        }
        this.selectedList = new ArrayList<InvocationSequenceData>(this.loadedInvocations);
        this.passSelectedList();
        iProgressMonitor.done();
    }

    @Override
    public void objectChecked(Object object, boolean bl) {
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            if (bl) {
                for (InvocationSequenceData invocationSequenceData2 : this.loadedInvocations) {
                    if (invocationSequenceData2.getId() != invocationSequenceData.getId()) continue;
                    if (this.selectedList.contains(invocationSequenceData2)) break;
                    this.selectedList.add(invocationSequenceData2);
                    break;
                }
            } else {
                for (InvocationSequenceData invocationSequenceData3 : this.selectedList) {
                    if (invocationSequenceData3.getId() != invocationSequenceData.getId()) continue;
                    this.selectedList.remove(invocationSequenceData3);
                    break;
                }
            }
            this.passSelectedList();
        }
    }

    @Override
    public boolean isCheckStyle() {
        return true;
    }

    @Override
    public boolean areItemsInitiallyChecked() {
        return true;
    }

    private void passSelectedList() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                iRootEditor.setDataInput(MultiInvocDataInputController.this.selectedList);
            }
        });
    }
}

