/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.comparator.AggregatedExceptionSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ExceptionSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.MethodSensorDataComparatorEnum;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.aggregation.impl.ExceptionDataAggregator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.RawAggregatedResultComparator;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.handlers.ShowHideColumnsHandler;
import info.novatec.inspectit.rcp.model.ExceptionImageFactory;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

public class ExceptionSensorInvocInputController
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.exceptionsensorinvoc";
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ICachedDataService cachedDataService;
    private List<ExceptionSensorData> exceptionSensorDataList;
    private final StyledString emptyStyledString = new StyledString();
    private boolean rawMode = false;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            if (column.showInAggregatedMode) {
                tableViewerColumn.getColumn().setWidth(column.width);
            } else {
                tableViewerColumn.getColumn().setWidth(0);
            }
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            super.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public boolean canAlterColumnWidth(TableColumn tableColumn) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (Objects.equals(this.getMappedTableViewerColumn(column).getColumn(), tableColumn)) {
                return column.showInRawMode && this.rawMode || column.showInAggregatedMode && !this.rawMode;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        enumSet.add(PreferenceId.INVOCATION_SUBVIEW_MODE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        Map<IPreferenceGroup, Object> map;
        if (PreferenceId.INVOCATION_SUBVIEW_MODE.equals((Object)preferenceEvent.getPreferenceId()) && (map = preferenceEvent.getPreferenceMap()) != null && map.containsKey(PreferenceId.InvocationSubviewMode.RAW)) {
            Boolean bl = (Boolean)map.get(PreferenceId.InvocationSubviewMode.RAW);
            this.handleRawAggregatedColumnVisibility(bl);
            this.rawMode = bl;
        }
    }

    private void handleRawAggregatedColumnVisibility(boolean bl) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer n3;
            Column column = columnArray[n2];
            if (bl) {
                if (column.showInRawMode && !column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                    n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                    this.getMappedTableViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
                } else if (!column.showInRawMode && column.showInAggregatedMode) {
                    this.getMappedTableViewerColumn(column).getColumn().setWidth(0);
                }
            } else if (!column.showInRawMode && column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                this.getMappedTableViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
            } else if (column.showInRawMode && !column.showInAggregatedMode) {
                this.getMappedTableViewerColumn(column).getColumn().setWidth(0);
            }
            ++n2;
        }
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ExceptionSensorInvocContentProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator<AggregatedExceptionSensorData> tableViewerComparator = new TableViewerComparator<AggregatedExceptionSensorData>();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            RawAggregatedResultComparator<AggregatedExceptionSensorData> rawAggregatedResultComparator = new RawAggregatedResultComparator<AggregatedExceptionSensorData>(column.dataComparator, this.cachedDataService, column.showInRawMode, column.showInAggregatedMode){

                @Override
                protected boolean isRawMode() {
                    return ExceptionSensorInvocInputController.this.rawMode;
                }
            };
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), rawAggregatedResultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new ExceptionSensorInvocLabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        return list.get(0) instanceof InvocationSequenceData;
    }

    @Override
    public void setLimit(int n) {
    }

    public void update(IProgressMonitor iProgressMonitor) {
    }

    private StyledString getStyledTextForColumn(ExceptionSensorData exceptionSensorData, MethodIdent methodIdent, Column column) {
        if (exceptionSensorData != null) {
            switch (column) {
                case TIMESTAMP: {
                    if (this.rawMode) {
                        return new StyledString(NumberFormatter.formatTimeWithMillis(exceptionSensorData.getTimeStamp()));
                    }
                    return this.emptyStyledString;
                }
                case FQN: {
                    return new StyledString(exceptionSensorData.getThrowableType());
                }
                case CREATED: {
                    if (!this.rawMode && exceptionSensorData instanceof AggregatedExceptionSensorData) {
                        return new StyledString(NumberFormatter.formatLong(((AggregatedExceptionSensorData)exceptionSensorData).getCreated()));
                    }
                    if (ExceptionEvent.CREATED.equals((Object)exceptionSensorData.getExceptionEvent())) {
                        return new StyledString("Yes");
                    }
                    return this.emptyStyledString;
                }
                case RETHROWN: {
                    if (!this.rawMode && exceptionSensorData instanceof AggregatedExceptionSensorData) {
                        return new StyledString(NumberFormatter.formatLong(((AggregatedExceptionSensorData)exceptionSensorData).getPassed()));
                    }
                    if (ExceptionEvent.PASSED.equals((Object)exceptionSensorData.getExceptionEvent())) {
                        return new StyledString("Yes");
                    }
                    return this.emptyStyledString;
                }
                case HANDLED: {
                    if (!this.rawMode && exceptionSensorData instanceof AggregatedExceptionSensorData) {
                        return new StyledString(NumberFormatter.formatLong(((AggregatedExceptionSensorData)exceptionSensorData).getHandled()));
                    }
                    if (ExceptionEvent.HANDLED.equals((Object)exceptionSensorData.getExceptionEvent())) {
                        return new StyledString("Yes");
                    }
                    return this.emptyStyledString;
                }
                case CONSTRUCTOR: {
                    if (this.rawMode) {
                        return new StyledString(TextFormatter.getMethodWithParameters(methodIdent));
                    }
                    return this.emptyStyledString;
                }
                case ERROR_MESSAGE: {
                    if (this.rawMode) {
                        StyledString styledString = new StyledString();
                        if (exceptionSensorData.getErrorMessage() != null) {
                            styledString.append(exceptionSensorData.getErrorMessage());
                        }
                        return styledString;
                    }
                    return this.emptyStyledString;
                }
            }
            return new StyledString("error");
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        return this.exceptionSensorDataList.toArray();
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        TIMESTAMP("Timestamp", 150, "/icons/eclipse/dates.gif", false, true, (IDataComparator<? super AggregatedExceptionSensorData>)DefaultDataComparatorEnum.TIMESTAMP),
        FQN("Fully-Qualified Name", 400, "/icons/eclipse/class_obj.gif", true, true, (IDataComparator<? super AggregatedExceptionSensorData>)ExceptionSensorDataComparatorEnum.FQN),
        CREATED("Created", 60, null, true, false, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.CREATED),
        RETHROWN("Rethrown", 60, null, true, false, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.RETHROWN),
        HANDLED("Handled", 60, null, true, false, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.HANDLED),
        CONSTRUCTOR("Constructor", 250, "/icons/eclipse/methpub_obj.gif", false, true, (IDataComparator<? super AggregatedExceptionSensorData>)MethodSensorDataComparatorEnum.METHOD),
        ERROR_MESSAGE("Error Message", 250, null, false, true, (IDataComparator<? super AggregatedExceptionSensorData>)ExceptionSensorDataComparatorEnum.ERROR_MESSAGE);

        private String name;
        private int width;
        private Image image;
        private boolean showInAggregatedMode;
        private boolean showInRawMode;
        private IDataComparator<? super AggregatedExceptionSensorData> dataComparator;

        private Column(String string2, int n2, String string3, boolean bl, boolean bl2, IDataComparator<? super AggregatedExceptionSensorData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.showInAggregatedMode = bl;
            this.showInRawMode = bl2;
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class ExceptionSensorInvocContentProvider
    implements IStructuredContentProvider {
        private ExceptionSensorInvocContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            ExceptionSensorInvocInputController.this.exceptionSensorDataList = this.getRawExceptionSensorDataList(list, new ArrayList<ExceptionSensorData>());
            if (!ExceptionSensorInvocInputController.this.rawMode) {
                AggregationPerformer aggregationPerformer = new AggregationPerformer((IAggregator)new ExceptionDataAggregator(ExceptionDataAggregator.ExceptionAggregationType.THROWABLE_TYPE));
                aggregationPerformer.processCollection((Collection)ExceptionSensorInvocInputController.this.exceptionSensorDataList);
                ExceptionSensorInvocInputController.this.exceptionSensorDataList = aggregationPerformer.getResultList();
            }
            return ExceptionSensorInvocInputController.this.exceptionSensorDataList.toArray();
        }

        private List<ExceptionSensorData> getRawExceptionSensorDataList(List<InvocationSequenceData> list, List<ExceptionSensorData> list2) {
            for (InvocationSequenceData invocationSequenceData : list) {
                if (invocationSequenceData.getExceptionSensorDataObjects() != null && !invocationSequenceData.getExceptionSensorDataObjects().isEmpty()) {
                    for (ExceptionSensorData exceptionSensorData : invocationSequenceData.getExceptionSensorDataObjects()) {
                        if (!ObjectUtils.equals((Object)exceptionSensorData.getExceptionEvent(), (Object)ExceptionEvent.CREATED)) continue;
                        list2.add(exceptionSensorData);
                    }
                }
                if (invocationSequenceData.getNestedSequences() == null || invocationSequenceData.getNestedSequences().isEmpty()) continue;
                this.getRawExceptionSensorDataList(invocationSequenceData.getNestedSequences(), list2);
            }
            return list2;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class ExceptionSensorInvocLabelProvider
    extends StyledCellIndexLabelProvider {
        private ExceptionSensorInvocLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            Column column = Column.fromOrd(n);
            MethodIdent methodIdent = null;
            if (0L != exceptionSensorData.getMethodIdent()) {
                methodIdent = ExceptionSensorInvocInputController.this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            }
            return ExceptionSensorInvocInputController.this.getStyledTextForColumn(exceptionSensorData, methodIdent, column);
        }

        @Override
        public Image getColumnImage(Object object, int n) {
            if (ExceptionSensorInvocInputController.this.rawMode) {
                Column column = Column.fromOrd(n);
                switch (column) {
                    case CONSTRUCTOR: {
                        ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
                        MethodIdent methodIdent = ExceptionSensorInvocInputController.this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
                        Image image = ModifiersImageFactory.getImage(methodIdent.getModifiers());
                        image = ExceptionImageFactory.decorateImageWithException(image, exceptionSensorData, (ResourceManager)ExceptionSensorInvocInputController.this.resourceManager);
                        return image;
                    }
                }
                return null;
            }
            return null;
        }
    }
}

