/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;

public class AggregatedTimerSummaryInputController
extends AbstractTableInputController {
    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            ++n2;
        }
    }

    @Override
    public ViewerComparator getComparator() {
        return null;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        return list.get(0) instanceof TimerData;
    }

    private StyledString getStyledTextForColumn(TimerData timerData, Column column) {
        switch (column) {
            case COUNT: {
                return new StyledString(Long.toString(timerData.getCount()));
            }
            case AVERAGE: {
                return new StyledString(NumberFormatter.formatDouble(timerData.getAverage()));
            }
            case MIN: {
                return new StyledString(NumberFormatter.formatDouble(timerData.getMin()));
            }
            case MAX: {
                return new StyledString(NumberFormatter.formatDouble(timerData.getMax()));
            }
            case DURATION: {
                return new StyledString(NumberFormatter.formatDouble(timerData.getDuration()));
            }
            case EXCLUSIVEAVERAGE: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveAverage()));
                }
                return new StyledString("");
            }
            case EXCLUSIVEMAX: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMax()));
                }
                return new StyledString("");
            }
            case EXCLUSIVEMIN: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMin()));
                }
                return new StyledString("");
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(timerData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(timerData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        COUNT("Count", 100, null),
        AVERAGE("Avg (ms)", 100, null),
        MIN("Min (ms)", 100, null),
        MAX("Max (ms)", 100, null),
        DURATION("Duration (ms)", 100, null),
        EXCLUSIVEAVERAGE("Exc. Avg (ms)", 100, null),
        EXCLUSIVEMIN("Exc. Min (ms)", 100, null),
        EXCLUSIVEMAX("Exc. Max (ms)", 100, null);

        private String name;
        private int width;
        private Image image;

        private Column(String string2, int n2, String string3) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class ContentProvider
    implements IStructuredContentProvider {
        private final AggregationPerformer<TimerData> aggregationPerformer = new AggregationPerformer((IAggregator)new TimerDataAggregator());

        private ContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            this.aggregationPerformer.reset();
            this.aggregationPerformer.processCollection((Collection)list);
            return this.aggregationPerformer.getResultList().toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class LabelProvider
    extends StyledCellIndexLabelProvider {
        private LabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            TimerData timerData = (TimerData)object;
            Column column = Column.fromOrd(n);
            return AggregatedTimerSummaryInputController.this.getStyledTextForColumn(timerData, column);
        }
    }
}

