/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.search;

import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.SearchControl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class OpenedSearchControlCache {
    private static Map<ISearchExecutor, SearchControl> openedSearchControlMap = new ConcurrentHashMap<ISearchExecutor, SearchControl>();

    private OpenedSearchControlCache() {
    }

    public static boolean hasSearchControlOpened(ISearchExecutor iSearchExecutor) {
        return openedSearchControlMap.containsKey(iSearchExecutor);
    }

    public static void register(ISearchExecutor iSearchExecutor, SearchControl searchControl) {
        if (!OpenedSearchControlCache.hasSearchControlOpened(iSearchExecutor)) {
            openedSearchControlMap.put(iSearchExecutor, searchControl);
        }
    }

    public static void unregister(ISearchExecutor iSearchExecutor) {
        openedSearchControlMap.remove(iSearchExecutor);
    }

    public static SearchControl getSearchControl(ISearchExecutor iSearchExecutor) {
        return openedSearchControlMap.get(iSearchExecutor);
    }
}

