/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot.datasolver.impl;

import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.AbstractPlotDataSolver;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.data.Range;

public class PercentageDataSolver
extends AbstractPlotDataSolver {
    private static NumberFormat numberFormat = new NumberFormat(){
        private static final long serialVersionUID = 558623875022886643L;

        @Override
        public Number parse(String string, ParsePosition parsePosition) {
            return null;
        }

        @Override
        public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return null;
        }

        @Override
        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append((int)d).append("%");
        }
    };

    PercentageDataSolver() {
    }

    @Override
    public NumberAxis getAxis() {
        NumberAxis numberAxis = new NumberAxis("Percentage");
        numberAxis.setRange(new Range(0.0, 100.0), false, false);
        numberAxis.setAutoRangeMinimumSize(50.0, false);
        numberAxis.setTickUnit(new NumberTickUnit(10.0, (NumberFormat)new DecimalFormat("0")));
        numberAxis.setNumberFormatOverride(numberFormat);
        return numberAxis;
    }

    @Override
    public double valueConvert(double d) {
        return d * 100.0;
    }

    @Override
    protected String valueToHumanReadableImpl(double d) {
        return NumberFormatter.formatDoubleToPercent(d / 100.0);
    }

    @Override
    public boolean isAggregatable() {
        return true;
    }
}

