/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.AggregatedHttpTimerData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractTimerDataPlotController;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.HttpChartingInputDefinitionExtra;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.util.data.RegExAggregatedHttpTimerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.widgets.Display;

public class HttpTimerPlotController
extends AbstractTimerDataPlotController<HttpTimerData> {
    private static final IAggregator<HttpTimerData> AGGREGATOR = new SimpleHttpAggregator();
    private List<HttpTimerData> templates;
    private List<RegExAggregatedHttpTimerData> regExTemplates;
    private boolean plotByTagValue = false;
    private boolean regExTransformation = false;
    private IHttpTimerDataAccessService dataAccessService;
    List<HttpTimerData> displayedData = Collections.emptyList();
    Date toDate = new Date(0L);
    Date fromDate = new Date(Long.MAX_VALUE);
    Date latestDataDate = new Date(0L);

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.HTTP_CHARTING_EXTRAS_MARKER)) {
            HttpChartingInputDefinitionExtra httpChartingInputDefinitionExtra = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.HTTP_CHARTING_EXTRAS_MARKER);
            this.templates = httpChartingInputDefinitionExtra.getTemplates();
            this.plotByTagValue = httpChartingInputDefinitionExtra.isPlotByTagValue();
            this.regExTransformation = httpChartingInputDefinitionExtra.isRegExTransformation();
            if (this.regExTransformation) {
                this.regExTemplates = httpChartingInputDefinitionExtra.getRegExTemplates();
            }
        }
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getHttpTimerDataAccessService();
    }

    @Override
    public boolean showLegend() {
        return this.templates.size() > 1;
    }

    @Override
    public void update(Date date, Date date2) {
        Object object2;
        boolean bl;
        boolean bl2 = CollectionUtils.isEmpty(this.displayedData) || this.fromDate.after(date2) || this.toDate.before(date);
        boolean bl3 = this.fromDate.after(date);
        boolean bl4 = bl = this.toDate.before(date2) || this.latestDataDate.before(date2);
        if (bl2) {
            object2 = this.dataAccessService.getChartingHttpTimerDataFromDateToDate(this.templates, date, date2, this.plotByTagValue);
            if (CollectionUtils.isNotEmpty((Collection)object2)) {
                this.fromDate = (Date)date.clone();
                this.toDate = (Date)date2.clone();
            }
            this.displayedData = object2;
        } else {
            List list;
            List object3;
            if (bl && CollectionUtils.isNotEmpty((Collection)(object3 = this.dataAccessService.getChartingHttpTimerDataFromDateToDate(this.templates, object2 = new Date(this.latestDataDate.getTime() + 1L), date2, this.plotByTagValue)))) {
                this.displayedData.addAll(object3);
                this.toDate = (Date)date2.clone();
            }
            if (bl3 && CollectionUtils.isNotEmpty((Collection)(list = this.dataAccessService.getChartingHttpTimerDataFromDateToDate(this.templates, date, object2 = new Date(this.fromDate.getTime() - 1L), this.plotByTagValue)))) {
                this.displayedData.addAll(0, list);
                this.fromDate = (Date)date.clone();
            }
        }
        if (CollectionUtils.isNotEmpty(this.displayedData)) {
            this.latestDataDate = new Date(this.displayedData.get(this.displayedData.size() - 1).getTimeStamp().getTime());
        }
        object2 = new HashMap();
        for (HttpTimerData httpTimerData : this.displayedData) {
            HttpTimerData httpTimerData2 = this.findTemplateForData(httpTimerData);
            if (httpTimerData2 == null) continue;
            Comparable<?> comparable = this.getSeriesKey(httpTimerData2);
            ArrayList<HttpTimerData> arrayList = (ArrayList<HttpTimerData>)object2.get(comparable);
            if (arrayList == null) {
                arrayList = new ArrayList<HttpTimerData>();
                object2.put(comparable, arrayList);
            }
            arrayList.add(httpTimerData);
        }
        for (Map.Entry entry : object2.entrySet()) {
            entry.setValue(this.adjustSamplingRate((List)entry.getValue(), date, date2, AGGREGATOR));
        }
        Cloneable cloneable = object2;
        Display.getDefault().asyncExec(new Runnable((Map)((Object)cloneable)){
            private final /* synthetic */ Map val$finalMap;
            {
                this.val$finalMap = map;
            }

            @Override
            public void run() {
                HttpTimerPlotController.this.setDurationPlotData(this.val$finalMap);
                HttpTimerPlotController.this.setCountPlotData(this.val$finalMap);
            }
        });
    }

    private HttpTimerData findTemplateForData(HttpTimerData httpTimerData) {
        if (this.regExTransformation) {
            for (RegExAggregatedHttpTimerData regExAggregatedHttpTimerData : this.regExTemplates) {
                if (!"MULTIPLE".equals(regExAggregatedHttpTimerData.getHttpInfo().getRequestMethod()) && !Objects.equals(regExAggregatedHttpTimerData.getHttpInfo().getRequestMethod(), httpTimerData.getHttpInfo().getRequestMethod()) || this.findTemplateForUriData(httpTimerData, regExAggregatedHttpTimerData.getAggregatedDataList(), true) == null) continue;
                return regExAggregatedHttpTimerData;
            }
        } else {
            if (this.plotByTagValue) {
                return this.findTemplateForTagData(httpTimerData, this.templates);
            }
            return this.findTemplateForUriData(httpTimerData, this.templates, false);
        }
        return null;
    }

    private HttpTimerData findTemplateForUriData(HttpTimerData httpTimerData, List<HttpTimerData> list, boolean bl) {
        for (HttpTimerData httpTimerData2 : list) {
            if (!Objects.equals(httpTimerData2.getHttpInfo().getUri(), httpTimerData.getHttpInfo().getUri())) continue;
            if (!bl && "MULTIPLE".equals(httpTimerData2.getHttpInfo().getRequestMethod())) {
                return httpTimerData2;
            }
            if (!Objects.equals(httpTimerData2.getHttpInfo().getRequestMethod(), httpTimerData.getHttpInfo().getRequestMethod())) continue;
            return httpTimerData2;
        }
        return null;
    }

    private HttpTimerData findTemplateForTagData(HttpTimerData httpTimerData, List<HttpTimerData> list) {
        for (HttpTimerData httpTimerData2 : list) {
            if (!Objects.equals(httpTimerData2.getHttpInfo().getInspectItTaggingHeaderValue(), httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue()) || !"MULTIPLE".equals(httpTimerData2.getHttpInfo().getRequestMethod()) && !Objects.equals(httpTimerData2.getHttpInfo().getRequestMethod(), httpTimerData.getHttpInfo().getRequestMethod())) continue;
            return httpTimerData2;
        }
        return null;
    }

    @Override
    protected Comparable<?> getSeriesKey(HttpTimerData httpTimerData) {
        if (this.regExTransformation && httpTimerData instanceof RegExAggregatedHttpTimerData) {
            return "Transformed URI: " + ((RegExAggregatedHttpTimerData)httpTimerData).getTransformedUri() + " [" + httpTimerData.getHttpInfo().getRequestMethod() + "]";
        }
        if (this.plotByTagValue) {
            return "Tag: " + httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue() + " [" + httpTimerData.getHttpInfo().getRequestMethod() + "]";
        }
        return "URI: " + httpTimerData.getHttpInfo().getUri() + " [" + httpTimerData.getHttpInfo().getRequestMethod() + "]";
    }

    @Override
    protected List<HttpTimerData> getTemplates() {
        if (this.regExTransformation) {
            return new ArrayList<RegExAggregatedHttpTimerData>(this.regExTemplates);
        }
        return this.templates;
    }

    private static class SimpleHttpAggregator
    implements IAggregator<HttpTimerData> {
        private SimpleHttpAggregator() {
        }

        public void aggregate(IAggregatedData<HttpTimerData> iAggregatedData, HttpTimerData httpTimerData) {
            iAggregatedData.aggregate((DefaultData)httpTimerData);
        }

        public IAggregatedData<HttpTimerData> getClone(HttpTimerData httpTimerData) {
            return new AggregatedHttpTimerData();
        }

        public Object getAggregationKey(HttpTimerData httpTimerData) {
            return 1;
        }
    }
}

