/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.PlotController;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.preferences.control.SamplingRateControl;
import info.novatec.inspectit.rcp.editor.preferences.control.SamplingRateSelecterFactory;
import info.novatec.inspectit.rcp.editor.preferences.control.samplingrate.SamplingRateMode;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractPlotController
implements PlotController {
    private InputDefinition inputDefinition;
    private IRootEditor rootEditor;
    private SamplingRateControl.Sensitivity sensitivity = SamplingRateControl.DEFAULT_SENSITIVITY;
    private SamplingRateMode samplingRateMode = SamplingRateMode.TIMEFRAME_DIVIDER;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        Assert.isNotNull((Object)inputDefinition);
        this.inputDefinition = inputDefinition;
    }

    protected InputDefinition getInputDefinition() {
        Assert.isNotNull((Object)this.inputDefinition);
        return this.inputDefinition;
    }

    @Override
    public void setRootEditor(IRootEditor iRootEditor) {
        Assert.isNotNull((Object)iRootEditor);
        this.rootEditor = iRootEditor;
    }

    protected IRootEditor getRootEditor() {
        Assert.isNotNull((Object)this.rootEditor);
        return this.rootEditor;
    }

    protected <E extends DefaultData> List<E> adjustSamplingRate(List<E> list, Date date, Date date2, IAggregator<E> iAggregator) {
        return this.samplingRateMode.adjustSamplingRate(list, date, date2, this.sensitivity.getValue(), iAggregator);
    }

    @Override
    public void setSamplingRate(SamplingRateMode samplingRateMode, SamplingRateControl.Sensitivity sensitivity) {
        this.samplingRateMode = samplingRateMode;
        this.sensitivity = sensitivity;
    }

    protected SamplingRateMode getSamplingRateMode() {
        return this.samplingRateMode;
    }

    protected SamplingRateControl.Sensitivity getSensitivity() {
        return this.sensitivity;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        if (PreferenceId.SAMPLINGRATE.equals((Object)preferenceEvent.getPreferenceId())) {
            Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
            if (map.containsKey(PreferenceId.SamplingRate.DIVIDER_ID)) {
                PreferenceId.SamplingRate samplingRate = (PreferenceId.SamplingRate)map.get(PreferenceId.SamplingRate.DIVIDER_ID);
                this.samplingRateMode = SamplingRateSelecterFactory.selectSamplingRateMode(samplingRate);
            }
            if (map.containsKey(PreferenceId.SamplingRate.SLIDER_ID)) {
                this.sensitivity = (SamplingRateControl.Sensitivity)((Object)map.get(PreferenceId.SamplingRate.SLIDER_ID));
            }
        }
    }

    @Override
    public boolean showLegend() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

