/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.AbstractSubView;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.graph.PlotFactory;
import info.novatec.inspectit.rcp.editor.graph.plot.DateAxisZoomNotify;
import info.novatec.inspectit.rcp.editor.graph.plot.PlotController;
import info.novatec.inspectit.rcp.editor.graph.plot.ZoomListener;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.DataTimeFrameLabelType;
import info.novatec.inspectit.util.TimeFrame;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.experimental.chart.swt.ChartComposite;

public class GraphSubView
extends AbstractSubView {
    private Composite composite;
    private JFreeChart chart;
    private PlotController plotController;
    private boolean autoUpdate = false;
    private static final long ONE_MINUTE = 60000L;
    private static final long TEN_MINUTES = 600000L;
    private ZoomListener zoomListener;
    private volatile boolean jobInSchedule = false;

    public GraphSubView(String string) {
        this.plotController = PlotFactory.createDefaultPlotController(string);
    }

    public GraphSubView(SensorTypeEnum sensorTypeEnum) {
        this.plotController = PlotFactory.createDefaultPlotController(sensorTypeEnum);
    }

    @Override
    public void init() {
        this.plotController.setInputDefinition(this.getRootEditor().getInputDefinition());
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.plotController.setRootEditor(this.getRootEditor());
        this.composite = formToolkit.createComposite(composite);
        this.composite.setLayout((Layout)new FillLayout());
        this.chart = this.createChart();
        if (!this.plotController.showLegend()) {
            this.chart.removeLegend();
        }
        Color color = new Color(formToolkit.getColors().getBackground().getRed(), formToolkit.getColors().getBackground().getGreen(), formToolkit.getColors().getBackground().getBlue());
        this.chart.setBackgroundPaint((Paint)color);
        new ChartComposite(this.composite, 0, this.chart, 680, 420, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true, true, true, true){

            public boolean print(GC gC) {
                GraphSubView.this.chart.setTitle(GraphSubView.this.getRootEditor().getTitle());
                boolean bl = super.print(gC);
                GraphSubView.this.chart.setTitle("");
                return bl;
            }
        };
    }

    private JFreeChart createChart() {
        XYPlot xYPlot2;
        DateAxisZoomNotify dateAxisZoomNotify = new DateAxisZoomNotify();
        dateAxisZoomNotify.setLowerMargin(0.0);
        dateAxisZoomNotify.setAutoRangeMinimumSize(100000.0);
        long l = System.currentTimeMillis();
        dateAxisZoomNotify.setRange(new Range((double)(l - 600000L), (double)(l + 60000L)), true, false);
        TickUnits tickUnits = new TickUnits();
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 1, DateFormat.getTimeInstance(3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 5, DateFormat.getTimeInstance(3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 30, DateFormat.getTimeInstance(3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 1, DateFormat.getDateTimeInstance(3, 3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 3, DateFormat.getDateTimeInstance(3, 3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 1, DateFormat.getDateInstance(3)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 7, DateFormat.getDateInstance(2)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 1, DateFormat.getDateInstance(2)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 1, DateFormat.getDateInstance(2)));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 10, DateFormat.getDateInstance(2)));
        dateAxisZoomNotify.setStandardTickUnits((TickUnitSource)tickUnits);
        dateAxisZoomNotify.setAutoTickUnitSelection(true);
        this.addZoomListener(dateAxisZoomNotify);
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot((ValueAxis)dateAxisZoomNotify);
        combinedDomainXYPlot.setGap(10.0);
        List<XYPlot> list = this.plotController.getPlots();
        for (XYPlot xYPlot2 : list) {
            combinedDomainXYPlot.add(xYPlot2, this.plotController.getWeight(xYPlot2));
        }
        combinedDomainXYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot2 = this.getInitialDataTimeFrame();
        if (xYPlot2 != null) {
            ((DateAxis)combinedDomainXYPlot.getDomainAxis()).setMinimumDate(xYPlot2.getFrom());
            ((DateAxis)combinedDomainXYPlot.getDomainAxis()).setMaximumDate(xYPlot2.getTo());
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.TIMELINE);
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.TimeLine.FROM_DATE_ID, xYPlot2.getFrom());
            hashMap.put(PreferenceId.TimeLine.TO_DATE_ID, xYPlot2.getTo());
            preferenceEvent.setPreferenceMap(hashMap);
            this.getRootEditor().getPreferencePanel().fireEvent(preferenceEvent);
        }
        return new JFreeChart((Plot)combinedDomainXYPlot);
    }

    private void addZoomListener(DateAxisZoomNotify dateAxisZoomNotify) {
        if (this.zoomListener == null) {
            this.zoomListener = new ZoomListener(){

                @Override
                public void zoomOccured() {
                    if (GraphSubView.this.autoUpdate) {
                        GraphSubView.this.autoUpdate = false;
                        GraphSubView.this.getRootEditor().getPreferencePanel().disableLiveMode();
                    }
                    GraphSubView.this.doRefresh();
                }
            };
        }
        dateAxisZoomNotify.addZoomListener(this.zoomListener);
    }

    private TimeFrame getInitialDataTimeFrame() {
        StorageRepositoryDefinition storageRepositoryDefinition;
        List list;
        RepositoryDefinition repositoryDefinition = this.getRootEditor().getInputDefinition().getRepositoryDefinition();
        if (repositoryDefinition instanceof StorageRepositoryDefinition && CollectionUtils.isNotEmpty((Collection)(list = (storageRepositoryDefinition = (StorageRepositoryDefinition)repositoryDefinition).getLocalStorageData().getLabels((AbstractStorageLabelType)new DataTimeFrameLabelType())))) {
            return (TimeFrame)((AbstractStorageLabel)list.get(0)).getValue();
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        return this.plotController.getPreferenceIds();
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        Object object;
        if (PreferenceId.TIMELINE.equals((Object)preferenceEvent.getPreferenceId())) {
            Date date;
            object = (XYPlot)this.chart.getPlot();
            DateAxis dateAxis = (DateAxis)object.getDomainAxis();
            Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
            if (map.containsKey(PreferenceId.TimeLine.TO_DATE_ID)) {
                date = (Date)map.get(PreferenceId.TimeLine.TO_DATE_ID);
                dateAxis.setMaximumDate(date);
            }
            if (map.containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                date = (Date)map.get(PreferenceId.TimeLine.FROM_DATE_ID);
                dateAxis.setMinimumDate(date);
            }
            this.doRefresh();
        }
        if (PreferenceId.LIVEMODE.equals((Object)preferenceEvent.getPreferenceId()) && (object = preferenceEvent.getPreferenceMap()).containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) {
            this.autoUpdate = (Boolean)object.get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
            if (this.autoUpdate) {
                this.doRefresh();
            }
        }
        this.plotController.preferenceEventFired(preferenceEvent);
    }

    @Override
    public void doRefresh() {
        if (this.checkDisposed()) {
            return;
        }
        if (!this.jobInSchedule) {
            Date date;
            this.jobInSchedule = true;
            XYPlot xYPlot = (XYPlot)this.chart.getPlot();
            DateAxis dateAxis = (DateAxis)xYPlot.getDomainAxis();
            final Date date2 = dateAxis.getMinimumDate();
            Date date3 = date = this.autoUpdate ? new Date(System.currentTimeMillis()) : dateAxis.getMaximumDate();
            if (this.autoUpdate) {
                dateAxis.setMaximumDate(date);
            }
            Job job = new Job(this.getDataLoadingJobName()){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        GraphSubView.this.plotController.update(date2, date);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("Unknown exception occurred trying to refresh the view.", throwable);
                    }
                    finally {
                        GraphSubView.this.jobInSchedule = false;
                    }
                }
            };
            job.schedule();
        }
    }

    @Override
    public ISubView getSubViewWithInputController(Class<?> clazz) {
        if (Objects.equals(clazz, this.plotController.getClass())) {
            return this;
        }
        return null;
    }

    private boolean checkDisposed() {
        return this.composite.isDisposed();
    }

    @Override
    public void dispose() {
        this.plotController.dispose();
    }
}

