/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.composite;

import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.composite.AbstractCompositeSubView;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SashCompositeSubView
extends AbstractCompositeSubView {
    private int sashFormStyle = 66048;
    private SashForm sashForm;
    private Map<ISubView, Integer> weightMapping = new HashMap<ISubView, Integer>();

    public SashCompositeSubView() {
    }

    public SashCompositeSubView(int n) {
        this.sashFormStyle = n;
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.sashForm = new SashForm(composite, this.sashFormStyle);
        this.sashForm.setLayout((Layout)new GridLayout(1, false));
        List<ISubView> list = this.getSubViews();
        for (final ISubView object : list) {
            object.createPartControl((Composite)this.sashForm, formToolkit);
            object.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            object.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    SashCompositeSubView.this.getRootEditor().setActiveSubView(object);
                }
            });
            if (object.getSelectionProvider() == null) continue;
            ISelectionProvider iSelectionProvider = object.getSelectionProvider();
            iSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    SashCompositeSubView.this.getRootEditor().setSelection(selectionChangedEvent.getSelection());
                }
            });
            iSelectionProvider.addSelectionChangedListener(this.getRootEditor().getSelectionChangedListener());
            if (!(iSelectionProvider instanceof IPostSelectionProvider)) continue;
            ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.getRootEditor().getPostSelectionChangedListener());
        }
        if (!this.weightMapping.isEmpty()) {
            int[] nArray = new int[list.size()];
            int n = 0;
            while (n < list.size()) {
                if (this.weightMapping.containsKey(list.get(n))) {
                    nArray[n] = this.weightMapping.get(list.get(n));
                }
                ++n;
            }
            this.sashForm.setWeights(nArray);
        }
    }

    public void addSubView(ISubView iSubView, int n) {
        super.addSubView(iSubView);
        this.weightMapping.put(iSubView, n);
    }

    @Override
    public Control getControl() {
        return this.sashForm;
    }

    @Override
    public void maximizeSubView(ISubView iSubView) {
        ISubView iSubView2 = iSubView;
        if (iSubView2 == null) {
            iSubView2 = this.getSubViews().get(0);
        }
        int[] nArray = new int[this.getSubViews().size()];
        int n = 0;
        for (ISubView iSubView3 : this.getSubViews()) {
            if (ObjectUtils.equals((Object)iSubView3, (Object)iSubView2)) {
                iSubView3.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
                nArray[n] = 1;
            } else {
                GridData gridData = new GridData();
                gridData.exclude = true;
                iSubView3.getControl().setLayoutData((Object)gridData);
                nArray[n] = 0;
            }
            ++n;
        }
        this.sashForm.setWeights(nArray);
        this.layout();
    }

    @Override
    public void restoreMaximization() {
        int[] nArray = new int[this.getSubViews().size()];
        int n = 0;
        for (ISubView iSubView : this.getSubViews()) {
            iSubView.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            nArray[n] = this.weightMapping.get(iSubView);
            ++n;
        }
        this.sashForm.setWeights(nArray);
        this.layout();
    }

    @Override
    public void layout() {
        this.sashForm.layout();
    }
}

