/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.view;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.job.OpenEnvironmentJob;
import info.novatec.inspectit.rcp.ci.job.OpenProfileJob;
import info.novatec.inspectit.rcp.ci.listener.IEnvironmentChangeListener;
import info.novatec.inspectit.rcp.ci.listener.IProfileChangeListener;
import info.novatec.inspectit.rcp.ci.view.EnvironmentLabelProvider;
import info.novatec.inspectit.rcp.ci.view.ProfileLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.ci.EnvironmentLeaf;
import info.novatec.inspectit.rcp.model.ci.ProfileLeaf;
import info.novatec.inspectit.rcp.provider.IEnvironmentProvider;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.util.SelectionProviderAdapter;
import info.novatec.inspectit.rcp.util.UnfinishedWarningUtils;
import info.novatec.inspectit.rcp.view.IRefreshableView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class ConfigurationInterfaceManagerView
extends ViewPart
implements IRefreshableView,
CmrRepositoryChangeListener,
IProfileChangeListener,
IEnvironmentChangeListener {
    public static final String VIEW_ID = "info.novatec.inspectit.rcp.ci.view.ciManager";
    private static final String MENU_ID = "info.novatec.inspectit.rcp.view.configurationInterfaceManager.table";
    protected CmrRepositoryManager cmrRepositoryManager;
    protected CmrRepositoryDefinition displayedCmrRepositoryDefinition;
    private Map<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> cachedOnlineStatus = new ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus>();
    private List<IProfileProvider> profileLeafs = new ArrayList<IProfileProvider>(0);
    private List<IEnvironmentProvider> environmentLeafs = new ArrayList<IEnvironmentProvider>(0);
    protected FormToolkit toolkit;
    protected SashForm mainComposite;
    protected Form mainForm;
    protected TableViewer tableViewer;
    protected Composite messageComposite;
    private SelectionProviderAdapter selectionProviderAdapter = new SelectionProviderAdapter();
    private Button environmentSelection;
    private Button profileSelection;

    public ConfigurationInterfaceManagerView() {
        this.cmrRepositoryManager = InspectIT.getDefault().getCmrRepositoryManager();
        this.cmrRepositoryManager.addCmrRepositoryChangeListener(this);
        this.selectDisplayedCmrRepositoryDefinition();
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addProfileChangeListener(this);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addEnvironmentChangeListener(this);
    }

    public void createPartControl(Composite composite) {
        String string;
        this.createViewToolbar();
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.mainComposite = new SashForm(composite, 512);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainForm = this.toolkit.createForm((Composite)this.mainComposite);
        this.mainForm.getBody().setLayout((Layout)new GridLayout(1, true));
        this.mainForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeadClient();
        this.toolkit.decorateFormHeading(this.mainForm);
        int n = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        Table table = this.toolkit.createTable(this.mainForm.getBody(), 768);
        this.toolkit.setBorderStyle(n);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider(this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        ViewerComparator viewerComparator = this.getViewerComparator();
        if (viewerComparator != null) {
            this.tableViewer.setComparator(viewerComparator);
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        IDoubleClickListener iDoubleClickListener = this.getTreeDoubleClickListener();
        if (iDoubleClickListener != null) {
            this.tableViewer.addDoubleClickListener(iDoubleClickListener);
        }
        if ((string = this.getMenuId()) != null) {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            this.getSite().registerContextMenu(string, menuManager, (ISelectionProvider)this.tableViewer);
            Control control = this.tableViewer.getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
        }
        this.mainComposite.addControlListener((ControlListener)new ControlAdapter(){
            private boolean verticaLayout;

            public void controlResized(ControlEvent controlEvent) {
                int n = ConfigurationInterfaceManagerView.this.mainComposite.getBounds().width;
                int n2 = ConfigurationInterfaceManagerView.this.mainComposite.getBounds().height;
                if (n > n2 && this.verticaLayout) {
                    this.verticaLayout = false;
                    ConfigurationInterfaceManagerView.this.mainComposite.setOrientation(256);
                } else if (n < n2 && !this.verticaLayout) {
                    this.verticaLayout = true;
                    ConfigurationInterfaceManagerView.this.mainComposite.setOrientation(512);
                }
                ConfigurationInterfaceManagerView.this.mainComposite.layout();
            }
        });
        this.updateFormTitle();
        this.updateFormMenuManager();
        this.updateFormBody();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)ConfigurationInterfaceManagerView.this.tableViewer.getSelection();
                if (structuredSelection.getFirstElement() instanceof IProfileProvider || structuredSelection.getFirstElement() instanceof IEnvironmentProvider) {
                    ConfigurationInterfaceManagerView.this.selectionProviderAdapter.setSelection((ISelection)structuredSelection);
                } else {
                    ConfigurationInterfaceManagerView.this.selectionProviderAdapter.setSelection((ISelection)new StructuredSelection((Object)ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition));
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProviderAdapter);
        this.selectionProviderAdapter.setSelection((ISelection)new StructuredSelection((Object)this.displayedCmrRepositoryDefinition));
        UnfinishedWarningUtils.inform("The configuration interface is not yet connected with the agent instrumentation. You can play around with this preview, but the instrumentations will not be effective.", "UNFINISHED_WARNING_CONFIGURATION_INTERFACE");
    }

    protected void createViewToolbar() {
    }

    protected void createHeadClient() {
        Composite composite = new Composite(this.mainForm.getHead(), 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Show:");
        this.environmentSelection = new Button(composite, 16);
        this.environmentSelection.setText("Environments");
        this.environmentSelection.setSelection(true);
        this.profileSelection = new Button(composite, 16);
        this.profileSelection.setText("Profiles");
        this.environmentSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationInterfaceManagerView.this.performUpdate(false);
            }
        });
        this.mainForm.setHeadClient((Control)composite);
    }

    private void createTableColumns() {
        TableViewerColumn tableViewerColumn;
        if (this.isShowEnvironments()) {
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Environment");
            tableViewerColumn.getColumn().setWidth(150);
            tableViewerColumn.getColumn().setToolTipText("Environment name.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Profiles");
            tableViewerColumn.getColumn().setWidth(80);
            tableViewerColumn.getColumn().setToolTipText("Number of linked profiles in the Environment.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Description");
            tableViewerColumn.getColumn().setWidth(150);
            tableViewerColumn.getColumn().setToolTipText("Environment description.");
        } else if (this.isShowProfiles()) {
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Profile");
            tableViewerColumn.getColumn().setWidth(150);
            tableViewerColumn.getColumn().setToolTipText("Profile name.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Updated");
            tableViewerColumn.getColumn().setWidth(80);
            tableViewerColumn.getColumn().setToolTipText("The date and time when the profile was last time updated.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Active");
            tableViewerColumn.getColumn().setWidth(55);
            tableViewerColumn.getColumn().setToolTipText("If profile is active or not, note that deactivated profile will not be considered during the instrumentation even if it's a part of an Environment.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Default");
            tableViewerColumn.getColumn().setWidth(55);
            tableViewerColumn.getColumn().setToolTipText("If profile is default or not, note that default profile will be added to any new created Environment.");
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText("Description");
            tableViewerColumn.getColumn().setWidth(150);
            tableViewerColumn.getColumn().setToolTipText("Profile description.");
        }
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        tableViewerColumn = this.getViewerComparator();
        if (tableViewerColumn != null) {
            this.tableViewer.setComparator(this.getViewerComparator());
        }
    }

    protected IBaseLabelProvider getLabelProvider() {
        if (this.isShowEnvironments()) {
            return new EnvironmentLabelProvider();
        }
        if (this.isShowProfiles()) {
            return new ProfileLabelProvider();
        }
        return null;
    }

    protected IDoubleClickListener getTreeDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (!iSelection.isEmpty()) {
                    Object object = ((StructuredSelection)iSelection).getFirstElement();
                    if (object instanceof IProfileProvider) {
                        IProfileProvider iProfileProvider = (IProfileProvider)object;
                        new OpenProfileJob(iProfileProvider.getCmrRepositoryDefinition(), iProfileProvider.getProfile().getId(), ConfigurationInterfaceManagerView.this.getSite().getPage()).schedule();
                    } else if (object instanceof IEnvironmentProvider) {
                        IEnvironmentProvider iEnvironmentProvider = (IEnvironmentProvider)object;
                        new OpenEnvironmentJob(iEnvironmentProvider.getCmrRepositoryDefinition(), iEnvironmentProvider.getEnvironment().getId(), ConfigurationInterfaceManagerView.this.getSite().getPage()).schedule();
                    }
                }
            }
        };
    }

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof Comparable && object2 instanceof Comparable) {
                    return ((Comparable)object).compareTo(object2);
                }
                return 0;
            }
        };
    }

    protected void updateFormMenuManager() {
        IMenuManager iMenuManager = this.mainForm.getMenuManager();
        iMenuManager.removeAll();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryManager.getCmrRepositoryDefinitions()) {
            if (Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) continue;
            iMenuManager.add((IAction)new SelectCmrAction(cmrRepositoryDefinition));
        }
        iMenuManager.update(true);
        this.mainForm.getHead().layout();
    }

    protected void updateFormTitle() {
        if (this.displayedCmrRepositoryDefinition != null) {
            this.mainForm.setImage(ImageFormatter.getCmrRepositoryImage(this.displayedCmrRepositoryDefinition, true));
            this.mainForm.setText(this.displayedCmrRepositoryDefinition.getName());
            this.mainForm.setToolTipText(TextFormatter.getCmrRepositoryDescription(this.displayedCmrRepositoryDefinition));
            this.mainForm.setMessage(null);
        } else {
            this.mainForm.setImage(null);
            this.mainForm.setText("No repository exists");
            this.mainForm.setMessage("Repositories can be added from the Repository Manager", 2);
            this.mainForm.setToolTipText(null);
        }
    }

    protected void updateFormBody() {
        this.clearFormBody();
        if (this.displayedCmrRepositoryDefinition == null) {
            this.displayMessage("No CMR repository present. Please add the CMR repository via 'Add CMR repository' action.", Display.getDefault().getSystemImage(2));
        } else if (this.displayedCmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            this.displayMessage("Selected CMR repository is currently unavailable.", Display.getDefault().getSystemImage(8));
        } else if (this.isShowEnvironments()) {
            List<IEnvironmentProvider> list = this.environmentLeafs;
            if (CollectionUtils.isEmpty(list)) {
                this.displayMessage("No environment exists on selected CMR repository.", Display.getDefault().getSystemImage(2));
            } else {
                this.createTableColumns();
                this.tableViewer.getTable().setHeaderVisible(true);
                this.tableViewer.getTable().setLinesVisible(true);
                this.tableViewer.getTable().setVisible(true);
                this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                this.tableViewer.setInput(list);
            }
        } else if (this.isShowProfiles()) {
            List<IProfileProvider> list = this.profileLeafs;
            if (CollectionUtils.isEmpty(list)) {
                this.displayMessage("No profile exists on selected CMR repository.", Display.getDefault().getSystemImage(2));
            } else {
                this.createTableColumns();
                this.tableViewer.getTable().setHeaderVisible(true);
                this.tableViewer.getTable().setLinesVisible(true);
                this.tableViewer.getTable().setVisible(true);
                this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                this.tableViewer.setInput(list);
            }
        }
        this.mainForm.getBody().layout();
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (Objects.equals(this.displayedCmrRepositoryDefinition, cmrRepositoryDefinition)) {
            CmrRepositoryDefinition.OnlineStatus onlineStatus3 = this.cachedOnlineStatus.get(cmrRepositoryDefinition);
            if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                if (onlineStatus3 == null || CmrRepositoryDefinition.OnlineStatus.OFFLINE.equals((Object)onlineStatus3) || CmrRepositoryDefinition.OnlineStatus.UNKNOWN.equals((Object)onlineStatus3)) {
                    this.performUpdate(true);
                }
                this.cachedOnlineStatus.put(cmrRepositoryDefinition, onlineStatus2);
            } else if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                if (onlineStatus3 == null || CmrRepositoryDefinition.OnlineStatus.ONLINE.equals((Object)onlineStatus3)) {
                    this.performUpdate(true);
                }
                this.cachedOnlineStatus.put(cmrRepositoryDefinition, onlineStatus2);
            }
        }
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cachedOnlineStatus.put(cmrRepositoryDefinition, cmrRepositoryDefinition.getOnlineStatus());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfigurationInterfaceManagerView.this.updateFormMenuManager();
            }
        });
    }

    @Override
    public void repositoryRemoved(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cachedOnlineStatus.remove(cmrRepositoryDefinition);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfigurationInterfaceManagerView.this.updateFormMenuManager();
                if (Objects.equals(ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition, cmrRepositoryDefinition)) {
                    ConfigurationInterfaceManagerView.this.selectDisplayedCmrRepositoryDefinition();
                }
            }
        });
    }

    @Override
    public void repositoryDataUpdated(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfigurationInterfaceManagerView.this.updateFormMenuManager();
                if (Objects.equals(ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition, cmrRepositoryDefinition)) {
                    ConfigurationInterfaceManagerView.this.updateFormTitle();
                }
            }
        });
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
    }

    @Override
    public void profileCreated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        ProfileLeaf profileLeaf = new ProfileLeaf(profile, cmrRepositoryDefinition);
        this.profileLeafs.add(profileLeaf);
        this.showProfiles(false);
    }

    @Override
    public void profileUpdated(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        Iterator<IProfileProvider> iterator = this.profileLeafs.iterator();
        while (iterator.hasNext()) {
            IProfileProvider iProfileProvider = iterator.next();
            if (!Objects.equals(profile.getId(), iProfileProvider.getProfile().getId())) continue;
            iterator.remove();
            this.profileLeafs.add(new ProfileLeaf(profile, iProfileProvider.getCmrRepositoryDefinition()));
            this.performUpdate(false);
            break;
        }
    }

    @Override
    public void profileDeleted(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        Iterator<IProfileProvider> iterator = this.profileLeafs.iterator();
        while (iterator.hasNext()) {
            IProfileProvider iProfileProvider = iterator.next();
            if (!Objects.equals(profile.getId(), iProfileProvider.getProfile().getId())) continue;
            iterator.remove();
            this.performUpdate(false);
            break;
        }
    }

    @Override
    public void environmentCreated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        EnvironmentLeaf environmentLeaf = new EnvironmentLeaf(environment, cmrRepositoryDefinition);
        this.environmentLeafs.add(environmentLeaf);
        this.showEnvironments(false);
    }

    @Override
    public void environmentUpdated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        Iterator<IEnvironmentProvider> iterator = this.environmentLeafs.iterator();
        while (iterator.hasNext()) {
            IEnvironmentProvider iEnvironmentProvider = iterator.next();
            if (!Objects.equals(environment.getId(), iEnvironmentProvider.getEnvironment().getId())) continue;
            iterator.remove();
            this.environmentLeafs.add(new EnvironmentLeaf(environment, cmrRepositoryDefinition));
            this.performUpdate(false);
            break;
        }
    }

    @Override
    public void environmentDeleted(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.displayedCmrRepositoryDefinition)) {
            return;
        }
        Iterator<IEnvironmentProvider> iterator = this.environmentLeafs.iterator();
        while (iterator.hasNext()) {
            IEnvironmentProvider iEnvironmentProvider = iterator.next();
            if (!Objects.equals(environment.getId(), iEnvironmentProvider.getEnvironment().getId())) continue;
            iterator.remove();
            this.performUpdate(false);
            break;
        }
    }

    protected void clearFormBody() {
        if (this.messageComposite != null && !this.messageComposite.isDisposed()) {
            this.messageComposite.dispose();
        }
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        this.tableViewer.setInput(Collections.emptyList());
        this.tableViewer.getTable().setHeaderVisible(false);
        this.tableViewer.getTable().setLinesVisible(false);
        this.tableViewer.getTable().setVisible(false);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(16384, 128, false, false));
    }

    protected void displayMessage(String string, Image image) {
        this.clearFormBody();
        if (this.messageComposite == null || this.messageComposite.isDisposed()) {
            this.messageComposite = this.toolkit.createComposite(this.mainForm.getBody());
        } else {
            Control[] controlArray = this.messageComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
        }
        this.messageComposite.setLayout((Layout)new GridLayout(2, false));
        this.messageComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolkit.createLabel(this.messageComposite, null).setImage(image);
        this.toolkit.createLabel(this.messageComposite, string, 64).setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.mainForm.getBody().layout();
    }

    private void selectDisplayedCmrRepositoryDefinition() {
        List<CmrRepositoryDefinition> list = this.cmrRepositoryManager.getCmrRepositoryDefinitions();
        if (CollectionUtils.isNotEmpty(list)) {
            for (CmrRepositoryDefinition cmrRepositoryDefinition : list) {
                if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.ONLINE) continue;
                this.displayedCmrRepositoryDefinition = cmrRepositoryDefinition;
                this.performUpdate(true);
                this.selectionProviderAdapter.setSelection((ISelection)new StructuredSelection((Object)this.displayedCmrRepositoryDefinition));
                return;
            }
            this.displayedCmrRepositoryDefinition = list.get(0);
            this.performUpdate(true);
            this.selectionProviderAdapter.setSelection((ISelection)new StructuredSelection((Object)this.displayedCmrRepositoryDefinition));
        }
    }

    public void ciRepositoryDefinitionChange(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.displayedCmrRepositoryDefinition = cmrRepositoryDefinition;
        this.performUpdate(true);
        this.selectionProviderAdapter.setSelection((ISelection)new StructuredSelection((Object)this.displayedCmrRepositoryDefinition));
    }

    private void performUpdate(boolean bl) {
        if (bl) {
            this.updateProfilesAndEnvironments((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ConfigurationInterfaceManagerView.this.mainForm.setBusy(true);
                            ConfigurationInterfaceManagerView.this.updateFormTitle();
                            ConfigurationInterfaceManagerView.this.updateFormMenuManager();
                            ConfigurationInterfaceManagerView.this.updateFormBody();
                            (this).ConfigurationInterfaceManagerView.this.mainForm.setBusy(false);
                            (this).ConfigurationInterfaceManagerView.this.mainForm.layout();
                        }
                    });
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConfigurationInterfaceManagerView.this.mainForm.setBusy(true);
                    ConfigurationInterfaceManagerView.this.updateFormTitle();
                    ConfigurationInterfaceManagerView.this.updateFormMenuManager();
                    ConfigurationInterfaceManagerView.this.updateFormBody();
                    ConfigurationInterfaceManagerView.this.mainForm.setBusy(false);
                    ConfigurationInterfaceManagerView.this.mainForm.layout();
                }
            });
        }
    }

    private void updateProfilesAndEnvironments(IJobChangeListener iJobChangeListener) {
        Job job = new Job("Update data"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                ConfigurationInterfaceManagerView.this.profileLeafs.clear();
                ConfigurationInterfaceManagerView.this.environmentLeafs.clear();
                if (ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                    Object object2;
                    ConfigurationInterfaceManagerView.this.profileLeafs = new ArrayList();
                    ConfigurationInterfaceManagerView.this.environmentLeafs = new ArrayList();
                    List list = ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition.getConfigurationInterfaceService().getAllProfiles();
                    for (Object object2 : list) {
                        ConfigurationInterfaceManagerView.this.profileLeafs.add(new ProfileLeaf((Profile)object2, ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition));
                    }
                    object2 = ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition.getConfigurationInterfaceService().getAllEnvironments();
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Environment environment = (Environment)iterator.next();
                        ConfigurationInterfaceManagerView.this.environmentLeafs.add(new EnvironmentLeaf(environment, ConfigurationInterfaceManagerView.this.displayedCmrRepositoryDefinition));
                    }
                }
                return Status.OK_STATUS;
            }
        };
        if (iJobChangeListener != null) {
            job.addJobChangeListener(iJobChangeListener);
        }
        job.schedule();
    }

    private boolean isShowEnvironments() {
        return this.environmentSelection.getSelection();
    }

    private boolean isShowProfiles() {
        return this.profileSelection.getSelection();
    }

    public void showEnvironments(boolean bl) {
        if (!this.isShowEnvironments()) {
            this.environmentSelection.setSelection(true);
            this.profileSelection.setSelection(false);
        }
        this.performUpdate(bl);
    }

    public void showProfiles(boolean bl) {
        if (!this.isShowProfiles()) {
            this.profileSelection.setSelection(true);
            this.environmentSelection.setSelection(false);
        }
        this.performUpdate(bl);
    }

    public void setFocus() {
        if (this.tableViewer.getTable().isVisible()) {
            this.tableViewer.getTable().setFocus();
        } else {
            this.mainForm.setFocus();
        }
    }

    @Override
    public void refresh() {
        if (this.displayedCmrRepositoryDefinition != null && CmrRepositoryDefinition.OnlineStatus.OFFLINE != this.displayedCmrRepositoryDefinition.getOnlineStatus()) {
            this.performUpdate(true);
        } else if (this.displayedCmrRepositoryDefinition != null) {
            InspectIT.getDefault().getCmrRepositoryManager().forceCmrRepositoryOnlineStatusUpdate(this.displayedCmrRepositoryDefinition);
        }
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    protected String getMenuId() {
        return MENU_ID;
    }

    public void dispose() {
        this.cmrRepositoryManager.removeCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeProfileChangeListener(this);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeEnvironmentChangeListener(this);
        super.dispose();
    }

    private class SelectCmrAction
    extends Action {
        private CmrRepositoryDefinition cmrRepositoryDefinition;

        public SelectCmrAction(CmrRepositoryDefinition cmrRepositoryDefinition) {
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            this.setText(cmrRepositoryDefinition.getName());
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFormatter.getCmrRepositoryImage(cmrRepositoryDefinition, true)));
        }

        public void run() {
            ConfigurationInterfaceManagerView.this.ciRepositoryDefinitionChange(this.cmrRepositoryDefinition);
        }
    }
}

