/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.job;

import info.novatec.inspectit.ci.AgentMappings;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.AgentMappingInput;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenMappingsJob
extends Job {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private IWorkbenchPage activePage;

    public OpenMappingsJob(CmrRepositoryDefinition cmrRepositoryDefinition, IWorkbenchPage iWorkbenchPage) {
        super("Loading mappings..");
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.activePage = iWorkbenchPage;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return Status.CANCEL_STATUS;
        }
        try {
            AgentMappings agentMappings = this.cmrRepositoryDefinition.getConfigurationInterfaceService().getAgentMappings();
            Collection collection = this.cmrRepositoryDefinition.getConfigurationInterfaceService().getAllEnvironments();
            final AgentMappingInput agentMappingInput = new AgentMappingInput(this.cmrRepositoryDefinition, agentMappings, collection);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpenMappingsJob.this.activePage.openEditor((IEditorInput)agentMappingInput, "info.novatec.inspectit.rcp.ci.editor.agentMappingEditor", true);
                    }
                    catch (PartInitException partInitException) {
                        InspectIT.getDefault().createErrorDialog("Exception occurred opening the Agent mapping settings editor.", partInitException, -1);
                    }
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception exception) {
            return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred loading the data from the CMR.", (Throwable)exception);
        }
    }
}

