/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.handler;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ActivateProfileHandler
extends AbstractHandler
implements IHandler {
    public static final String ACTIVE_PARAM = "info.novatec.inspectit.rcp.ci.activateProfile.active";

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string = executionEvent.getParameter(ACTIVE_PARAM);
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Boolean bl = Boolean.parseBoolean(string);
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (structuredSelection.isEmpty()) {
            return null;
        }
        Object object = structuredSelection.getFirstElement();
        if (object instanceof IProfileProvider) {
            IProfileProvider iProfileProvider = (IProfileProvider)object;
            Profile profile = iProfileProvider.getProfile();
            CmrRepositoryDefinition cmrRepositoryDefinition = iProfileProvider.getCmrRepositoryDefinition();
            if (profile.isActive() != bl.booleanValue()) {
                profile.setActive(bl.booleanValue());
                try {
                    profile = cmrRepositoryDefinition.getConfigurationInterfaceService().updateProfile(profile);
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().profileUpdated(profile, cmrRepositoryDefinition, true);
                }
                catch (BusinessException businessException) {
                    throw new ExecutionException("Update of the profile active state failed.", (Throwable)businessException);
                }
            }
        }
        return null;
    }
}

