/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.TimerMethodSensorAssignment;
import info.novatec.inspectit.ci.context.AbstractContextCapture;
import info.novatec.inspectit.ci.context.impl.FieldContextCapture;
import info.novatec.inspectit.ci.context.impl.ParameterContextCapture;
import info.novatec.inspectit.ci.context.impl.ReturnContextCapture;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.dialog.CaptureContextDialog;
import info.novatec.inspectit.rcp.ci.form.part.ISensorAssignmentUpdateListener;
import info.novatec.inspectit.rcp.ci.form.part.MethodSensorAssignmentDetailsPage;
import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TimerSensorAssignmentDetailsPage
extends MethodSensorAssignmentDetailsPage {
    private TimerMethodSensorAssignment assignment;
    private List<AbstractContextCapture> contextCaptures = new ArrayList<AbstractContextCapture>();
    private Button captureContextButton;
    private TableViewer captureContextTableViewer;
    private Button addCaptureButton;
    private Button removeCaptureButton;
    private Button startInvocationButton;
    private Text minDurationText;
    private Button chartingButton;

    public TimerSensorAssignmentDetailsPage(ISensorAssignmentUpdateListener iSensorAssignmentUpdateListener, boolean bl) {
        super(iSensorAssignmentUpdateListener, bl);
    }

    @Override
    public void createContents(Composite composite) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 5;
        tableWrapLayout.leftMargin = 5;
        tableWrapLayout.rightMargin = 2;
        tableWrapLayout.bottomMargin = 2;
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)tableWrapLayout);
        FormToolkit formToolkit = this.managedForm.getToolkit();
        super.createContents(composite, false);
        Section section = formToolkit.createSection(composite, 320);
        section.setText("Sensor specific options");
        section.marginWidth = 10;
        section.marginHeight = 5;
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        section.setLayoutData((Object)tableWrapData);
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        formToolkit.createLabel(composite2, "Capture context:");
        this.captureContextButton = formToolkit.createButton(composite2, "Yes", 32);
        this.captureContextButton.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        this.createInfoLabel(composite2, formToolkit, "");
        formToolkit.createLabel(composite2, "");
        final Table table = formToolkit.createTable(composite2, 268503812);
        GridData gridData = new GridData(4, 4, false, false, 4, 1);
        gridData.heightHint = 120;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        this.captureContextTableViewer = new TableViewer(table);
        this.captureContextTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.captureContextTableViewer.setInput(this.contextCaptures);
        this.createColumnsForcaptureParametersTable();
        Composite composite3 = formToolkit.createComposite(composite2);
        composite3.setLayoutData((Object)new GridData(4, 128, false, false));
        composite3.setLayout((Layout)new FillLayout(512));
        this.addCaptureButton = formToolkit.createButton(composite3, "", 8);
        this.addCaptureButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/add_obj.gif"));
        this.removeCaptureButton = formToolkit.createButton(composite3, "", 8);
        this.removeCaptureButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_correction.gif"));
        formToolkit.createLabel(composite2, "");
        final ValidationControlDecoration<Table> validationControlDecoration = new ValidationControlDecoration<Table>(table, (IControlValidationListener)this){

            @Override
            protected boolean validate(Table table) {
                return !TimerSensorAssignmentDetailsPage.this.captureContextButton.getSelection() || !TimerSensorAssignmentDetailsPage.this.contextCaptures.isEmpty();
            }
        };
        validationControlDecoration.setDescriptionText("At least one capture context definition must be defined if the capture context is active.");
        this.addValidationControlDecoration(validationControlDecoration);
        this.captureContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = TimerSensorAssignmentDetailsPage.this.captureContextButton.getSelection();
                table.setEnabled(bl);
                TimerSensorAssignmentDetailsPage.this.addCaptureButton.setEnabled(bl);
                TimerSensorAssignmentDetailsPage.this.removeCaptureButton.setEnabled(bl);
                validationControlDecoration.executeValidation();
            }
        });
        this.addCaptureButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CaptureContextDialog captureContextDialog = new CaptureContextDialog(TimerSensorAssignmentDetailsPage.this.managedForm.getForm().getShell());
                if (captureContextDialog.open() == 0) {
                    AbstractContextCapture abstractContextCapture = captureContextDialog.getContextCapture();
                    TimerSensorAssignmentDetailsPage.this.contextCaptures.add(abstractContextCapture);
                    TimerSensorAssignmentDetailsPage.this.captureContextTableViewer.refresh();
                    validationControlDecoration.executeValidation();
                    TimerSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                }
            }
        });
        this.removeCaptureButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StructuredSelection structuredSelection = (StructuredSelection)TimerSensorAssignmentDetailsPage.this.captureContextTableViewer.getSelection();
                if (!structuredSelection.isEmpty()) {
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        TimerSensorAssignmentDetailsPage.this.contextCaptures.remove(object);
                        ++n2;
                    }
                    TimerSensorAssignmentDetailsPage.this.captureContextTableViewer.refresh();
                    validationControlDecoration.executeValidation();
                    TimerSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                }
            }
        });
        this.captureContextTableViewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                StructuredSelection structuredSelection = (StructuredSelection)TimerSensorAssignmentDetailsPage.this.captureContextTableViewer.getSelection();
                if (!structuredSelection.isEmpty()) {
                    AbstractContextCapture abstractContextCapture = (AbstractContextCapture)structuredSelection.getFirstElement();
                    CaptureContextDialog captureContextDialog = new CaptureContextDialog(TimerSensorAssignmentDetailsPage.this.managedForm.getForm().getShell(), abstractContextCapture);
                    if (captureContextDialog.open() == 0) {
                        AbstractContextCapture abstractContextCapture2 = captureContextDialog.getContextCapture();
                        int n = TimerSensorAssignmentDetailsPage.this.contextCaptures.indexOf(abstractContextCapture);
                        TimerSensorAssignmentDetailsPage.this.contextCaptures.remove(n);
                        TimerSensorAssignmentDetailsPage.this.contextCaptures.add(n, abstractContextCapture2);
                        TimerSensorAssignmentDetailsPage.this.captureContextTableViewer.refresh();
                        validationControlDecoration.executeValidation();
                        TimerSensorAssignmentDetailsPage.this.getMarkDirtyListener().handleEvent(event);
                    }
                }
            }
        });
        formToolkit.createLabel(composite2, "Charting:");
        this.chartingButton = formToolkit.createButton(composite2, "Yes", 32);
        this.chartingButton.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        this.createInfoLabel(composite2, formToolkit, "With the charting option it is possible to define what data should be considered as the long-term data available for charting in inspectIT User interface. This data is additionally saved to the database, thus even when the CMR is shutdown or buffer is cleared the data will be available via charts.");
        formToolkit.createLabel(composite2, "Starts invocation:");
        this.startInvocationButton = formToolkit.createButton(composite2, "Yes", 32);
        formToolkit.createLabel(composite2, "Min duration:", 131072).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minDurationText = formToolkit.createText(composite2, "", 133120);
        GridData gridData2 = new GridData(4, 4, false, false, 2, 1);
        gridData2.widthHint = 50;
        this.minDurationText.setLayoutData((Object)gridData2);
        formToolkit.createLabel(composite2, "");
        this.createInfoLabel(composite2, formToolkit, "Defines if method should start an invocation. Minimum duration defines the minimum time in milliseconds an invocation has to consume in order to be saved and transmitted to the server.");
        final ValidationControlDecoration<Text> validationControlDecoration2 = new ValidationControlDecoration<Text>(this.minDurationText, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                if (StringUtils.isNotEmpty((String)text.getText())) {
                    try {
                        return Long.parseLong(text.getText()) > 0L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return true;
            }
        };
        validationControlDecoration2.setDescriptionText("Value must be positive amount of milliseconds.");
        validationControlDecoration2.registerListener(24);
        this.addValidationControlDecoration(validationControlDecoration2);
        this.startInvocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimerSensorAssignmentDetailsPage.this.minDurationText.setEnabled(TimerSensorAssignmentDetailsPage.this.startInvocationButton.getSelection());
                validationControlDecoration2.executeValidation();
            }
        });
        this.captureContextButton.addListener(13, this.getMarkDirtyListener());
        this.chartingButton.addListener(13, this.getMarkDirtyListener());
        this.startInvocationButton.addListener(13, this.getMarkDirtyListener());
        this.minDurationText.addListener(24, this.getMarkDirtyListener());
        if (!this.isCanEdit()) {
            this.setEnabled(composite2, false);
        }
    }

    private void createColumnsForcaptureParametersTable() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.captureContextTableViewer, 0);
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setWidth(150);
        tableViewerColumn.getColumn().setText("Catch Type");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object object) {
                if (object instanceof ReturnContextCapture) {
                    return InspectIT.getDefault().getImage("/icons/selfmade/return.png");
                }
                if (object instanceof ParameterContextCapture) {
                    return InspectIT.getDefault().getImage("/icons/selfmade/parameter.png");
                }
                if (object instanceof FieldContextCapture) {
                    return InspectIT.getDefault().getImage("/icons/selfmade/field.png");
                }
                return null;
            }

            public String getText(Object object) {
                if (object instanceof ReturnContextCapture) {
                    return "Return value";
                }
                if (object instanceof ParameterContextCapture) {
                    return "Parameter index " + ((ParameterContextCapture)object).getIndex();
                }
                if (object instanceof FieldContextCapture) {
                    return "Field " + ((FieldContextCapture)object).getFieldName();
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.captureContextTableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(100);
        tableViewerColumn2.getColumn().setText("Name");
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((AbstractContextCapture)object).getDisplayName();
            }
        });
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.captureContextTableViewer, 0);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.getColumn().setWidth(100);
        tableViewerColumn3.getColumn().setText("Accessor Path");
        tableViewerColumn3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                List list = ((AbstractContextCapture)object).getPaths();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string : list) {
                        stringBuilder.append(" -> ");
                        stringBuilder.append(string);
                    }
                    return stringBuilder.toString();
                }
                return "";
            }
        });
    }

    @Override
    protected void updateFromInput() {
        super.updateFromInput();
        this.captureContextButton.setSelection(false);
        this.chartingButton.setSelection(false);
        this.startInvocationButton.setSelection(false);
        this.minDurationText.setEnabled(false);
        this.minDurationText.setText("");
        this.contextCaptures.clear();
        if (this.assignment != null) {
            if (CollectionUtils.isNotEmpty((Collection)this.assignment.getContextCaptures())) {
                this.captureContextButton.setSelection(true);
                this.captureContextTableViewer.getTable().setEnabled(this.isCanEdit());
                this.addCaptureButton.setEnabled(this.isCanEdit());
                this.removeCaptureButton.setEnabled(this.isCanEdit());
                this.contextCaptures.addAll(this.assignment.getContextCaptures());
            } else {
                this.captureContextButton.setSelection(false);
                this.captureContextTableViewer.getTable().setEnabled(false);
                this.addCaptureButton.setEnabled(false);
                this.removeCaptureButton.setEnabled(false);
            }
            this.chartingButton.setSelection(this.assignment.isCharting());
            if (this.assignment.isStartsInvocation()) {
                this.startInvocationButton.setSelection(true);
                this.minDurationText.setEnabled(this.isCanEdit());
                if (0L != this.assignment.getMinInvocationDuration()) {
                    this.minDurationText.setText(String.valueOf(this.assignment.getMinInvocationDuration()));
                }
            }
        }
        this.captureContextTableViewer.refresh();
    }

    @Override
    protected void commitToInput() {
        super.commitToInput();
        if (this.captureContextButton.getSelection() && CollectionUtils.isNotEmpty(this.contextCaptures)) {
            this.assignment.setContextCaptures(new ArrayList<AbstractContextCapture>(this.contextCaptures));
        } else {
            this.assignment.setContextCaptures(null);
        }
        this.assignment.setStartsInvocation(this.startInvocationButton.getSelection());
        if (this.startInvocationButton.getSelection()) {
            String string = this.minDurationText.getText();
            if (StringUtils.isNotBlank((String)string)) {
                try {
                    this.assignment.setMinInvocationDuration(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.assignment.setMinInvocationDuration(0L);
                }
            } else {
                this.assignment.setMinInvocationDuration(0L);
            }
        }
        this.assignment.setCharting(this.chartingButton.getSelection());
    }

    @Override
    protected MethodSensorAssignment getInput() {
        return this.assignment;
    }

    @Override
    protected void setInput(ISelection iSelection) {
        super.setInput(iSelection);
        this.assignment = !iSelection.isEmpty() ? (TimerMethodSensorAssignment)((IStructuredSelection)iSelection).getFirstElement() : null;
    }
}

