/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.ci.assignment.AbstractClassSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.ExceptionSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.TimerMethodSensorAssignment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.dialog.SensorAssignmentSelectionDialog;
import info.novatec.inspectit.rcp.ci.form.input.ProfileEditorInput;
import info.novatec.inspectit.rcp.ci.form.part.ExceptionSensorAssignmentDetailsPage;
import info.novatec.inspectit.rcp.ci.form.part.ISensorAssignmentUpdateListener;
import info.novatec.inspectit.rcp.ci.form.part.MethodSensorAssignmentDetailsPage;
import info.novatec.inspectit.rcp.ci.form.part.TimerSensorAssignmentDetailsPage;
import info.novatec.inspectit.rcp.ci.widget.SensorAssignmentTableProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SensorAssignmentMasterBlock
extends MasterDetailsBlock
implements IFormPart,
IPartSelectionListener,
ISelectionChangedListener,
IPropertyListener {
    private boolean canEdit = true;
    private Profile profile;
    private Map<Class<? extends ISensorConfig>, List<AbstractClassSensorAssignment<?>>> configToAssignmentMap = new HashMap();
    private Map<Class<? extends ISensorConfig>, CTabItem> sensorToTabMap = new HashMap<Class<? extends ISensorConfig>, CTabItem>();
    private Map<AbstractClassSensorAssignment<?>, String> invalidAssignments = new IdentityHashMap();
    private List<TableViewer> tableViewers = new ArrayList<TableViewer>();
    private List<TableItemControlDecoration> tableItemControlDecorations = new ArrayList<TableItemControlDecoration>();
    private AbstractClassSensorAssignment<?> selectedAssignment;
    private boolean dirty;
    private FormPage formPage;
    private IManagedForm managedForm;
    private CTabFolder tabFolder;
    private Button addButton;
    private Button removeButton;
    private Button duplicateButton;
    private Composite emptyHintComposite;

    public SensorAssignmentMasterBlock(FormPage formPage) {
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        ProfileEditorInput profileEditorInput = (ProfileEditorInput)formPage.getEditor().getEditorInput();
        this.profile = profileEditorInput.getProfile();
    }

    public void createContent(IManagedForm iManagedForm, Composite composite) {
        super.createContent(iManagedForm, composite);
        this.sashForm.setWeights(new int[]{3, 4});
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPart = detailsPart;
        MasterBlockValidationListener masterBlockValidationListener = new MasterBlockValidationListener();
        detailsPart.registerPage(MethodSensorAssignment.class, (IDetailsPage)new MethodSensorAssignmentDetailsPage(masterBlockValidationListener, !this.profile.isCommonProfile()));
        detailsPart.registerPage(TimerMethodSensorAssignment.class, (IDetailsPage)new TimerSensorAssignmentDetailsPage(masterBlockValidationListener, !this.profile.isCommonProfile()));
        detailsPart.registerPage(ExceptionSensorAssignment.class, (IDetailsPage)new ExceptionSensorAssignmentDetailsPage(masterBlockValidationListener, !this.profile.isCommonProfile()));
    }

    protected void createToolBarActions(IManagedForm iManagedForm) {
    }

    protected void createMasterPart(final IManagedForm iManagedForm, Composite composite) {
        this.managedForm = iManagedForm;
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 4160);
        section.marginWidth = 10;
        section.marginHeight = 5;
        final Composite composite2 = formToolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                iManagedForm.getForm().reflow(false);
            }
        });
        iManagedForm.addPart((IFormPart)this);
        this.tabFolder = new CTabFolder(composite2, 2176);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 100;
        gridData.widthHint = 300;
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabFolder.setSelectionBackground(new Color[]{formToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START"), formToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END")}, new int[]{100}, true);
        this.tabFolder.setTabHeight(30);
        formToolkit.adapt((Composite)this.tabFolder);
        Composite composite3 = formToolkit.createComposite(composite2);
        GridLayout gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        gridData = new GridData(131072, 128, false, false);
        gridData.widthHint = 50;
        composite3.setLayoutData((Object)gridData);
        this.addButton = formToolkit.createButton(composite3, "", 8);
        this.addButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/add_obj.gif"));
        this.addButton.setToolTipText("Add");
        this.addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractClassSensorAssignment abstractClassSensorAssignment = SensorAssignmentMasterBlock.this.addRequested();
                if (abstractClassSensorAssignment != null) {
                    SensorAssignmentMasterBlock.this.addToInputMap(abstractClassSensorAssignment);
                    CTabItem cTabItem = (CTabItem)SensorAssignmentMasterBlock.this.sensorToTabMap.get(abstractClassSensorAssignment.getSensorConfigClass());
                    if (cTabItem == null) {
                        SensorAssignmentMasterBlock.this.createNewTabItem(abstractClassSensorAssignment.getSensorConfigClass(), (List)SensorAssignmentMasterBlock.this.configToAssignmentMap.get(abstractClassSensorAssignment.getSensorConfigClass()));
                        cTabItem = (CTabItem)SensorAssignmentMasterBlock.this.sensorToTabMap.get(abstractClassSensorAssignment.getSensorConfigClass());
                    }
                    SensorAssignmentMasterBlock.this.tabFolder.setSelection(cTabItem);
                    TableViewer tableViewer = SensorAssignmentMasterBlock.this.getActiveTableViewer();
                    tableViewer.refresh();
                    StructuredSelection structuredSelection = new StructuredSelection((Object)abstractClassSensorAssignment);
                    tableViewer.setSelection((ISelection)structuredSelection, true);
                    SensorAssignmentMasterBlock.this.showHideFormMessage();
                    SensorAssignmentMasterBlock.this.markDirty();
                }
            }
        });
        this.removeButton = formToolkit.createButton(composite3, "", 8);
        this.removeButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_correction.gif"));
        this.removeButton.setToolTipText("Remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SensorAssignmentMasterBlock.this.fireRemove();
            }
        });
        this.duplicateButton = formToolkit.createButton(composite3, "", 8);
        this.duplicateButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/copy_edit.gif"));
        this.duplicateButton.setToolTipText("Duplicate");
        this.duplicateButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableViewer tableViewer = SensorAssignmentMasterBlock.this.getActiveTableViewer();
                StructuredSelection structuredSelection = (StructuredSelection)tableViewer.getSelection();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof AbstractClassSensorAssignment) {
                        try {
                            AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)((AbstractClassSensorAssignment)object).clone();
                            SensorAssignmentMasterBlock.this.addToInputMap(abstractClassSensorAssignment);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            InspectIT.getDefault().log(2, "Unable to clone sensor assignment.", cloneNotSupportedException);
                        }
                    }
                    ++n2;
                }
                tableViewer.refresh();
                SensorAssignmentMasterBlock.this.markDirty();
                SensorAssignmentMasterBlock.this.showHideFormMessage();
            }
        });
        this.sashForm.setOrientation(512);
        this.canEditCheck();
        Map<Class<ISensorConfig>, List<AbstractClassSensorAssignment<?>>> map = this.getInput();
        if (MapUtils.isNotEmpty(map)) {
            for (Map.Entry<Class<ISensorConfig>, List<AbstractClassSensorAssignment<?>>> entry : map.entrySet()) {
                this.createNewTabItem(entry.getKey(), entry.getValue());
            }
        } else {
            this.createEmptyInputHint();
        }
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableViewer tableViewer = SensorAssignmentMasterBlock.this.getActiveTableViewer();
                if (tableViewer != null) {
                    tableViewer.refresh();
                    tableViewer.getTable().setFocus();
                    SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)tableViewer, tableViewer.getSelection());
                    SensorAssignmentMasterBlock.this.selectionChanged(selectionChangedEvent);
                    composite2.getParent().redraw();
                }
            }
        });
        this.showHideFormMessage();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (structuredSelection.getFirstElement() == this.selectedAssignment) {
            return;
        }
        this.updateButtonsState((ISelection)structuredSelection);
        this.fireEdit(selectionChangedEvent.getSelection());
    }

    private void canEditCheck() {
        boolean bl = this.canEdit = !this.profile.isCommonProfile();
        if (!this.canEdit) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.duplicateButton.setEnabled(false);
        }
    }

    private TableViewer getActiveTableViewer() {
        int n = this.tabFolder.getSelectionIndex();
        if (n != -1 && CollectionUtils.isNotEmpty(this.tableViewers)) {
            return this.tableViewers.get(n);
        }
        return null;
    }

    private void createNewTabItem(Class<? extends ISensorConfig> clazz, List<AbstractClassSensorAssignment<?>> list) {
        if (this.emptyHintComposite != null && !this.emptyHintComposite.isDisposed()) {
            this.tabFolder.getItem(0).dispose();
            this.emptyHintComposite.dispose();
        }
        SensorAssignmentTableProvider sensorAssignmentTableProvider = new SensorAssignmentTableProvider(this, (Composite)this.tabFolder);
        sensorAssignmentTableProvider.setInput(list);
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setControl((Control)sensorAssignmentTableProvider.getTableViewer().getTable());
        cTabItem.setText(TextFormatter.getSensorConfigName(clazz));
        cTabItem.setImage(ImageFormatter.getSensorConfigImage(clazz));
        this.sensorToTabMap.put(clazz, cTabItem);
        TableViewer tableViewer = sensorAssignmentTableProvider.getTableViewer();
        tableViewer.getTable().setData(clazz);
        this.tableViewers.add(tableViewer);
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    SensorAssignmentMasterBlock.this.fireRemove();
                }
            }
        });
    }

    private void removeTabItem(Class<? extends ISensorConfig> clazz) {
        CTabItem cTabItem = this.sensorToTabMap.remove(clazz);
        if (cTabItem != null) {
            int n = this.tabFolder.indexOf(cTabItem);
            this.tableViewers.remove(n);
            cTabItem.dispose();
        }
        if (CollectionUtils.isEmpty(this.tableViewers)) {
            this.createEmptyInputHint();
        }
    }

    private void createEmptyInputHint() {
        FormToolkit formToolkit = this.managedForm.getToolkit();
        this.emptyHintComposite = formToolkit.createComposite((Composite)this.tabFolder, 0);
        this.emptyHintComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = formToolkit.createLabel(this.emptyHintComposite, null);
        label.setImage(Display.getDefault().getSystemImage(2));
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        FormText formText = formToolkit.createFormText(this.emptyHintComposite, false);
        formText.setText("<form><p>Seems that there are no sensor assignments in this profile. Use <b>Add</b> action to start defining instrumentation points.</p></form>", true, false);
        formText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setControl((Control)this.emptyHintComposite);
        cTabItem.setText("Getting Started");
        this.tabFolder.setSelection(0);
    }

    private void showHideFormMessage() {
        if (this.profile.isCommonProfile()) {
            this.managedForm.getMessageManager().addMessage((Object)this, "Common profiles can not be edited", null, 0);
        } else if (this.configToAssignmentMap.isEmpty()) {
            this.managedForm.getMessageManager().addMessage((Object)this, "No sensor assignment defined", null, 1);
        } else {
            this.managedForm.getMessageManager().removeMessage((Object)this);
        }
    }

    private AbstractClassSensorAssignment<?> addRequested() {
        SensorAssignmentSelectionDialog sensorAssignmentSelectionDialog = new SensorAssignmentSelectionDialog(this.managedForm.getForm().getShell());
        if (sensorAssignmentSelectionDialog.open() == 0) {
            return sensorAssignmentSelectionDialog.getSensorAssignment();
        }
        return null;
    }

    private void fireRemove() {
        Object object;
        if (!this.canEdit) {
            return;
        }
        TableViewer tableViewer = this.getActiveTableViewer();
        if (tableViewer == null) {
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)tableViewer.getSelection();
        if (structuredSelection.isEmpty()) {
            return;
        }
        Class clazz = null;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (object instanceof AbstractClassSensorAssignment) {
                AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)object;
                clazz = abstractClassSensorAssignment.getSensorConfigClass();
                this.removeFromInputMap(abstractClassSensorAssignment);
                this.formPage.getManagedForm().getMessageManager().removeMessage(this.getMessageKey(abstractClassSensorAssignment));
            }
            ++n2;
        }
        object = new RemoveSelection(structuredSelection.toList());
        this.fireEdit((ISelection)object);
        tableViewer.refresh();
        for (Map.Entry<AbstractClassSensorAssignment<?>, String> entry : this.invalidAssignments.entrySet()) {
            this.showTableItemControlDecoration(entry.getKey(), entry.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)this.configToAssignmentMap.get(clazz))) {
            this.removeTabItem(clazz);
        }
        this.markDirty();
        this.showHideFormMessage();
    }

    private Map<Class<? extends ISensorConfig>, List<AbstractClassSensorAssignment<?>>> getInput() {
        this.configToAssignmentMap.clear();
        if (CollectionUtils.isNotEmpty((Collection)this.profile.getMethodSensorAssignments())) {
            for (MethodSensorAssignment methodSensorAssignment : this.profile.getMethodSensorAssignments()) {
                this.addToInputMap((AbstractClassSensorAssignment<?>)methodSensorAssignment);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)this.profile.getExceptionSensorAssignments())) {
            for (MethodSensorAssignment methodSensorAssignment : this.profile.getExceptionSensorAssignments()) {
                this.addToInputMap((AbstractClassSensorAssignment<?>)methodSensorAssignment);
            }
        }
        return this.configToAssignmentMap;
    }

    private void addToInputMap(AbstractClassSensorAssignment<?> abstractClassSensorAssignment) {
        Class clazz = abstractClassSensorAssignment.getSensorConfigClass();
        List<AbstractClassSensorAssignment<?>> list = this.configToAssignmentMap.get(clazz);
        if (list == null) {
            list = new ArrayList();
            this.configToAssignmentMap.put(clazz, list);
        }
        list.add(abstractClassSensorAssignment);
    }

    private void removeFromInputMap(AbstractClassSensorAssignment<?> abstractClassSensorAssignment) {
        Class clazz = abstractClassSensorAssignment.getSensorConfigClass();
        List<AbstractClassSensorAssignment<?>> list = this.configToAssignmentMap.get(clazz);
        if (list != null) {
            list.remove(abstractClassSensorAssignment);
            if (list.isEmpty()) {
                this.configToAssignmentMap.remove(clazz);
            }
        }
        this.invalidAssignments.remove(abstractClassSensorAssignment);
    }

    private void updateButtonsState(ISelection iSelection) {
        if (iSelection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.duplicateButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(this.canEdit);
            this.duplicateButton.setEnabled(this.canEdit);
        }
        this.addButton.setEnabled(this.canEdit);
    }

    private void fireEdit(ISelection iSelection) {
        this.managedForm.fireSelectionChanged((IFormPart)this, iSelection);
        this.selectedAssignment = iSelection.isEmpty() ? null : (AbstractClassSensorAssignment)((StructuredSelection)iSelection).getFirstElement();
        this.updateButtonsState(iSelection);
    }

    private void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.managedForm.dirtyStateChanged();
        }
    }

    private void showTableItemControlDecoration(AbstractClassSensorAssignment<?> abstractClassSensorAssignment, String string) {
        TableViewer tableViewer = this.getActiveTableViewer();
        if (tableViewer == null) {
            return;
        }
        for (TableItemControlDecoration tableItemControlDecoration : this.tableItemControlDecorations) {
            if (abstractClassSensorAssignment != tableItemControlDecoration.getAssignment()) continue;
            tableItemControlDecoration.show();
            tableItemControlDecoration.setDescriptionText(string);
            return;
        }
        TableItem[] tableItemArray = tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItemControlDecoration tableItemControlDecoration;
            tableItemControlDecoration = tableItemArray[n2];
            if (tableItemControlDecoration.getData() == abstractClassSensorAssignment) {
                TableItemControlDecoration tableItemControlDecoration2 = new TableItemControlDecoration((TableItem)tableItemControlDecoration);
                tableItemControlDecoration2.show();
                tableItemControlDecoration2.setDescriptionText(string);
                this.tableItemControlDecorations.add(tableItemControlDecoration2);
                return;
            }
            ++n2;
        }
    }

    private void hideTableItemControlDecoration(AbstractClassSensorAssignment<?> abstractClassSensorAssignment) {
        TableViewer tableViewer = this.getActiveTableViewer();
        if (tableViewer == null) {
            return;
        }
        for (TableItemControlDecoration tableItemControlDecoration : this.tableItemControlDecorations) {
            if (abstractClassSensorAssignment != tableItemControlDecoration.getAssignment()) continue;
            tableItemControlDecoration.hide();
            return;
        }
    }

    private Object getMessageKey(AbstractClassSensorAssignment<?> abstractClassSensorAssignment) {
        return System.identityHashCode(abstractClassSensorAssignment);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void commit(boolean bl) {
        if (bl) {
            this.dirty = false;
            ArrayList<MethodSensorAssignment> arrayList = new ArrayList<MethodSensorAssignment>();
            ArrayList<ExceptionSensorAssignment> arrayList2 = new ArrayList<ExceptionSensorAssignment>();
            for (List<AbstractClassSensorAssignment<?>> list : this.configToAssignmentMap.values()) {
                for (AbstractClassSensorAssignment<?> abstractClassSensorAssignment : list) {
                    if (abstractClassSensorAssignment instanceof MethodSensorAssignment) {
                        arrayList.add((MethodSensorAssignment)abstractClassSensorAssignment);
                        continue;
                    }
                    if (!(abstractClassSensorAssignment instanceof ExceptionSensorAssignment)) continue;
                    arrayList2.add((ExceptionSensorAssignment)abstractClassSensorAssignment);
                }
            }
            this.profile.setMethodSensorAssignments(arrayList);
            this.profile.setExceptionSensorAssignments(arrayList2);
        }
    }

    public void initialize(IManagedForm iManagedForm) {
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        this.updateButtonsState((ISelection)((StructuredSelection)iSelection));
        this.fireEdit(iSelection);
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            ProfileEditorInput profileEditorInput = (ProfileEditorInput)this.formPage.getEditor().getEditorInput();
            this.profile = profileEditorInput.getProfile();
        }
    }

    private String getErroMessageShort(AbstractClassSensorAssignment<?> abstractClassSensorAssignment, List<ValidationControlDecoration<?>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextFormatter.getSensorConfigName(abstractClassSensorAssignment.getSensorConfigClass()));
        stringBuilder.append(" Assignment (");
        int n = 0;
        for (ValidationControlDecoration<?> validationControlDecoration : list) {
            if (validationControlDecoration.isValid()) continue;
            ++n;
        }
        stringBuilder.append(n);
        if (n > 1) {
            stringBuilder.append(" fields contain validation errors)");
        } else {
            stringBuilder.append(" field contains validation error)");
        }
        return stringBuilder.toString();
    }

    private String getErroMessageFull(AbstractClassSensorAssignment<?> abstractClassSensorAssignment, List<ValidationControlDecoration<?>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextFormatter.getSensorConfigName(abstractClassSensorAssignment.getSensorConfigClass()));
        stringBuilder.append(" Assignment:");
        IMessagePrefixProvider iMessagePrefixProvider = this.managedForm.getMessageManager().getMessagePrefixProvider();
        for (ValidationControlDecoration<?> validationControlDecoration : list) {
            if (validationControlDecoration.isValid()) continue;
            stringBuilder.append('\n');
            String string = iMessagePrefixProvider.getPrefix(validationControlDecoration.getControl());
            if (!": ".equals(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(validationControlDecoration.getDescriptionText());
        }
        return stringBuilder.toString();
    }

    private class MasterBlockValidationListener
    implements ISensorAssignmentUpdateListener {
        private MasterBlockValidationListener() {
        }

        @Override
        public void sensorAssignmentUpdated(AbstractClassSensorAssignment<?> abstractClassSensorAssignment, boolean bl, boolean bl2, List<ValidationControlDecoration<?>> list) {
            Object object;
            Assert.isNotNull(abstractClassSensorAssignment);
            if (bl) {
                object = SensorAssignmentMasterBlock.this.getActiveTableViewer();
                object.refresh();
                SensorAssignmentMasterBlock.this.markDirty();
            }
            object = SensorAssignmentMasterBlock.this.getMessageKey(abstractClassSensorAssignment);
            if (!bl2) {
                String string = SensorAssignmentMasterBlock.this.getErroMessageFull(abstractClassSensorAssignment, list);
                SensorAssignmentMasterBlock.this.invalidAssignments.put(abstractClassSensorAssignment, string);
                SensorAssignmentMasterBlock.this.showTableItemControlDecoration(abstractClassSensorAssignment, string);
                SensorAssignmentMasterBlock.this.formPage.getManagedForm().getMessageManager().addMessage(object, SensorAssignmentMasterBlock.this.getErroMessageShort(abstractClassSensorAssignment, list), null, 3);
            } else {
                SensorAssignmentMasterBlock.this.invalidAssignments.remove(abstractClassSensorAssignment);
                SensorAssignmentMasterBlock.this.hideTableItemControlDecoration(abstractClassSensorAssignment);
                SensorAssignmentMasterBlock.this.formPage.getManagedForm().getMessageManager().removeMessage(object);
            }
        }
    }

    public static class RemoveSelection
    extends StructuredSelection {
        public RemoveSelection(List<?> list) {
            super(list);
        }
    }

    private class TableItemControlDecoration
    extends ControlDecoration {
        private TableItem tableItem;
        private TableEditor tableEditor;
        private AbstractClassSensorAssignment<?> assignment;

        public TableItemControlDecoration(TableItem tableItem) {
            super((Control)new Composite((Composite)tableItem.getParent(), 0), 1024);
            Assert.isNotNull((Object)tableItem);
            Assert.isLegal((boolean)(tableItem.getData() instanceof AbstractClassSensorAssignment));
            this.tableItem = tableItem;
            this.assignment = (AbstractClassSensorAssignment)tableItem.getData();
            this.tableEditor = new TableEditor(tableItem.getParent());
            this.tableEditor.horizontalAlignment = 16384;
            this.tableEditor.verticalAlignment = 1024;
            this.tableEditor.setEditor(this.getControl(), tableItem, 0);
            this.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            this.hide();
            tableItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    SensorAssignmentMasterBlock.this.tableItemControlDecorations.remove((Object)TableItemControlDecoration.this);
                    TableItemControlDecoration.this.hide();
                    TableItemControlDecoration.this.dispose();
                }
            });
        }

        public AbstractClassSensorAssignment<?> getAssignment() {
            return this.assignment;
        }

        public void dispose() {
            Control control = this.getControl();
            if (!this.tableItem.isDisposed()) {
                this.tableEditor.dispose();
            }
            super.dispose();
            if (control != null) {
                control.dispose();
            }
        }
    }
}

