/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.AgentMapping;
import info.novatec.inspectit.ci.AgentMappings;
import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.dialog.AgentMappingDialog;
import info.novatec.inspectit.rcp.ci.form.input.AgentMappingInput;
import info.novatec.inspectit.rcp.ci.listener.IEnvironmentChangeListener;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AgentMappingPart
extends AbstractFormPart
implements IEnvironmentChangeListener,
IPropertyListener {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private AgentMappings agentMappings;
    private Collection<AgentMapping> inputList;
    private List<Environment> environments;
    private IManagedForm managedForm;
    private FormPage formPage;
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button editButton;

    public AgentMappingPart(FormPage formPage, Composite composite, FormToolkit formToolkit) {
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.managedForm = formPage.getManagedForm();
        AgentMappingInput agentMappingInput = (AgentMappingInput)formPage.getEditor().getEditorInput();
        this.cmrRepositoryDefinition = agentMappingInput.getCmrRepositoryDefinition();
        this.agentMappings = agentMappingInput.getAgentMappings();
        this.inputList = new ArrayList<AgentMapping>();
        this.environments = new ArrayList<Environment>(agentMappingInput.getEnvironments());
        if (CollectionUtils.isNotEmpty((Collection)this.agentMappings.getMappings())) {
            this.inputList.addAll(this.agentMappings.getMappings());
        }
        this.createPart(composite, formToolkit);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addEnvironmentChangeListener(this);
    }

    private void createPart(Composite composite, FormToolkit formToolkit) {
        Composite composite2 = formToolkit.createComposite(composite, 1);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Table table = formToolkit.createTable(composite2, 68386);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AgentMappingLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AgentMappingPart.this.updateButtonsState();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem;
                Object object;
                if (selectionEvent.detail == 32 && selectionEvent.item instanceof TableItem && (object = (tableItem = (TableItem)selectionEvent.item).getData()) instanceof AgentMapping) {
                    ((AgentMapping)object).setActive(tableItem.getChecked());
                    AgentMappingPart.this.tableViewer.update(object, null);
                    AgentMappingPart.this.markDirty();
                }
            }
        });
        Composite composite3 = formToolkit.createComposite(composite2, 1);
        GridLayout gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.widthHint = 50;
        composite3.setLayoutData((Object)gridData);
        this.addButton = formToolkit.createButton(composite3, "", 8);
        this.addButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/add_obj.gif"));
        this.addButton.setToolTipText("Add");
        this.addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AgentMappingDialog agentMappingDialog = new AgentMappingDialog(AgentMappingPart.this.getManagedForm().getForm().getShell(), AgentMappingPart.this.environments);
                if (agentMappingDialog.open() == 0) {
                    AgentMapping agentMapping = agentMappingDialog.getAgentMapping();
                    agentMapping.setEnvironmentId(((Environment)AgentMappingPart.this.environments.iterator().next()).getId());
                    AgentMappingPart.this.inputList.add(agentMapping);
                    AgentMappingPart.this.updateInternal(true);
                }
            }
        });
        this.editButton = formToolkit.createButton(composite3, "", 8);
        this.editButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/edit.gif"));
        this.editButton.setToolTipText("Edit");
        this.editButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AgentMappingPart.this.fireEdit();
            }
        });
        this.removeButton = formToolkit.createButton(composite3, "", 8);
        this.removeButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_correction.gif"));
        this.removeButton.setToolTipText("Remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AgentMappingPart.this.fireRemove();
            }
        });
        Button button = formToolkit.createButton(composite3, "", 8);
        button.setImage(InspectIT.getDefault().getImage("/icons/eclipse/test.gif"));
        button.setToolTipText("Test Mappings");
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        button.setEnabled(false);
        this.tableViewer.setInput(this.inputList);
        this.updateCheckedItems();
        this.checkEnvironments();
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000B) {
                    AgentMappingPart.this.fireEdit();
                } else if (keyEvent.keyCode == 127) {
                    AgentMappingPart.this.fireRemove();
                }
            }
        });
    }

    public void commit(boolean bl) {
        if (!bl) {
            return;
        }
        super.commit(bl);
        if (bl) {
            this.agentMappings.setMappings(this.inputList);
        }
    }

    private void fireRemove() {
        StructuredSelection structuredSelection = (StructuredSelection)this.tableViewer.getSelection();
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof AgentMapping) {
                this.inputList.remove((AgentMapping)object);
            }
            ++n2;
        }
        this.updateInternal(true);
    }

    private void fireEdit() {
        AgentMappingDialog agentMappingDialog;
        StructuredSelection structuredSelection = (StructuredSelection)this.tableViewer.getSelection();
        Object object = structuredSelection.getFirstElement();
        if (object instanceof AgentMapping && (agentMappingDialog = new AgentMappingDialog(this.getManagedForm().getForm().getShell(), (AgentMapping)object, this.environments)).open() == 0) {
            this.updateInternal(true);
        }
    }

    private void updateInternal(boolean bl) {
        this.tableViewer.refresh();
        this.updateCheckedItems();
        this.updateButtonsState();
        if (bl) {
            this.markDirty();
        }
    }

    private void createColumns() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.getColumn().setWidth(60);
        tableViewerColumn.getColumn().setText("Active");
        tableViewerColumn.getColumn().setToolTipText("If mapping is currently active. Deactivated mappings will not be considered when assigning Environment to the agent.");
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(150);
        tableViewerColumn2.getColumn().setText("Agent Name");
        tableViewerColumn2.getColumn().setToolTipText("Name of the agent. Use wild-card '*' for matching several agent names with one mapping.");
        tableViewerColumn2.getColumn().setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.getColumn().setWidth(150);
        tableViewerColumn3.getColumn().setText("IP Address");
        tableViewerColumn3.getColumn().setToolTipText("IP address of the agent. Use wild-card '*' for matching several IPs with one mapping. For example, 192.168.* will match all IP addresses in starting with 192.168.");
        tableViewerColumn3.getColumn().setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
        TableViewerColumn tableViewerColumn4 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn4.getColumn().setResizable(true);
        tableViewerColumn4.getColumn().setWidth(150);
        tableViewerColumn4.getColumn().setText("Environment");
        tableViewerColumn4.getColumn().setToolTipText("Environment that should be assigned to the agent fulfilling the name and IP parameters.");
        tableViewerColumn4.getColumn().setImage(InspectIT.getDefault().getImage("/icons/fugue/block.png"));
        TableViewerColumn tableViewerColumn5 = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn5.getColumn().setResizable(true);
        tableViewerColumn5.getColumn().setWidth(200);
        tableViewerColumn5.getColumn().setText("Description");
        tableViewerColumn5.getColumn().setToolTipText("Optional description of the mapping.");
    }

    private void updateCheckedItems() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof AgentMapping) {
                tableItem.setChecked(((AgentMapping)object).isActive());
            }
            ++n2;
        }
    }

    private void updateButtonsState() {
        StructuredSelection structuredSelection = (StructuredSelection)this.tableViewer.getSelection();
        if (structuredSelection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(structuredSelection.size() == 1);
        }
    }

    @Override
    public void environmentCreated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.cmrRepositoryDefinition)) {
            return;
        }
        this.environments.add(environment);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AgentMappingPart.this.checkEnvironments();
            }
        });
    }

    @Override
    public void environmentUpdated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.cmrRepositoryDefinition)) {
            return;
        }
        Iterator<Environment> iterator = this.environments.iterator();
        while (iterator.hasNext()) {
            Environment environment2 = iterator.next();
            if (!Objects.equals(environment2.getId(), environment.getId())) continue;
            int n = this.environments.indexOf(environment2);
            iterator.remove();
            this.environments.add(n, environment);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AgentMappingPart.this.tableViewer.refresh();
                }
            });
            break;
        }
    }

    @Override
    public void environmentDeleted(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!Objects.equals(cmrRepositoryDefinition, this.cmrRepositoryDefinition)) {
            return;
        }
        Iterator<Environment> iterator = this.environments.iterator();
        while (iterator.hasNext()) {
            Environment environment2 = iterator.next();
            if (!Objects.equals(environment2.getId(), environment.getId())) continue;
            iterator.remove();
            final ArrayList<AgentMapping> arrayList = new ArrayList<AgentMapping>();
            for (AgentMapping agentMapping : this.inputList) {
                if (!Objects.equals(agentMapping.getEnvironmentId(), environment.getId())) continue;
                arrayList.add(agentMapping);
            }
            this.inputList.removeAll(arrayList);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AgentMappingPart.this.tableViewer.remove(arrayList.toArray());
                    AgentMappingPart.this.checkEnvironments();
                }
            });
            break;
        }
    }

    private void checkEnvironments() {
        if (CollectionUtils.isEmpty(this.environments)) {
            this.tableViewer.getTable().setEnabled(false);
            this.addButton.setEnabled(false);
            this.managedForm.getForm().setMessage("No environment exists on the selected CMR, mapping can not be defined.", 3);
        } else {
            this.tableViewer.getTable().setEnabled(true);
            this.addButton.setEnabled(true);
            this.managedForm.getForm().setMessage("Define agent mapping properties for the '" + this.cmrRepositoryDefinition.getName() + "' repository.", 0);
        }
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            AgentMappingInput agentMappingInput = (AgentMappingInput)this.formPage.getEditor().getEditorInput();
            this.agentMappings = agentMappingInput.getAgentMappings();
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeEnvironmentChangeListener(this);
        super.dispose();
    }

    private class AgentMappingLabelProvider
    extends StyledCellIndexLabelProvider {
        private final StyledString empty = new StyledString();

        private AgentMappingLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            if (object instanceof AgentMapping) {
                AgentMapping agentMapping = (AgentMapping)object;
                switch (n) {
                    case 1: {
                        return TextFormatter.emptyStyledStringIfNull(agentMapping.getAgentName());
                    }
                    case 2: {
                        return TextFormatter.emptyStyledStringIfNull(agentMapping.getIpAddress());
                    }
                    case 3: {
                        String string = agentMapping.getEnvironmentId();
                        for (Environment environment : AgentMappingPart.this.environments) {
                            if (!Objects.equals(string, environment.getId())) continue;
                            return TextFormatter.emptyStyledStringIfNull(environment.getName());
                        }
                        return this.empty;
                    }
                    case 4: {
                        return TextFormatter.emptyStyledStringIfNull(TextFormatter.clearLineBreaks(agentMapping.getDescription()));
                    }
                }
                return this.empty;
            }
            return this.empty;
        }

        @Override
        protected Color getForeground(Object object, int n) {
            AgentMapping agentMapping;
            if (object instanceof AgentMapping && !(agentMapping = (AgentMapping)object).isActive()) {
                return AgentMappingPart.this.tableViewer.getTable().getDisplay().getSystemColor(16);
            }
            return super.getForeground(object, n);
        }
    }
}

